/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.context;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ContextPutAction
implements Action {
    private final Logger logger;
    private final Map<String, Object> entries;

    public ContextPutAction(Logger logger, @Input(value="entries") Map<String, Object> entries) {
        this.logger = logger;
        this.entries = Optional.ofNullable(entries).orElse(Collections.emptyMap());
    }

    public ActionExecutionResult execute() {
        this.entries.forEach((key, value) -> this.logger.info("Adding to context " + key + " = " + this.prettyLog(value) + " " + this.logClassType(value)));
        return ActionExecutionResult.ok(this.entries);
    }

    private String prettyLog(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof Object[]) {
            return Arrays.toString((Object[])value);
        }
        if (value instanceof List) {
            return Arrays.toString(((List)value).toArray());
        }
        if (value instanceof Map) {
            return Arrays.toString(((Map)value).entrySet().toArray());
        }
        return ToStringBuilder.reflectionToString((Object)value, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE);
    }

    private String logClassType(Object value) {
        return value != null ? "(" + value.getClass().getSimpleName() + ")" : "";
    }
}

