/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.common;

import com.chutneytesting.action.assertion.XsdValidationAction;
import com.chutneytesting.action.common.LSInputImpl;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ResourceResolver
implements LSResourceResolver {
    private final String urlPrefix;
    private final Path rootResourcePath;
    private List<String> urlPrefixes = Arrays.asList("classpath:", "file:");

    public ResourceResolver(String rootFilePath) {
        this.urlPrefix = this.urlPrefixes.stream().filter(rootFilePath::startsWith).findFirst().orElse("classpath:");
        this.rootResourcePath = Path.of(rootFilePath.replaceFirst(this.urlPrefix, ""), new String[0]).getParent();
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            Path xsdPath = this.rootResourcePath.resolve(systemId);
            if (StringUtils.isNotEmpty((CharSequence)baseURI)) {
                xsdPath = this.rootResourcePath.resolve(this.getParentResourcePath(baseURI)).resolve(systemId);
            }
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader(XsdValidationAction.class.getClassLoader());
            Resource resource = resourceLoader.getResource(this.urlPrefix + xsdPath);
            LSInputImpl input = new LSInputImpl();
            input.setPublicId(publicId);
            input.setSystemId(systemId);
            input.setBaseURI(baseURI);
            input.setByteStream(resource.getInputStream());
            return input;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path getParentResourcePath(String baseURI) {
        return Path.of(StringUtils.substringAfter((String)baseURI, (String)"/chutney/action-impl/"), new String[0]).getParent();
    }
}

