/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.assertion.placeholder;

import com.chutneytesting.action.assertion.placeholder.AfterDateAsserter;
import com.chutneytesting.action.assertion.placeholder.BeforeDateAsserter;
import com.chutneytesting.action.assertion.placeholder.ContainsAsserter;
import com.chutneytesting.action.assertion.placeholder.EqualDateAsserter;
import com.chutneytesting.action.assertion.placeholder.GreaterThanAsserter;
import com.chutneytesting.action.assertion.placeholder.IsEmptyAsserter;
import com.chutneytesting.action.assertion.placeholder.IsNullAsserter;
import com.chutneytesting.action.assertion.placeholder.LenientEqualAsserter;
import com.chutneytesting.action.assertion.placeholder.LessThanAsserter;
import com.chutneytesting.action.assertion.placeholder.MatchesStringAsserter;
import com.chutneytesting.action.assertion.placeholder.NotNullAsserter;
import com.chutneytesting.action.assertion.placeholder.PlaceholderAsserter;
import com.chutneytesting.action.assertion.placeholder.ValueArrayAsserter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PlaceholderAsserterUtils {
    private static final List<PlaceholderAsserter> asserters = new ArrayList<PlaceholderAsserter>();

    public static Optional<PlaceholderAsserter> getAsserterMatching(Object toMatch) {
        if (toMatch == null) {
            return Optional.of(new IsNullAsserter());
        }
        return asserters.stream().filter(a -> a.canApply(toMatch.toString())).findFirst();
    }

    static {
        asserters.add(new IsNullAsserter());
        asserters.add(new NotNullAsserter());
        asserters.add(new ContainsAsserter());
        asserters.add(new BeforeDateAsserter());
        asserters.add(new AfterDateAsserter());
        asserters.add(new EqualDateAsserter());
        asserters.add(new MatchesStringAsserter());
        asserters.add(new LessThanAsserter());
        asserters.add(new GreaterThanAsserter());
        asserters.add(new ValueArrayAsserter());
        asserters.add(new IsEmptyAsserter());
        asserters.add(new LenientEqualAsserter());
    }
}

