/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.assertion;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AssertAction
implements Action {
    private final Logger logger;
    private final List<Map<String, Boolean>> asserts;

    public AssertAction(Logger logger, @Input(value="asserts") List<Map<String, Boolean>> asserts) {
        this.logger = logger;
        this.asserts = Optional.ofNullable(asserts).orElse(Collections.emptyList());
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notEmptyListValidation(this.asserts, (String)"asserts")});
    }

    public ActionExecutionResult execute() {
        boolean result = this.asserts.stream().allMatch(l -> l.entrySet().stream().map(e -> {
            if ("assert-true".equals(e.getKey())) {
                if (((Boolean)e.getValue()).booleanValue()) {
                    this.logger.info("assert ok");
                    return true;
                }
                return false;
            }
            this.logger.error("Unknown assert type [" + (String)e.getKey() + "]");
            return Boolean.FALSE;
        }).allMatch(r -> r));
        return result ? ActionExecutionResult.ok() : ActionExecutionResult.ko();
    }
}

