/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.amqp;

import com.chutneytesting.action.amqp.ConnectionFactoryFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class AmqpDeleteQueueAction
implements Action {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final String queueName;
    private final Logger logger;

    public AmqpDeleteQueueAction(Target target, @Input(value="queue-name") String queueName, Logger logger) {
        this.target = target;
        this.queueName = queueName;
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.queueName, (String)"queue-name"), ActionValidatorsUtils.targetValidation((Target)this.target)});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        try (Connection connection = this.connectionFactoryFactory.newConnection(this.target);){
            ActionExecutionResult actionExecutionResult;
            block14: {
                Channel channel = connection.createChannel();
                try {
                    long messageCount = channel.messageCount(this.queueName);
                    long consumerCount = channel.consumerCount(this.queueName);
                    channel.queueDelete(this.queueName);
                    this.logger.info("Deleted AMQP Queue with name: " + this.queueName + " (" + messageCount + " messages, " + consumerCount + " consumers)");
                    actionExecutionResult = ActionExecutionResult.ok();
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return actionExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return ActionExecutionResult.ko();
        }
    }
}

