/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.amqp;

import com.chutneytesting.action.amqp.ConnectionFactoryFactory;
import com.chutneytesting.action.amqp.utils.AmqpUtils;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class AmqpBasicGetAction
implements Action {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final String queueName;
    private final Logger logger;

    public AmqpBasicGetAction(Target target, @Input(value="queue-name") String queueName, Logger logger) {
        this.target = target;
        this.queueName = queueName;
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.queueName, (String)"queue-name"), ActionValidatorsUtils.targetValidation((Target)this.target)});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        try (Connection connection = this.connectionFactoryFactory.newConnection(this.target);){
            ActionExecutionResult actionExecutionResult;
            block18: {
                GetResponse getResponse;
                Channel channel;
                block16: {
                    ActionExecutionResult actionExecutionResult2;
                    block17: {
                        channel = connection.createChannel();
                        try {
                            getResponse = channel.basicGet(this.queueName, true);
                            if (getResponse != null) break block16;
                            this.logger.error("No message available");
                            actionExecutionResult2 = ActionExecutionResult.ko();
                            if (channel == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        channel.close();
                    }
                    return actionExecutionResult2;
                }
                this.logger.info("Got AMQP Message on " + this.queueName + " with deliveryTag: " + getResponse.getEnvelope().getDeliveryTag());
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("message", getResponse);
                results.put("body", new String(getResponse.getBody()));
                results.put("headers", AmqpUtils.convertMapLongStringToString(getResponse.getProps().getHeaders()));
                actionExecutionResult = ActionExecutionResult.ok(results);
                if (channel == null) break block18;
                channel.close();
            }
            return actionExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return ActionExecutionResult.ko();
        }
    }
}

