/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils;

import com.cx.restclient.common.CxPARAM;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.sast.dto.CxXMLResults;
import com.cx.restclient.sast.dto.SASTResults;
import com.sun.xml.bind.v2.JAXBContextFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public abstract class SASTUtils {
    public static CxXMLResults convertToXMLResult(byte[] cxReport) throws CxClientException {
        CxXMLResults reportObj = null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cxReport);){
            JAXBContextFactory jaxbContextFactory = new JAXBContextFactory();
            JAXBContext jaxbContext = jaxbContextFactory.createContext(CxXMLResults.class.getPackage().getName(), CxXMLResults.class.getClassLoader(), Collections.emptyMap());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            reportObj = (CxXMLResults)unmarshaller.unmarshal((InputStream)byteArrayInputStream);
        }
        catch (IOException | JAXBException e) {
            throw new CxClientException("Failed to parse xml report: " + e.getMessage(), e);
        }
        return reportObj;
    }

    public static void printSASTResultsToConsole(SASTResults sastResults, boolean enableViolations, Logger log) {
        String highNew = sastResults.getNewHigh() > 0 ? " (" + sastResults.getNewHigh() + " new)" : "";
        String mediumNew = sastResults.getNewMedium() > 0 ? " (" + sastResults.getNewMedium() + " new)" : "";
        String lowNew = sastResults.getNewLow() > 0 ? " (" + sastResults.getNewLow() + " new)" : "";
        String infoNew = sastResults.getNewInfo() > 0 ? " (" + sastResults.getNewInfo() + " new)" : "";
        log.info("----------------------------Checkmarx Scan Results(CxSAST):-------------------------------");
        log.info("High severity results: " + sastResults.getHigh() + highNew);
        log.info("Medium severity results: " + sastResults.getMedium() + mediumNew);
        log.info("Low severity results: " + sastResults.getLow() + lowNew);
        log.info("Information severity results: " + sastResults.getInformation() + infoNew);
        log.info("");
        log.info("Scan results location: " + sastResults.getSastScanLink());
        log.info("------------------------------------------------------------------------------------------\n");
    }

    public static String writePDFReport(byte[] scanReport, File workspace, String pdfFileName, Logger log) {
        try {
            FileUtils.writeByteArrayToFile((File)new File(workspace + CxPARAM.CX_REPORT_LOCATION, pdfFileName), (byte[])scanReport);
            log.info("PDF report location: " + workspace + CxPARAM.CX_REPORT_LOCATION + File.separator + pdfFileName);
        }
        catch (Exception e) {
            log.error("Failed to write PDF report to workspace: ", (Object)e.getMessage());
            pdfFileName = "";
        }
        return pdfFileName;
    }

    public static void writeReport(byte[] scanReport, String reportName, Logger log) {
        try {
            File reportFile = new File(reportName);
            if (!reportFile.isAbsolute()) {
                reportFile = new File(System.getProperty("user.dir") + CxPARAM.CX_REPORT_LOCATION + File.separator + reportFile);
            }
            if (!reportFile.getParentFile().exists()) {
                reportFile.getParentFile().mkdirs();
            }
            FileUtils.writeByteArrayToFile((File)reportFile, (byte[])scanReport);
            log.info("report location: " + reportFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("Failed to write report: ", (Object)e.getMessage());
        }
    }
}

