/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.dto;

import com.cx.restclient.ast.dto.common.ASTResults;
import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.sast.dto.SASTResults;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;

public class ScanResults
implements Serializable,
Results {
    private final Map<ScannerType, Results> resultsMap = new EnumMap<ScannerType, Results>(ScannerType.class);
    private Exception sastCreateException = null;
    private Exception sastWaitException = null;
    private Exception osaCreateException = null;
    private Exception osaWaitException = null;
    private Exception generalException = null;

    public Map<ScannerType, Results> getResults() {
        return this.resultsMap;
    }

    public void put(ScannerType type, Results results) {
        if (this.resultsMap.containsKey((Object)type)) {
            throw new CxClientException("Results already contain type " + (Object)((Object)type));
        }
        this.resultsMap.put(type, results);
    }

    public Map<ScannerType, Results> getResultsMap() {
        return this.resultsMap;
    }

    public Results get(ScannerType type) {
        return this.resultsMap.get((Object)type);
    }

    public OSAResults getOsaResults() {
        return (OSAResults)this.resultsMap.get((Object)ScannerType.OSA);
    }

    public ASTResults getAstResults() {
        return (ASTResults)this.resultsMap.get((Object)ScannerType.AST_SAST);
    }

    public AstScaResults getScaResults() {
        return (AstScaResults)this.resultsMap.get((Object)ScannerType.AST_SCA);
    }

    public SASTResults getSastResults() {
        return (SASTResults)this.resultsMap.get((Object)ScannerType.SAST);
    }

    public Exception getSastCreateException() {
        return this.sastCreateException;
    }

    public void setSastCreateException(Exception sastCreateException) {
        this.sastCreateException = sastCreateException;
    }

    public Exception getSastWaitException() {
        return this.sastWaitException;
    }

    public void setSastWaitException(Exception sastWaitException) {
        this.sastWaitException = sastWaitException;
    }

    public Exception getOsaCreateException() {
        return this.osaCreateException;
    }

    public void setOsaCreateException(Exception osaCreateException) {
        this.osaCreateException = osaCreateException;
    }

    public Exception getOsaWaitException() {
        return this.osaWaitException;
    }

    public void setOsaWaitException(Exception osaWaitException) {
        this.osaWaitException = osaWaitException;
    }

    public Exception getGeneralException() {
        return this.generalException;
    }

    public void setGeneralException(Exception generalException) {
        this.generalException = generalException;
    }
}

