/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.cxArm.utils;

import com.cx.restclient.common.ShragaUtils;
import com.cx.restclient.cxArm.dto.Policy;
import com.cx.restclient.cxArm.dto.Violation;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class CxARMUtils {
    public static List<Policy> getProjectViolatedPolicies(CxHttpClient httpClient, String cxARMUrl, long projectId, String provider) throws IOException, CxClientException {
        String relativePath = "/cxarm/policymanager/projects/{projectId}/violations?provider={provider}".replace("{projectId}", Long.toString(projectId)).replace("{provider}", provider);
        return (List)((Object)httpClient.getRequest(cxARMUrl, relativePath, "application/json;v=1.0", null, Policy.class, 200, "CxARM violations", true));
    }

    public static List<Policy> getPolicyList(Policy policy) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        Map<String, List<Violation>> rules = CxARMUtils.resolveRules(policy.getViolations());
        Iterator<Map.Entry<String, List<Violation>>> it = rules.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<Violation>> pair = it.next();
            List<Violation> violations = pair.getValue();
            String firstDate = CxARMUtils.resolveFirstDate(violations);
            policies.add(new Policy(policy.getPolicyId(), policy.getPolicyName(), pair.getKey().toString(), violations, firstDate));
            it.remove();
        }
        return policies;
    }

    private static Map<String, List<Violation>> resolveRules(List<Violation> violations) {
        Map<String, List<Violation>> rules = violations.stream().collect(Collectors.toMap(Violation::getRuleName, e -> {
            ArrayList<Violation> ary = new ArrayList<Violation>();
            ary.add((Violation)e);
            return ary;
        }, (left, right) -> {
            left.addAll(right);
            return left;
        }));
        return rules;
    }

    private static String resolveFirstDate(List<Violation> violations) {
        Date firstDetectionDate = new Date(violations.get(0).getFirstDetectionDateByArm());
        for (Violation violation : violations) {
            Date date = new Date(violation.getFirstDetectionDateByArm());
            if (!date.before(firstDetectionDate)) continue;
            firstDetectionDate = date;
        }
        String firstDate = ShragaUtils.formatDate(firstDetectionDate.toString(), "E MMM dd hh:mm:ss Z yyyy", "dd/MM/yy");
        return firstDate;
    }

    public static String getPoliciesNames(List<Policy> policies) {
        String str = "";
        for (Policy policy : policies) {
            str = str + ", " + policy.getPolicyName();
        }
        str = str.substring(1, str.length());
        return str;
    }
}

