/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast.dto.common;

import com.cx.restclient.ast.dto.common.GitCredentials;
import com.cx.restclient.ast.dto.common.HandlerRef;

public class ScanStartHandler {
    private String url;
    private HandlerRef ref;
    private String username;
    private GitCredentials credentials;

    ScanStartHandler(String url, HandlerRef ref, String username, GitCredentials credentials) {
        this.url = url;
        this.ref = ref;
        this.username = username;
        this.credentials = credentials;
    }

    public static ScanStartHandlerBuilder builder() {
        return new ScanStartHandlerBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public HandlerRef getRef() {
        return this.ref;
    }

    public String getUsername() {
        return this.username;
    }

    public GitCredentials getCredentials() {
        return this.credentials;
    }

    public static class ScanStartHandlerBuilder {
        private String url;
        private HandlerRef ref;
        private String username;
        private GitCredentials credentials;

        ScanStartHandlerBuilder() {
        }

        public ScanStartHandlerBuilder url(String url) {
            this.url = url;
            return this;
        }

        public ScanStartHandlerBuilder ref(HandlerRef ref) {
            this.ref = ref;
            return this;
        }

        public ScanStartHandlerBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ScanStartHandlerBuilder credentials(GitCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public ScanStartHandler build() {
            return new ScanStartHandler(this.url, this.ref, this.username, this.credentials);
        }

        public String toString() {
            return "ScanStartHandler.ScanStartHandlerBuilder(url=" + this.url + ", ref=" + this.ref + ", username=" + this.username + ", credentials=" + this.credentials + ")";
        }
    }
}

