/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.ast.AstClient;
import com.cx.restclient.ast.dto.common.ASTConfig;
import com.cx.restclient.ast.dto.common.ASTResults;
import com.cx.restclient.ast.dto.common.HandlerRef;
import com.cx.restclient.ast.dto.common.RemoteRepositoryInfo;
import com.cx.restclient.ast.dto.common.ScanConfig;
import com.cx.restclient.ast.dto.sast.AstSastConfig;
import com.cx.restclient.ast.dto.sast.SastScanConfigValue;
import com.cx.restclient.common.Scanner;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.SourceLocationType;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;

public class AstSastClient
extends AstClient
implements Scanner {
    private static final String ENGINE_TYPE_FOR_API = "sast";
    private static final String REF_TYPE_BRANCH = "branch";

    public AstSastClient(CxScanConfig config, Logger log) {
        super(config, log);
        AstSastConfig astConfig = this.config.getAstSastConfig();
        this.validate(astConfig);
        String normalizedUrl = StringUtils.stripEnd((String)astConfig.getApiUrl(), (String)"/");
        this.httpClient = this.createHttpClient(normalizedUrl);
    }

    @Override
    public void init() {
        this.log.debug(String.format("Initializing %s client.", this.getScannerDisplayName()));
        AstSastConfig astConfig = this.config.getAstSastConfig();
        this.httpClient.addCustomHeader("Authorization", String.format("Bearer %s", astConfig.getAccessToken()));
    }

    @Override
    protected String getScannerDisplayName() {
        return ScannerType.AST_SAST.getDisplayName();
    }

    @Override
    public Results initiateScan() {
        this.log.info(String.format("----------------------------------- Initiating %s Scan:------------------------------------", this.getScannerDisplayName()));
        ASTResults astResults = new ASTResults();
        AstSastConfig astConfig = this.config.getAstSastConfig();
        try {
            SourceLocationType locationType = astConfig.getSourceLocationType();
            if (locationType != SourceLocationType.REMOTE_REPOSITORY) {
                throw new NotImplementedException("The upload flow is not yet supported.");
            }
            HttpResponse response = this.submitSourcesFromRemoteRepo(astConfig, this.config.getProjectName());
            String scanId = this.extractScanIdFrom(response);
            astResults.setScanId(scanId);
            return astResults;
        }
        catch (IOException e) {
            throw new CxClientException("Error creating scan.", e);
        }
    }

    @Override
    protected ScanConfig getScanConfig() {
        boolean isIncremental = Boolean.TRUE.equals(this.config.getAstSastConfig().isIncremental());
        String presetName = (String)StringUtils.defaultIfEmpty((CharSequence)this.config.getAstSastConfig().getPresetName(), (CharSequence)"");
        SastScanConfigValue configValue = SastScanConfigValue.builder().incremental(Boolean.toString(isIncremental)).presetName(presetName).build();
        return ScanConfig.builder().type(ENGINE_TYPE_FOR_API).value(configValue).build();
    }

    @Override
    protected HandlerRef getBranchToScan(RemoteRepositoryInfo repoInfo) {
        return HandlerRef.builder().type(REF_TYPE_BRANCH).value(repoInfo.getBranch()).build();
    }

    @Override
    public ScanResults waitForScanResults() {
        return null;
    }

    @Override
    public ScanResults getLatestScanResults() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        Optional.ofNullable(this.httpClient).ifPresent(CxHttpClient::close);
    }

    private void validate(ASTConfig astSastConfig) {
        this.log.debug("Validating config.");
        String error = null;
        if (astSastConfig == null) {
            error = "%s config must be provided.";
        } else if (StringUtils.isBlank((CharSequence)astSastConfig.getApiUrl())) {
            error = "%s API URL must be provided.";
        }
        if (error != null) {
            throw new IllegalArgumentException(String.format(error, this.getScannerDisplayName()));
        }
    }
}

