/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Gateway;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualBankAccount
extends Resource<VirtualBankAccount> {
    public VirtualBankAccount(String jsonStr) {
        super(jsonStr);
    }

    public VirtualBankAccount(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String email() {
        return this.reqString("email");
    }

    public Scheme scheme() {
        return this.optEnum("scheme", Scheme.class);
    }

    public String bankName() {
        return this.optString("bank_name");
    }

    public String accountNumber() {
        return this.reqString("account_number");
    }

    public String routingNumber() {
        return this.optString("routing_number");
    }

    public String swiftCode() {
        return this.reqString("swift_code");
    }

    public Gateway gateway() {
        return this.reqEnum("gateway", Gateway.class);
    }

    public String gatewayAccountId() {
        return this.reqString("gateway_account_id");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public String referenceId() {
        return this.reqString("reference_id");
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public static CreateUsingPermanentTokenRequest createUsingPermanentToken() {
        String uri = VirtualBankAccount.uri("virtual_bank_accounts", "create_using_permanent_token");
        return new CreateUsingPermanentTokenRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateRequest create() {
        String uri = VirtualBankAccount.uri("virtual_bank_accounts");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = VirtualBankAccount.uri("virtual_bank_accounts", VirtualBankAccount.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static VirtualBankAccountListRequest list() {
        String uri = VirtualBankAccount.uri("virtual_bank_accounts");
        return new VirtualBankAccountListRequest(uri);
    }

    public static Request delete(String id) {
        String uri = VirtualBankAccount.uri("virtual_bank_accounts", VirtualBankAccount.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request deleteLocal(String id) {
        String uri = VirtualBankAccount.uri("virtual_bank_accounts", VirtualBankAccount.nullCheck(id), "delete_local");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VirtualBankAccountListRequest
    extends ListRequest<VirtualBankAccountListRequest> {
        private VirtualBankAccountListRequest(String uri) {
            super(uri);
        }

        public StringFilter<VirtualBankAccountListRequest> customerId() {
            return new StringFilter<VirtualBankAccountListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public TimestampFilter<VirtualBankAccountListRequest> updatedAt() {
            return new TimestampFilter<VirtualBankAccountListRequest>("updated_at", this);
        }

        public TimestampFilter<VirtualBankAccountListRequest> createdAt() {
            return new TimestampFilter<VirtualBankAccountListRequest>("created_at", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateRequest email(String email) {
            this.params.addOpt("email", email);
            return this;
        }

        public CreateRequest scheme(Scheme scheme) {
            this.params.addOpt("scheme", (Object)scheme);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateUsingPermanentTokenRequest
    extends Request<CreateUsingPermanentTokenRequest> {
        private CreateUsingPermanentTokenRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateUsingPermanentTokenRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateUsingPermanentTokenRequest referenceId(String referenceId) {
            this.params.add("reference_id", referenceId);
            return this;
        }

        public CreateUsingPermanentTokenRequest scheme(Scheme scheme) {
            this.params.addOpt("scheme", (Object)scheme);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scheme {
        ACH_CREDIT,
        SEPA_CREDIT,
        _UNKNOWN;

    }
}

