/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.AccountHolderType;
import com.chargebee.models.enums.AccountReceivablesHandling;
import com.chargebee.models.enums.AccountType;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.AvalaraSaleType;
import com.chargebee.models.enums.BillingAlignmentMode;
import com.chargebee.models.enums.ChargeOn;
import com.chargebee.models.enums.ChargesHandling;
import com.chargebee.models.enums.ContractTermCancelOption;
import com.chargebee.models.enums.CreditOptionForCurrentTermCharges;
import com.chargebee.models.enums.CustomerType;
import com.chargebee.models.enums.EcheckType;
import com.chargebee.models.enums.EntityCode;
import com.chargebee.models.enums.FreePeriodUnit;
import com.chargebee.models.enums.FriendOfferType;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.InvoiceDunningHandling;
import com.chargebee.models.enums.NotifyReferralSystem;
import com.chargebee.models.enums.OfflinePaymentMethod;
import com.chargebee.models.enums.OnEvent;
import com.chargebee.models.enums.PauseOption;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.models.enums.ReferralSystem;
import com.chargebee.models.enums.ReferrerRewardType;
import com.chargebee.models.enums.RefundableCreditsHandling;
import com.chargebee.models.enums.ResumeOption;
import com.chargebee.models.enums.Taxability;
import com.chargebee.models.enums.TaxjarExemptionCategory;
import com.chargebee.models.enums.Type;
import com.chargebee.models.enums.UnbilledChargesHandling;
import com.chargebee.models.enums.UnbilledChargesOption;
import com.chargebee.models.enums.UnpaidInvoicesHandling;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription
extends Resource<Subscription> {
    public Subscription(String jsonStr) {
        super(jsonStr);
    }

    public Subscription(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public String planId() {
        return this.reqString("plan_id");
    }

    public Integer planQuantity() {
        return this.reqInteger("plan_quantity");
    }

    public Integer planUnitPrice() {
        return this.optInteger("plan_unit_price");
    }

    public Integer setupFee() {
        return this.optInteger("setup_fee");
    }

    public Integer billingPeriod() {
        return this.optInteger("billing_period");
    }

    public BillingPeriodUnit billingPeriodUnit() {
        return this.optEnum("billing_period_unit", BillingPeriodUnit.class);
    }

    public Timestamp startDate() {
        return this.optTimestamp("start_date");
    }

    public Timestamp trialEnd() {
        return this.optTimestamp("trial_end");
    }

    public Integer remainingBillingCycles() {
        return this.optInteger("remaining_billing_cycles");
    }

    public String poNumber() {
        return this.optString("po_number");
    }

    public AutoCollection autoCollection() {
        return this.optEnum("auto_collection", AutoCollection.class);
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public Integer planAmount() {
        return this.optInteger("plan_amount");
    }

    public Integer planFreeQuantity() {
        return this.optInteger("plan_free_quantity");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp trialStart() {
        return this.optTimestamp("trial_start");
    }

    public Timestamp currentTermStart() {
        return this.optTimestamp("current_term_start");
    }

    public Timestamp currentTermEnd() {
        return this.optTimestamp("current_term_end");
    }

    public Timestamp nextBillingAt() {
        return this.optTimestamp("next_billing_at");
    }

    public Timestamp createdAt() {
        return this.optTimestamp("created_at");
    }

    public Timestamp startedAt() {
        return this.optTimestamp("started_at");
    }

    public Timestamp activatedAt() {
        return this.optTimestamp("activated_at");
    }

    public String giftId() {
        return this.optString("gift_id");
    }

    public Integer contractTermBillingCycleOnRenewal() {
        return this.optInteger("contract_term_billing_cycle_on_renewal");
    }

    public Boolean overrideRelationship() {
        return this.optBoolean("override_relationship");
    }

    public Timestamp pauseDate() {
        return this.optTimestamp("pause_date");
    }

    public Timestamp resumeDate() {
        return this.optTimestamp("resume_date");
    }

    public Timestamp cancelledAt() {
        return this.optTimestamp("cancelled_at");
    }

    public CancelReason cancelReason() {
        return this.optEnum("cancel_reason", CancelReason.class);
    }

    public String affiliateToken() {
        return this.optString("affiliate_token");
    }

    public String createdFromIp() {
        return this.optString("created_from_ip");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Boolean hasScheduledChanges() {
        return this.reqBoolean("has_scheduled_changes");
    }

    public String paymentSourceId() {
        return this.optString("payment_source_id");
    }

    public OfflinePaymentMethod offlinePaymentMethod() {
        return this.optEnum("offline_payment_method", OfflinePaymentMethod.class);
    }

    public Integer dueInvoicesCount() {
        return this.optInteger("due_invoices_count");
    }

    public Timestamp dueSince() {
        return this.optTimestamp("due_since");
    }

    public Integer totalDues() {
        return this.optInteger("total_dues");
    }

    public Integer mrr() {
        return this.optInteger("mrr");
    }

    public BigDecimal exchangeRate() {
        return this.optBigDecimal("exchange_rate");
    }

    public String baseCurrencyCode() {
        return this.optString("base_currency_code");
    }

    public List<Addon> addons() {
        return this.optList("addons", Addon.class);
    }

    public List<EventBasedAddon> eventBasedAddons() {
        return this.optList("event_based_addons", EventBasedAddon.class);
    }

    public List<ChargedEventBasedAddon> chargedEventBasedAddons() {
        return this.optList("charged_event_based_addons", ChargedEventBasedAddon.class);
    }

    @Deprecated
    public String coupon() {
        return this.optString("coupon");
    }

    public List<Coupon> coupons() {
        return this.optList("coupons", Coupon.class);
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public ReferralInfo referralInfo() {
        return this.optSubResource("referral_info", ReferralInfo.class);
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public ContractTerm contractTerm() {
        return this.optSubResource("contract_term", ContractTerm.class);
    }

    public String cancelReasonCode() {
        return this.optString("cancel_reason_code");
    }

    public Integer freePeriod() {
        return this.optInteger("free_period");
    }

    public FreePeriodUnit freePeriodUnit() {
        return this.optEnum("free_period_unit", FreePeriodUnit.class);
    }

    public static CreateRequest create() {
        String uri = Subscription.uri("subscriptions");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateForCustomerRequest createForCustomer(String id) {
        String uri = Subscription.uri("customers", Subscription.nullCheck(id), "subscriptions");
        return new CreateForCustomerRequest(HttpUtil.Method.POST, uri);
    }

    public static SubscriptionListRequest list() {
        String uri = Subscription.uri("subscriptions");
        return new SubscriptionListRequest(uri);
    }

    @Deprecated
    public static ListRequest subscriptionsForCustomer(String id) {
        String uri = Subscription.uri("customers", Subscription.nullCheck(id), "subscriptions");
        return new ListRequest(uri);
    }

    public static ListRequest contractTermsForSubscription(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "contract_terms");
        return new ListRequest(uri);
    }

    public static Request retrieve(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request retrieveWithScheduledChanges(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "retrieve_with_scheduled_changes");
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request removeScheduledChanges(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "remove_scheduled_changes");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static RemoveScheduledCancellationRequest removeScheduledCancellation(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "remove_scheduled_cancellation");
        return new RemoveScheduledCancellationRequest(HttpUtil.Method.POST, uri);
    }

    public static RemoveCouponsRequest removeCoupons(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "remove_coupons");
        return new RemoveCouponsRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static ChangeTermEndRequest changeTermEnd(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "change_term_end");
        return new ChangeTermEndRequest(HttpUtil.Method.POST, uri);
    }

    public static ReactivateRequest reactivate(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "reactivate");
        return new ReactivateRequest(HttpUtil.Method.POST, uri);
    }

    public static AddChargeAtTermEndRequest addChargeAtTermEnd(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "add_charge_at_term_end");
        return new AddChargeAtTermEndRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeAddonAtTermEndRequest chargeAddonAtTermEnd(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "charge_addon_at_term_end");
        return new ChargeAddonAtTermEndRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeFutureRenewalsRequest chargeFutureRenewals(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "charge_future_renewals");
        return new ChargeFutureRenewalsRequest(HttpUtil.Method.POST, uri);
    }

    public static ImportSubscriptionRequest importSubscription() {
        String uri = Subscription.uri("subscriptions", "import_subscription");
        return new ImportSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static ImportForCustomerRequest importForCustomer(String id) {
        String uri = Subscription.uri("customers", Subscription.nullCheck(id), "import_subscription");
        return new ImportForCustomerRequest(HttpUtil.Method.POST, uri);
    }

    public static ImportContractTermRequest importContractTerm(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "import_contract_term");
        return new ImportContractTermRequest(HttpUtil.Method.POST, uri);
    }

    public static OverrideBillingProfileRequest overrideBillingProfile(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "override_billing_profile");
        return new OverrideBillingProfileRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static PauseRequest pause(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "pause");
        return new PauseRequest(HttpUtil.Method.POST, uri);
    }

    public static CancelRequest cancel(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "cancel");
        return new CancelRequest(HttpUtil.Method.POST, uri);
    }

    public static ResumeRequest resume(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "resume");
        return new ResumeRequest(HttpUtil.Method.POST, uri);
    }

    public static Request removeScheduledPause(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "remove_scheduled_pause");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request removeScheduledResumption(String id) {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "remove_scheduled_resumption");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResumeRequest
    extends Request<ResumeRequest> {
        private ResumeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ResumeRequest resumeOption(ResumeOption resumeOption) {
            this.params.addOpt("resume_option", (Object)resumeOption);
            return this;
        }

        public ResumeRequest resumeDate(Timestamp resumeDate) {
            this.params.addOpt("resume_date", resumeDate);
            return this;
        }

        public ResumeRequest chargesHandling(ChargesHandling chargesHandling) {
            this.params.addOpt("charges_handling", (Object)chargesHandling);
            return this;
        }

        public ResumeRequest unpaidInvoicesHandling(UnpaidInvoicesHandling unpaidInvoicesHandling) {
            this.params.addOpt("unpaid_invoices_handling", (Object)unpaidInvoicesHandling);
            return this;
        }

        public ResumeRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public ResumeRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public ResumeRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public ResumeRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public ResumeRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelRequest
    extends Request<CancelRequest> {
        private CancelRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CancelRequest endOfTerm(Boolean endOfTerm) {
            this.params.addOpt("end_of_term", endOfTerm);
            return this;
        }

        public CancelRequest cancelAt(Timestamp cancelAt) {
            this.params.addOpt("cancel_at", cancelAt);
            return this;
        }

        public CancelRequest creditOptionForCurrentTermCharges(CreditOptionForCurrentTermCharges creditOptionForCurrentTermCharges) {
            this.params.addOpt("credit_option_for_current_term_charges", (Object)creditOptionForCurrentTermCharges);
            return this;
        }

        public CancelRequest unbilledChargesOption(UnbilledChargesOption unbilledChargesOption) {
            this.params.addOpt("unbilled_charges_option", (Object)unbilledChargesOption);
            return this;
        }

        public CancelRequest accountReceivablesHandling(AccountReceivablesHandling accountReceivablesHandling) {
            this.params.addOpt("account_receivables_handling", (Object)accountReceivablesHandling);
            return this;
        }

        public CancelRequest refundableCreditsHandling(RefundableCreditsHandling refundableCreditsHandling) {
            this.params.addOpt("refundable_credits_handling", (Object)refundableCreditsHandling);
            return this;
        }

        public CancelRequest contractTermCancelOption(ContractTermCancelOption contractTermCancelOption) {
            this.params.addOpt("contract_term_cancel_option", (Object)contractTermCancelOption);
            return this;
        }

        public CancelRequest cancelReasonCode(String cancelReasonCode) {
            this.params.addOpt("cancel_reason_code", cancelReasonCode);
            return this;
        }

        public CancelRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public CancelRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public CancelRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public CancelRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PauseRequest
    extends Request<PauseRequest> {
        private PauseRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public PauseRequest pauseOption(PauseOption pauseOption) {
            this.params.addOpt("pause_option", (Object)pauseOption);
            return this;
        }

        public PauseRequest pauseDate(Timestamp pauseDate) {
            this.params.addOpt("pause_date", pauseDate);
            return this;
        }

        public PauseRequest unbilledChargesHandling(UnbilledChargesHandling unbilledChargesHandling) {
            this.params.addOpt("unbilled_charges_handling", (Object)unbilledChargesHandling);
            return this;
        }

        public PauseRequest invoiceDunningHandling(InvoiceDunningHandling invoiceDunningHandling) {
            this.params.addOpt("invoice_dunning_handling", (Object)invoiceDunningHandling);
            return this;
        }

        public PauseRequest resumeDate(Timestamp resumeDate) {
            this.params.addOpt("resume_date", resumeDate);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OverrideBillingProfileRequest
    extends Request<OverrideBillingProfileRequest> {
        private OverrideBillingProfileRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public OverrideBillingProfileRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public OverrideBillingProfileRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportContractTermRequest
    extends Request<ImportContractTermRequest> {
        private ImportContractTermRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportContractTermRequest contractTermBillingCycleOnRenewal(Integer contractTermBillingCycleOnRenewal) {
            this.params.addOpt("contract_term_billing_cycle_on_renewal", contractTermBillingCycleOnRenewal);
            return this;
        }

        public ImportContractTermRequest contractTermId(String contractTermId) {
            this.params.addOpt("contract_term[id]", contractTermId);
            return this;
        }

        public ImportContractTermRequest contractTermCreatedAt(Timestamp contractTermCreatedAt) {
            this.params.addOpt("contract_term[created_at]", contractTermCreatedAt);
            return this;
        }

        public ImportContractTermRequest contractTermContractStart(Timestamp contractTermContractStart) {
            this.params.addOpt("contract_term[contract_start]", contractTermContractStart);
            return this;
        }

        public ImportContractTermRequest contractTermContractEnd(Timestamp contractTermContractEnd) {
            this.params.addOpt("contract_term[contract_end]", contractTermContractEnd);
            return this;
        }

        public ImportContractTermRequest contractTermStatus(ContractTerm.Status contractTermStatus) {
            this.params.addOpt("contract_term[status]", (Object)contractTermStatus);
            return this;
        }

        public ImportContractTermRequest contractTermTotalAmountRaised(Long contractTermTotalAmountRaised) {
            this.params.addOpt("contract_term[total_amount_raised]", contractTermTotalAmountRaised);
            return this;
        }

        public ImportContractTermRequest contractTermTotalContractValue(Long contractTermTotalContractValue) {
            this.params.addOpt("contract_term[total_contract_value]", contractTermTotalContractValue);
            return this;
        }

        public ImportContractTermRequest contractTermBillingCycle(Integer contractTermBillingCycle) {
            this.params.addOpt("contract_term[billing_cycle]", contractTermBillingCycle);
            return this;
        }

        public ImportContractTermRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public ImportContractTermRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportForCustomerRequest
    extends Request<ImportForCustomerRequest> {
        private ImportForCustomerRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportForCustomerRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public ImportForCustomerRequest planId(String planId) {
            this.params.add("plan_id", planId);
            return this;
        }

        public ImportForCustomerRequest planQuantity(Integer planQuantity) {
            this.params.addOpt("plan_quantity", planQuantity);
            return this;
        }

        public ImportForCustomerRequest planUnitPrice(Integer planUnitPrice) {
            this.params.addOpt("plan_unit_price", planUnitPrice);
            return this;
        }

        public ImportForCustomerRequest setupFee(Integer setupFee) {
            this.params.addOpt("setup_fee", setupFee);
            return this;
        }

        public ImportForCustomerRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public ImportForCustomerRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public ImportForCustomerRequest startDate(Timestamp startDate) {
            this.params.addOpt("start_date", startDate);
            return this;
        }

        public ImportForCustomerRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public ImportForCustomerRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public ImportForCustomerRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public ImportForCustomerRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public ImportForCustomerRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public ImportForCustomerRequest status(Status status) {
            this.params.add("status", (Object)status);
            return this;
        }

        public ImportForCustomerRequest currentTermEnd(Timestamp currentTermEnd) {
            this.params.addOpt("current_term_end", currentTermEnd);
            return this;
        }

        public ImportForCustomerRequest currentTermStart(Timestamp currentTermStart) {
            this.params.addOpt("current_term_start", currentTermStart);
            return this;
        }

        public ImportForCustomerRequest trialStart(Timestamp trialStart) {
            this.params.addOpt("trial_start", trialStart);
            return this;
        }

        public ImportForCustomerRequest cancelledAt(Timestamp cancelledAt) {
            this.params.addOpt("cancelled_at", cancelledAt);
            return this;
        }

        public ImportForCustomerRequest startedAt(Timestamp startedAt) {
            this.params.addOpt("started_at", startedAt);
            return this;
        }

        public ImportForCustomerRequest pauseDate(Timestamp pauseDate) {
            this.params.addOpt("pause_date", pauseDate);
            return this;
        }

        public ImportForCustomerRequest resumeDate(Timestamp resumeDate) {
            this.params.addOpt("resume_date", resumeDate);
            return this;
        }

        public ImportForCustomerRequest contractTermBillingCycleOnRenewal(Integer contractTermBillingCycleOnRenewal) {
            this.params.addOpt("contract_term_billing_cycle_on_renewal", contractTermBillingCycleOnRenewal);
            return this;
        }

        public ImportForCustomerRequest createCurrentTermInvoice(Boolean createCurrentTermInvoice) {
            this.params.addOpt("create_current_term_invoice", createCurrentTermInvoice);
            return this;
        }

        public ImportForCustomerRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public ImportForCustomerRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public ImportForCustomerRequest contractTermId(String contractTermId) {
            this.params.addOpt("contract_term[id]", contractTermId);
            return this;
        }

        public ImportForCustomerRequest contractTermCreatedAt(Timestamp contractTermCreatedAt) {
            this.params.addOpt("contract_term[created_at]", contractTermCreatedAt);
            return this;
        }

        public ImportForCustomerRequest contractTermContractStart(Timestamp contractTermContractStart) {
            this.params.addOpt("contract_term[contract_start]", contractTermContractStart);
            return this;
        }

        public ImportForCustomerRequest contractTermBillingCycle(Integer contractTermBillingCycle) {
            this.params.addOpt("contract_term[billing_cycle]", contractTermBillingCycle);
            return this;
        }

        public ImportForCustomerRequest contractTermTotalAmountRaised(Long contractTermTotalAmountRaised) {
            this.params.addOpt("contract_term[total_amount_raised]", contractTermTotalAmountRaised);
            return this;
        }

        public ImportForCustomerRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public ImportForCustomerRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public ImportForCustomerRequest transactionAmount(Integer transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public ImportForCustomerRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.addOpt("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public ImportForCustomerRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public ImportForCustomerRequest transactionDate(Timestamp transactionDate) {
            this.params.addOpt("transaction[date]", transactionDate);
            return this;
        }

        public ImportForCustomerRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public ImportForCustomerRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public ImportForCustomerRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public ImportForCustomerRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public ImportForCustomerRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public ImportForCustomerRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public ImportForCustomerRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public ImportForCustomerRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public ImportForCustomerRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public ImportForCustomerRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public ImportForCustomerRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public ImportForCustomerRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public ImportForCustomerRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public ImportForCustomerRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public ImportForCustomerRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public ImportForCustomerRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public ImportForCustomerRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public ImportForCustomerRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public ImportForCustomerRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public ImportForCustomerRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public ImportForCustomerRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public ImportForCustomerRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public ImportForCustomerRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public ImportForCustomerRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public ImportForCustomerRequest chargedEventBasedAddonId(int index, String chargedEventBasedAddonId) {
            this.params.addOpt("charged_event_based_addons[id][" + index + "]", chargedEventBasedAddonId);
            return this;
        }

        public ImportForCustomerRequest chargedEventBasedAddonLastChargedAt(int index, Timestamp chargedEventBasedAddonLastChargedAt) {
            this.params.addOpt("charged_event_based_addons[last_charged_at][" + index + "]", chargedEventBasedAddonLastChargedAt);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportSubscriptionRequest
    extends Request<ImportSubscriptionRequest> {
        private ImportSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportSubscriptionRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public ImportSubscriptionRequest clientProfileId(String clientProfileId) {
            this.params.addOpt("client_profile_id", clientProfileId);
            return this;
        }

        public ImportSubscriptionRequest planId(String planId) {
            this.params.add("plan_id", planId);
            return this;
        }

        public ImportSubscriptionRequest planQuantity(Integer planQuantity) {
            this.params.addOpt("plan_quantity", planQuantity);
            return this;
        }

        public ImportSubscriptionRequest planUnitPrice(Integer planUnitPrice) {
            this.params.addOpt("plan_unit_price", planUnitPrice);
            return this;
        }

        public ImportSubscriptionRequest setupFee(Integer setupFee) {
            this.params.addOpt("setup_fee", setupFee);
            return this;
        }

        public ImportSubscriptionRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public ImportSubscriptionRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public ImportSubscriptionRequest startDate(Timestamp startDate) {
            this.params.addOpt("start_date", startDate);
            return this;
        }

        public ImportSubscriptionRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public ImportSubscriptionRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public ImportSubscriptionRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public ImportSubscriptionRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public ImportSubscriptionRequest contractTermBillingCycleOnRenewal(Integer contractTermBillingCycleOnRenewal) {
            this.params.addOpt("contract_term_billing_cycle_on_renewal", contractTermBillingCycleOnRenewal);
            return this;
        }

        public ImportSubscriptionRequest status(Status status) {
            this.params.add("status", (Object)status);
            return this;
        }

        public ImportSubscriptionRequest currentTermEnd(Timestamp currentTermEnd) {
            this.params.addOpt("current_term_end", currentTermEnd);
            return this;
        }

        public ImportSubscriptionRequest currentTermStart(Timestamp currentTermStart) {
            this.params.addOpt("current_term_start", currentTermStart);
            return this;
        }

        public ImportSubscriptionRequest trialStart(Timestamp trialStart) {
            this.params.addOpt("trial_start", trialStart);
            return this;
        }

        public ImportSubscriptionRequest cancelledAt(Timestamp cancelledAt) {
            this.params.addOpt("cancelled_at", cancelledAt);
            return this;
        }

        public ImportSubscriptionRequest startedAt(Timestamp startedAt) {
            this.params.addOpt("started_at", startedAt);
            return this;
        }

        public ImportSubscriptionRequest pauseDate(Timestamp pauseDate) {
            this.params.addOpt("pause_date", pauseDate);
            return this;
        }

        public ImportSubscriptionRequest resumeDate(Timestamp resumeDate) {
            this.params.addOpt("resume_date", resumeDate);
            return this;
        }

        public ImportSubscriptionRequest createCurrentTermInvoice(Boolean createCurrentTermInvoice) {
            this.params.addOpt("create_current_term_invoice", createCurrentTermInvoice);
            return this;
        }

        public ImportSubscriptionRequest affiliateToken(String affiliateToken) {
            this.params.addOpt("affiliate_token", affiliateToken);
            return this;
        }

        public ImportSubscriptionRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public ImportSubscriptionRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public ImportSubscriptionRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public ImportSubscriptionRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public ImportSubscriptionRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public ImportSubscriptionRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        public ImportSubscriptionRequest customerCompany(String customerCompany) {
            this.params.addOpt("customer[company]", customerCompany);
            return this;
        }

        public ImportSubscriptionRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public ImportSubscriptionRequest customerLocale(String customerLocale) {
            this.params.addOpt("customer[locale]", customerLocale);
            return this;
        }

        public ImportSubscriptionRequest customerEntityCode(EntityCode customerEntityCode) {
            this.params.addOpt("customer[entity_code]", (Object)customerEntityCode);
            return this;
        }

        public ImportSubscriptionRequest customerExemptNumber(String customerExemptNumber) {
            this.params.addOpt("customer[exempt_number]", customerExemptNumber);
            return this;
        }

        public ImportSubscriptionRequest customerNetTermDays(Integer customerNetTermDays) {
            this.params.addOpt("customer[net_term_days]", customerNetTermDays);
            return this;
        }

        public ImportSubscriptionRequest customerTaxjarExemptionCategory(TaxjarExemptionCategory customerTaxjarExemptionCategory) {
            this.params.addOpt("customer[taxjar_exemption_category]", (Object)customerTaxjarExemptionCategory);
            return this;
        }

        public ImportSubscriptionRequest customerPhone(String customerPhone) {
            this.params.addOpt("customer[phone]", customerPhone);
            return this;
        }

        public ImportSubscriptionRequest customerCustomerType(CustomerType customerCustomerType) {
            this.params.addOpt("customer[customer_type]", (Object)customerCustomerType);
            return this;
        }

        public ImportSubscriptionRequest customerAutoCollection(AutoCollection customerAutoCollection) {
            this.params.addOpt("customer[auto_collection]", (Object)customerAutoCollection);
            return this;
        }

        public ImportSubscriptionRequest customerAllowDirectDebit(Boolean customerAllowDirectDebit) {
            this.params.addOpt("customer[allow_direct_debit]", customerAllowDirectDebit);
            return this;
        }

        public ImportSubscriptionRequest contractTermId(String contractTermId) {
            this.params.addOpt("contract_term[id]", contractTermId);
            return this;
        }

        public ImportSubscriptionRequest contractTermCreatedAt(Timestamp contractTermCreatedAt) {
            this.params.addOpt("contract_term[created_at]", contractTermCreatedAt);
            return this;
        }

        public ImportSubscriptionRequest contractTermContractStart(Timestamp contractTermContractStart) {
            this.params.addOpt("contract_term[contract_start]", contractTermContractStart);
            return this;
        }

        public ImportSubscriptionRequest contractTermBillingCycle(Integer contractTermBillingCycle) {
            this.params.addOpt("contract_term[billing_cycle]", contractTermBillingCycle);
            return this;
        }

        public ImportSubscriptionRequest contractTermTotalAmountRaised(Long contractTermTotalAmountRaised) {
            this.params.addOpt("contract_term[total_amount_raised]", contractTermTotalAmountRaised);
            return this;
        }

        public ImportSubscriptionRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public ImportSubscriptionRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        @Deprecated
        public ImportSubscriptionRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public ImportSubscriptionRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Deprecated
        public ImportSubscriptionRequest cardTmpToken(String cardTmpToken) {
            this.params.addOpt("card[tmp_token]", cardTmpToken);
            return this;
        }

        public ImportSubscriptionRequest paymentMethodType(Type paymentMethodType) {
            this.params.addOpt("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        @Deprecated
        public ImportSubscriptionRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public ImportSubscriptionRequest paymentMethodGatewayAccountId(String paymentMethodGatewayAccountId) {
            this.params.addOpt("payment_method[gateway_account_id]", paymentMethodGatewayAccountId);
            return this;
        }

        public ImportSubscriptionRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public ImportSubscriptionRequest paymentMethodIssuingCountry(String paymentMethodIssuingCountry) {
            this.params.addOpt("payment_method[issuing_country]", paymentMethodIssuingCountry);
            return this;
        }

        public ImportSubscriptionRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public ImportSubscriptionRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public ImportSubscriptionRequest cardNumber(String cardNumber) {
            this.params.addOpt("card[number]", cardNumber);
            return this;
        }

        public ImportSubscriptionRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public ImportSubscriptionRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public ImportSubscriptionRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public ImportSubscriptionRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public ImportSubscriptionRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public ImportSubscriptionRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public ImportSubscriptionRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public ImportSubscriptionRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public ImportSubscriptionRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public ImportSubscriptionRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        public ImportSubscriptionRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public ImportSubscriptionRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public ImportSubscriptionRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public ImportSubscriptionRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public ImportSubscriptionRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public ImportSubscriptionRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public ImportSubscriptionRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public ImportSubscriptionRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public ImportSubscriptionRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public ImportSubscriptionRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public ImportSubscriptionRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public ImportSubscriptionRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public ImportSubscriptionRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public ImportSubscriptionRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public ImportSubscriptionRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public ImportSubscriptionRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public ImportSubscriptionRequest transactionAmount(Integer transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public ImportSubscriptionRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.addOpt("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public ImportSubscriptionRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public ImportSubscriptionRequest transactionDate(Timestamp transactionDate) {
            this.params.addOpt("transaction[date]", transactionDate);
            return this;
        }

        public ImportSubscriptionRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public ImportSubscriptionRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public ImportSubscriptionRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public ImportSubscriptionRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public ImportSubscriptionRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public ImportSubscriptionRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public ImportSubscriptionRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public ImportSubscriptionRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public ImportSubscriptionRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public ImportSubscriptionRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public ImportSubscriptionRequest chargedEventBasedAddonId(int index, String chargedEventBasedAddonId) {
            this.params.addOpt("charged_event_based_addons[id][" + index + "]", chargedEventBasedAddonId);
            return this;
        }

        public ImportSubscriptionRequest chargedEventBasedAddonLastChargedAt(int index, Timestamp chargedEventBasedAddonLastChargedAt) {
            this.params.addOpt("charged_event_based_addons[last_charged_at][" + index + "]", chargedEventBasedAddonLastChargedAt);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChargeFutureRenewalsRequest
    extends Request<ChargeFutureRenewalsRequest> {
        private ChargeFutureRenewalsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeFutureRenewalsRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChargeAddonAtTermEndRequest
    extends Request<ChargeAddonAtTermEndRequest> {
        private ChargeAddonAtTermEndRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeAddonAtTermEndRequest addonId(String addonId) {
            this.params.add("addon_id", addonId);
            return this;
        }

        public ChargeAddonAtTermEndRequest addonQuantity(Integer addonQuantity) {
            this.params.addOpt("addon_quantity", addonQuantity);
            return this;
        }

        public ChargeAddonAtTermEndRequest addonUnitPrice(Integer addonUnitPrice) {
            this.params.addOpt("addon_unit_price", addonUnitPrice);
            return this;
        }

        public ChargeAddonAtTermEndRequest dateFrom(Timestamp dateFrom) {
            this.params.addOpt("date_from", dateFrom);
            return this;
        }

        public ChargeAddonAtTermEndRequest dateTo(Timestamp dateTo) {
            this.params.addOpt("date_to", dateTo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddChargeAtTermEndRequest
    extends Request<AddChargeAtTermEndRequest> {
        private AddChargeAtTermEndRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddChargeAtTermEndRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public AddChargeAtTermEndRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public AddChargeAtTermEndRequest avalaraSaleType(AvalaraSaleType avalaraSaleType) {
            this.params.addOpt("avalara_sale_type", (Object)avalaraSaleType);
            return this;
        }

        public AddChargeAtTermEndRequest avalaraTransactionType(Integer avalaraTransactionType) {
            this.params.addOpt("avalara_transaction_type", avalaraTransactionType);
            return this;
        }

        public AddChargeAtTermEndRequest avalaraServiceType(Integer avalaraServiceType) {
            this.params.addOpt("avalara_service_type", avalaraServiceType);
            return this;
        }

        public AddChargeAtTermEndRequest dateFrom(Timestamp dateFrom) {
            this.params.addOpt("date_from", dateFrom);
            return this;
        }

        public AddChargeAtTermEndRequest dateTo(Timestamp dateTo) {
            this.params.addOpt("date_to", dateTo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReactivateRequest
    extends Request<ReactivateRequest> {
        private ReactivateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ReactivateRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public ReactivateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        @Deprecated
        public ReactivateRequest trialPeriodDays(Integer trialPeriodDays) {
            this.params.addOpt("trial_period_days", trialPeriodDays);
            return this;
        }

        public ReactivateRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public ReactivateRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public ReactivateRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public ReactivateRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public ReactivateRequest contractTermBillingCycleOnRenewal(Integer contractTermBillingCycleOnRenewal) {
            this.params.addOpt("contract_term_billing_cycle_on_renewal", contractTermBillingCycleOnRenewal);
            return this;
        }

        public ReactivateRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public ReactivateRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public ReactivateRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public ReactivateRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public ReactivateRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public ReactivateRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public ReactivateRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTermEndRequest
    extends Request<ChangeTermEndRequest> {
        private ChangeTermEndRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChangeTermEndRequest termEndsAt(Timestamp termEndsAt) {
            this.params.add("term_ends_at", termEndsAt);
            return this;
        }

        public ChangeTermEndRequest prorate(Boolean prorate) {
            this.params.addOpt("prorate", prorate);
            return this;
        }

        public ChangeTermEndRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest planId(String planId) {
            this.params.addOpt("plan_id", planId);
            return this;
        }

        public UpdateRequest planQuantity(Integer planQuantity) {
            this.params.addOpt("plan_quantity", planQuantity);
            return this;
        }

        public UpdateRequest planUnitPrice(Integer planUnitPrice) {
            this.params.addOpt("plan_unit_price", planUnitPrice);
            return this;
        }

        public UpdateRequest setupFee(Integer setupFee) {
            this.params.addOpt("setup_fee", setupFee);
            return this;
        }

        public UpdateRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public UpdateRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public UpdateRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public UpdateRequest startDate(Timestamp startDate) {
            this.params.addOpt("start_date", startDate);
            return this;
        }

        public UpdateRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public UpdateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        @Deprecated
        public UpdateRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public UpdateRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public UpdateRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public UpdateRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public UpdateRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public UpdateRequest offlinePaymentMethod(OfflinePaymentMethod offlinePaymentMethod) {
            this.params.addOpt("offline_payment_method", (Object)offlinePaymentMethod);
            return this;
        }

        public UpdateRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public UpdateRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public UpdateRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public UpdateRequest replaceCouponList(Boolean replaceCouponList) {
            this.params.addOpt("replace_coupon_list", replaceCouponList);
            return this;
        }

        public UpdateRequest prorate(Boolean prorate) {
            this.params.addOpt("prorate", prorate);
            return this;
        }

        public UpdateRequest endOfTerm(Boolean endOfTerm) {
            this.params.addOpt("end_of_term", endOfTerm);
            return this;
        }

        public UpdateRequest forceTermReset(Boolean forceTermReset) {
            this.params.addOpt("force_term_reset", forceTermReset);
            return this;
        }

        public UpdateRequest reactivate(Boolean reactivate) {
            this.params.addOpt("reactivate", reactivate);
            return this;
        }

        public UpdateRequest tokenId(String tokenId) {
            this.params.addOpt("token_id", tokenId);
            return this;
        }

        public UpdateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public UpdateRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public UpdateRequest overrideRelationship(Boolean overrideRelationship) {
            this.params.addOpt("override_relationship", overrideRelationship);
            return this;
        }

        public UpdateRequest contractTermBillingCycleOnRenewal(Integer contractTermBillingCycleOnRenewal) {
            this.params.addOpt("contract_term_billing_cycle_on_renewal", contractTermBillingCycleOnRenewal);
            return this;
        }

        public UpdateRequest freePeriod(Integer freePeriod) {
            this.params.addOpt("free_period", freePeriod);
            return this;
        }

        public UpdateRequest freePeriodUnit(FreePeriodUnit freePeriodUnit) {
            this.params.addOpt("free_period_unit", (Object)freePeriodUnit);
            return this;
        }

        @Deprecated
        public UpdateRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public UpdateRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Deprecated
        public UpdateRequest cardTmpToken(String cardTmpToken) {
            this.params.addOpt("card[tmp_token]", cardTmpToken);
            return this;
        }

        public UpdateRequest paymentMethodType(Type paymentMethodType) {
            this.params.addOpt("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        @Deprecated
        public UpdateRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public UpdateRequest paymentMethodGatewayAccountId(String paymentMethodGatewayAccountId) {
            this.params.addOpt("payment_method[gateway_account_id]", paymentMethodGatewayAccountId);
            return this;
        }

        public UpdateRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public UpdateRequest paymentMethodTmpToken(String paymentMethodTmpToken) {
            this.params.addOpt("payment_method[tmp_token]", paymentMethodTmpToken);
            return this;
        }

        public UpdateRequest paymentMethodIssuingCountry(String paymentMethodIssuingCountry) {
            this.params.addOpt("payment_method[issuing_country]", paymentMethodIssuingCountry);
            return this;
        }

        public UpdateRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public UpdateRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public UpdateRequest cardNumber(String cardNumber) {
            this.params.addOpt("card[number]", cardNumber);
            return this;
        }

        public UpdateRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public UpdateRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public UpdateRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public UpdateRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public UpdateRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public UpdateRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public UpdateRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public UpdateRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public UpdateRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public UpdateRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Deprecated
        public UpdateRequest cardIpAddress(String cardIpAddress) {
            this.params.addOpt("card[ip_address]", cardIpAddress);
            return this;
        }

        public UpdateRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public UpdateRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public UpdateRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public UpdateRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public UpdateRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        public UpdateRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public UpdateRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public UpdateRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public UpdateRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public UpdateRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public UpdateRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public UpdateRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public UpdateRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public UpdateRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public UpdateRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public UpdateRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public UpdateRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public UpdateRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public UpdateRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public UpdateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public UpdateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public UpdateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public UpdateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public UpdateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public UpdateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public UpdateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public UpdateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public UpdateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public UpdateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public UpdateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public UpdateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public UpdateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public UpdateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public UpdateRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public UpdateRequest customerBusinessCustomerWithoutVatNumber(Boolean customerBusinessCustomerWithoutVatNumber) {
            this.params.addOpt("customer[business_customer_without_vat_number]", customerBusinessCustomerWithoutVatNumber);
            return this;
        }

        public UpdateRequest customerRegisteredForGst(Boolean customerRegisteredForGst) {
            this.params.addOpt("customer[registered_for_gst]", customerRegisteredForGst);
            return this;
        }

        public UpdateRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public UpdateRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public UpdateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public UpdateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public UpdateRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public UpdateRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public UpdateRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public UpdateRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public UpdateRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public UpdateRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public UpdateRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public UpdateRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public UpdateRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public UpdateRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveCouponsRequest
    extends Request<RemoveCouponsRequest> {
        private RemoveCouponsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemoveCouponsRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public RemoveCouponsRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveScheduledCancellationRequest
    extends Request<RemoveScheduledCancellationRequest> {
        private RemoveScheduledCancellationRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemoveScheduledCancellationRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubscriptionListRequest
    extends ListRequest<SubscriptionListRequest> {
        private SubscriptionListRequest(String uri) {
            super(uri);
        }

        public SubscriptionListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<SubscriptionListRequest> id() {
            return new StringFilter<SubscriptionListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionListRequest> customerId() {
            return new StringFilter<SubscriptionListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionListRequest> planId() {
            return new StringFilter<SubscriptionListRequest>("plan_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Status, SubscriptionListRequest> status() {
            return new EnumFilter<Status, SubscriptionListRequest>("status", this);
        }

        public EnumFilter<CancelReason, SubscriptionListRequest> cancelReason() {
            return new EnumFilter("cancel_reason", this).supportsPresenceOperator(true);
        }

        public StringFilter<SubscriptionListRequest> cancelReasonCode() {
            return new StringFilter<SubscriptionListRequest>("cancel_reason_code", this).supportsMultiOperators(true);
        }

        public NumberFilter<Integer, SubscriptionListRequest> remainingBillingCycles() {
            return new NumberFilter("remaining_billing_cycles", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<SubscriptionListRequest> createdAt() {
            return new TimestampFilter<SubscriptionListRequest>("created_at", this);
        }

        public TimestampFilter<SubscriptionListRequest> activatedAt() {
            return new TimestampFilter<SubscriptionListRequest>("activated_at", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<SubscriptionListRequest> nextBillingAt() {
            return new TimestampFilter<SubscriptionListRequest>("next_billing_at", this);
        }

        public TimestampFilter<SubscriptionListRequest> cancelledAt() {
            return new TimestampFilter<SubscriptionListRequest>("cancelled_at", this);
        }

        public BooleanFilter<SubscriptionListRequest> hasScheduledChanges() {
            return new BooleanFilter<SubscriptionListRequest>("has_scheduled_changes", this);
        }

        public TimestampFilter<SubscriptionListRequest> updatedAt() {
            return new TimestampFilter<SubscriptionListRequest>("updated_at", this);
        }

        public EnumFilter<OfflinePaymentMethod, SubscriptionListRequest> offlinePaymentMethod() {
            return new EnumFilter<OfflinePaymentMethod, SubscriptionListRequest>("offline_payment_method", this);
        }

        public BooleanFilter<SubscriptionListRequest> overrideRelationship() {
            return new BooleanFilter<SubscriptionListRequest>("override_relationship", this);
        }

        public SubscriptionListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        public SubscriptionListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateForCustomerRequest
    extends Request<CreateForCustomerRequest> {
        private CreateForCustomerRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateForCustomerRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateForCustomerRequest planId(String planId) {
            this.params.add("plan_id", planId);
            return this;
        }

        public CreateForCustomerRequest planQuantity(Integer planQuantity) {
            this.params.addOpt("plan_quantity", planQuantity);
            return this;
        }

        public CreateForCustomerRequest planUnitPrice(Integer planUnitPrice) {
            this.params.addOpt("plan_unit_price", planUnitPrice);
            return this;
        }

        public CreateForCustomerRequest setupFee(Integer setupFee) {
            this.params.addOpt("setup_fee", setupFee);
            return this;
        }

        public CreateForCustomerRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public CreateForCustomerRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateForCustomerRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateForCustomerRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateForCustomerRequest startDate(Timestamp startDate) {
            this.params.addOpt("start_date", startDate);
            return this;
        }

        @Deprecated
        public CreateForCustomerRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateForCustomerRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public CreateForCustomerRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CreateForCustomerRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CreateForCustomerRequest offlinePaymentMethod(OfflinePaymentMethod offlinePaymentMethod) {
            this.params.addOpt("offline_payment_method", (Object)offlinePaymentMethod);
            return this;
        }

        public CreateForCustomerRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public CreateForCustomerRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateForCustomerRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateForCustomerRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CreateForCustomerRequest overrideRelationship(Boolean overrideRelationship) {
            this.params.addOpt("override_relationship", overrideRelationship);
            return this;
        }

        public CreateForCustomerRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateForCustomerRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public CreateForCustomerRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public CreateForCustomerRequest freePeriod(Integer freePeriod) {
            this.params.addOpt("free_period", freePeriod);
            return this;
        }

        public CreateForCustomerRequest freePeriodUnit(FreePeriodUnit freePeriodUnit) {
            this.params.addOpt("free_period_unit", (Object)freePeriodUnit);
            return this;
        }

        public CreateForCustomerRequest contractTermBillingCycleOnRenewal(Integer contractTermBillingCycleOnRenewal) {
            this.params.addOpt("contract_term_billing_cycle_on_renewal", contractTermBillingCycleOnRenewal);
            return this;
        }

        public CreateForCustomerRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateForCustomerRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateForCustomerRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateForCustomerRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateForCustomerRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateForCustomerRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateForCustomerRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateForCustomerRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateForCustomerRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateForCustomerRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateForCustomerRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateForCustomerRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateForCustomerRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateForCustomerRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateForCustomerRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public CreateForCustomerRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public CreateForCustomerRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public CreateForCustomerRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public CreateForCustomerRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        public CreateForCustomerRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CreateForCustomerRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CreateForCustomerRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateForCustomerRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateForCustomerRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateForCustomerRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public CreateForCustomerRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public CreateForCustomerRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public CreateForCustomerRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public CreateForCustomerRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public CreateForCustomerRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public CreateForCustomerRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public CreateForCustomerRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public CreateForCustomerRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateRequest planId(String planId) {
            this.params.add("plan_id", planId);
            return this;
        }

        public CreateRequest planQuantity(Integer planQuantity) {
            this.params.addOpt("plan_quantity", planQuantity);
            return this;
        }

        public CreateRequest planUnitPrice(Integer planUnitPrice) {
            this.params.addOpt("plan_unit_price", planUnitPrice);
            return this;
        }

        public CreateRequest setupFee(Integer setupFee) {
            this.params.addOpt("setup_fee", setupFee);
            return this;
        }

        public CreateRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public CreateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateRequest startDate(Timestamp startDate) {
            this.params.addOpt("start_date", startDate);
            return this;
        }

        @Deprecated
        public CreateRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public CreateRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CreateRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CreateRequest offlinePaymentMethod(OfflinePaymentMethod offlinePaymentMethod) {
            this.params.addOpt("offline_payment_method", (Object)offlinePaymentMethod);
            return this;
        }

        public CreateRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public CreateRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateRequest tokenId(String tokenId) {
            this.params.addOpt("token_id", tokenId);
            return this;
        }

        public CreateRequest affiliateToken(String affiliateToken) {
            this.params.addOpt("affiliate_token", affiliateToken);
            return this;
        }

        @Deprecated
        public CreateRequest createdFromIp(String createdFromIp) {
            this.params.addOpt("created_from_ip", createdFromIp);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public CreateRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public CreateRequest freePeriod(Integer freePeriod) {
            this.params.addOpt("free_period", freePeriod);
            return this;
        }

        public CreateRequest freePeriodUnit(FreePeriodUnit freePeriodUnit) {
            this.params.addOpt("free_period_unit", (Object)freePeriodUnit);
            return this;
        }

        public CreateRequest contractTermBillingCycleOnRenewal(Integer contractTermBillingCycleOnRenewal) {
            this.params.addOpt("contract_term_billing_cycle_on_renewal", contractTermBillingCycleOnRenewal);
            return this;
        }

        public CreateRequest clientProfileId(String clientProfileId) {
            this.params.addOpt("client_profile_id", clientProfileId);
            return this;
        }

        public CreateRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public CreateRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public CreateRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public CreateRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        public CreateRequest customerCompany(String customerCompany) {
            this.params.addOpt("customer[company]", customerCompany);
            return this;
        }

        public CreateRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CreateRequest customerLocale(String customerLocale) {
            this.params.addOpt("customer[locale]", customerLocale);
            return this;
        }

        public CreateRequest customerEntityCode(EntityCode customerEntityCode) {
            this.params.addOpt("customer[entity_code]", (Object)customerEntityCode);
            return this;
        }

        public CreateRequest customerExemptNumber(String customerExemptNumber) {
            this.params.addOpt("customer[exempt_number]", customerExemptNumber);
            return this;
        }

        public CreateRequest customerNetTermDays(Integer customerNetTermDays) {
            this.params.addOpt("customer[net_term_days]", customerNetTermDays);
            return this;
        }

        public CreateRequest customerTaxjarExemptionCategory(TaxjarExemptionCategory customerTaxjarExemptionCategory) {
            this.params.addOpt("customer[taxjar_exemption_category]", (Object)customerTaxjarExemptionCategory);
            return this;
        }

        public CreateRequest customerPhone(String customerPhone) {
            this.params.addOpt("customer[phone]", customerPhone);
            return this;
        }

        public CreateRequest customerAutoCollection(AutoCollection customerAutoCollection) {
            this.params.addOpt("customer[auto_collection]", (Object)customerAutoCollection);
            return this;
        }

        public CreateRequest customerOfflinePaymentMethod(OfflinePaymentMethod customerOfflinePaymentMethod) {
            this.params.addOpt("customer[offline_payment_method]", (Object)customerOfflinePaymentMethod);
            return this;
        }

        public CreateRequest customerAllowDirectDebit(Boolean customerAllowDirectDebit) {
            this.params.addOpt("customer[allow_direct_debit]", customerAllowDirectDebit);
            return this;
        }

        public CreateRequest customerConsolidatedInvoicing(Boolean customerConsolidatedInvoicing) {
            this.params.addOpt("customer[consolidated_invoicing]", customerConsolidatedInvoicing);
            return this;
        }

        @Deprecated
        public CreateRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CreateRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Deprecated
        public CreateRequest cardTmpToken(String cardTmpToken) {
            this.params.addOpt("card[tmp_token]", cardTmpToken);
            return this;
        }

        public CreateRequest bankAccountGatewayAccountId(String bankAccountGatewayAccountId) {
            this.params.addOpt("bank_account[gateway_account_id]", bankAccountGatewayAccountId);
            return this;
        }

        public CreateRequest bankAccountIban(String bankAccountIban) {
            this.params.addOpt("bank_account[iban]", bankAccountIban);
            return this;
        }

        public CreateRequest bankAccountFirstName(String bankAccountFirstName) {
            this.params.addOpt("bank_account[first_name]", bankAccountFirstName);
            return this;
        }

        public CreateRequest bankAccountLastName(String bankAccountLastName) {
            this.params.addOpt("bank_account[last_name]", bankAccountLastName);
            return this;
        }

        public CreateRequest bankAccountCompany(String bankAccountCompany) {
            this.params.addOpt("bank_account[company]", bankAccountCompany);
            return this;
        }

        public CreateRequest bankAccountEmail(String bankAccountEmail) {
            this.params.addOpt("bank_account[email]", bankAccountEmail);
            return this;
        }

        public CreateRequest bankAccountBankName(String bankAccountBankName) {
            this.params.addOpt("bank_account[bank_name]", bankAccountBankName);
            return this;
        }

        public CreateRequest bankAccountAccountNumber(String bankAccountAccountNumber) {
            this.params.addOpt("bank_account[account_number]", bankAccountAccountNumber);
            return this;
        }

        public CreateRequest bankAccountRoutingNumber(String bankAccountRoutingNumber) {
            this.params.addOpt("bank_account[routing_number]", bankAccountRoutingNumber);
            return this;
        }

        public CreateRequest bankAccountBankCode(String bankAccountBankCode) {
            this.params.addOpt("bank_account[bank_code]", bankAccountBankCode);
            return this;
        }

        public CreateRequest bankAccountAccountType(AccountType bankAccountAccountType) {
            this.params.addOpt("bank_account[account_type]", (Object)bankAccountAccountType);
            return this;
        }

        public CreateRequest bankAccountAccountHolderType(AccountHolderType bankAccountAccountHolderType) {
            this.params.addOpt("bank_account[account_holder_type]", (Object)bankAccountAccountHolderType);
            return this;
        }

        public CreateRequest bankAccountEcheckType(EcheckType bankAccountEcheckType) {
            this.params.addOpt("bank_account[echeck_type]", (Object)bankAccountEcheckType);
            return this;
        }

        public CreateRequest bankAccountIssuingCountry(String bankAccountIssuingCountry) {
            this.params.addOpt("bank_account[issuing_country]", bankAccountIssuingCountry);
            return this;
        }

        public CreateRequest bankAccountSwedishIdentityNumber(String bankAccountSwedishIdentityNumber) {
            this.params.addOpt("bank_account[swedish_identity_number]", bankAccountSwedishIdentityNumber);
            return this;
        }

        public CreateRequest paymentMethodType(Type paymentMethodType) {
            this.params.addOpt("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        @Deprecated
        public CreateRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public CreateRequest paymentMethodGatewayAccountId(String paymentMethodGatewayAccountId) {
            this.params.addOpt("payment_method[gateway_account_id]", paymentMethodGatewayAccountId);
            return this;
        }

        public CreateRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public CreateRequest paymentMethodTmpToken(String paymentMethodTmpToken) {
            this.params.addOpt("payment_method[tmp_token]", paymentMethodTmpToken);
            return this;
        }

        public CreateRequest paymentMethodIssuingCountry(String paymentMethodIssuingCountry) {
            this.params.addOpt("payment_method[issuing_country]", paymentMethodIssuingCountry);
            return this;
        }

        public CreateRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public CreateRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public CreateRequest cardNumber(String cardNumber) {
            this.params.addOpt("card[number]", cardNumber);
            return this;
        }

        public CreateRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public CreateRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public CreateRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public CreateRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public CreateRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public CreateRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public CreateRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public CreateRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public CreateRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public CreateRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Deprecated
        public CreateRequest cardIpAddress(String cardIpAddress) {
            this.params.addOpt("card[ip_address]", cardIpAddress);
            return this;
        }

        public CreateRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public CreateRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public CreateRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public CreateRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public CreateRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        public CreateRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public CreateRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public CreateRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public CreateRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public CreateRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public CreateRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CreateRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CreateRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CreateRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CreateRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CreateRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public CreateRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CreateRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CreateRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CreateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CreateRequest customerRegisteredForGst(Boolean customerRegisteredForGst) {
            this.params.addOpt("customer[registered_for_gst]", customerRegisteredForGst);
            return this;
        }

        public CreateRequest customerBusinessCustomerWithoutVatNumber(Boolean customerBusinessCustomerWithoutVatNumber) {
            this.params.addOpt("customer[business_customer_without_vat_number]", customerBusinessCustomerWithoutVatNumber);
            return this;
        }

        public CreateRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CreateRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CreateRequest customerExemptionDetails(JSONArray customerExemptionDetails) {
            this.params.addOpt("customer[exemption_details]", customerExemptionDetails);
            return this;
        }

        public CreateRequest customerCustomerType(CustomerType customerCustomerType) {
            this.params.addOpt("customer[customer_type]", (Object)customerCustomerType);
            return this;
        }

        public CreateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public CreateRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public CreateRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public CreateRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public CreateRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public CreateRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public CreateRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public CreateRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public CreateRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContractTerm
    extends Resource<ContractTerm> {
        public ContractTerm(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public Timestamp contractStart() {
            return this.reqTimestamp("contract_start");
        }

        public Timestamp contractEnd() {
            return this.reqTimestamp("contract_end");
        }

        public Integer billingCycle() {
            return this.reqInteger("billing_cycle");
        }

        public ActionAtTermEnd actionAtTermEnd() {
            return this.reqEnum("action_at_term_end", ActionAtTermEnd.class);
        }

        public Long totalContractValue() {
            return this.reqLong("total_contract_value");
        }

        public Integer cancellationCutoffPeriod() {
            return this.optInteger("cancellation_cutoff_period");
        }

        public Timestamp createdAt() {
            return this.reqTimestamp("created_at");
        }

        public String subscriptionId() {
            return this.reqString("subscription_id");
        }

        public Integer remainingBillingCycles() {
            return this.optInteger("remaining_billing_cycles");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ActionAtTermEnd {
            RENEW,
            EVERGREEN,
            CANCEL,
            RENEW_ONCE,
            _UNKNOWN;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Status {
            ACTIVE,
            COMPLETED,
            CANCELLED,
            TERMINATED,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReferralInfo
    extends Resource<ReferralInfo> {
        public ReferralInfo(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String referralCode() {
            return this.optString("referral_code");
        }

        public String couponCode() {
            return this.optString("coupon_code");
        }

        public String referrerId() {
            return this.optString("referrer_id");
        }

        public String externalReferenceId() {
            return this.optString("external_reference_id");
        }

        public RewardStatus rewardStatus() {
            return this.optEnum("reward_status", RewardStatus.class);
        }

        public ReferralSystem referralSystem() {
            return this.optEnum("referral_system", ReferralSystem.class);
        }

        public String accountId() {
            return this.reqString("account_id");
        }

        public String campaignId() {
            return this.reqString("campaign_id");
        }

        public String externalCampaignId() {
            return this.optString("external_campaign_id");
        }

        public FriendOfferType friendOfferType() {
            return this.optEnum("friend_offer_type", FriendOfferType.class);
        }

        public ReferrerRewardType referrerRewardType() {
            return this.optEnum("referrer_reward_type", ReferrerRewardType.class);
        }

        public NotifyReferralSystem notifyReferralSystem() {
            return this.optEnum("notify_referral_system", NotifyReferralSystem.class);
        }

        public String destinationUrl() {
            return this.optString("destination_url");
        }

        public Boolean postPurchaseWidgetEnabled() {
            return this.reqBoolean("post_purchase_widget_enabled");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RewardStatus {
            PENDING,
            PAID,
            INVALID,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Coupon
    extends Resource<Coupon> {
        public Coupon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String couponId() {
            return this.reqString("coupon_id");
        }

        public Timestamp applyTill() {
            return this.optTimestamp("apply_till");
        }

        public Integer appliedCount() {
            return this.reqInteger("applied_count");
        }

        public String couponCode() {
            return this.optString("coupon_code");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChargedEventBasedAddon
    extends Resource<ChargedEventBasedAddon> {
        public ChargedEventBasedAddon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Timestamp lastChargedAt() {
            return this.reqTimestamp("last_charged_at");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventBasedAddon
    extends Resource<EventBasedAddon> {
        public EventBasedAddon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Integer quantity() {
            return this.reqInteger("quantity");
        }

        public Integer unitPrice() {
            return this.reqInteger("unit_price");
        }

        @Deprecated
        public Integer servicePeriodInDays() {
            return this.optInteger("service_period_in_days");
        }

        public OnEvent onEvent() {
            return this.reqEnum("on_event", OnEvent.class);
        }

        public Boolean chargeOnce() {
            return this.reqBoolean("charge_once");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum OnEvent {
            SUBSCRIPTION_CREATION,
            SUBSCRIPTION_TRIAL_START,
            PLAN_ACTIVATION,
            SUBSCRIPTION_ACTIVATION,
            CONTRACT_TERMINATION,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Addon
    extends Resource<Addon> {
        public Addon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Integer unitPrice() {
            return this.optInteger("unit_price");
        }

        public Integer amount() {
            return this.optInteger("amount");
        }

        public Timestamp trialEnd() {
            return this.optTimestamp("trial_end");
        }

        public Integer remainingBillingCycles() {
            return this.optInteger("remaining_billing_cycles");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CancelReason {
        NOT_PAID,
        NO_CARD,
        FRAUD_REVIEW_FAILED,
        NON_COMPLIANT_EU_CUSTOMER,
        TAX_CALCULATION_FAILED,
        CURRENCY_INCOMPATIBLE_WITH_GATEWAY,
        NON_COMPLIANT_CUSTOMER,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        FUTURE,
        IN_TRIAL,
        ACTIVE,
        NON_RENEWING,
        PAUSED,
        CANCELLED,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BillingPeriodUnit {
        DAY,
        WEEK,
        MONTH,
        YEAR,
        _UNKNOWN;

    }
}

