/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.ContractTerm;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.AvalaraSaleType;
import com.chargebee.models.enums.BillingAlignmentMode;
import com.chargebee.models.enums.ChargeOn;
import com.chargebee.models.enums.DispositionType;
import com.chargebee.models.enums.OfflinePaymentMethod;
import com.chargebee.models.enums.OnEvent;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.models.enums.TaxExemptReason;
import com.chargebee.models.enums.TaxJurisType;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Quote
extends Resource<Quote> {
    public Quote(String jsonStr) {
        super(jsonStr);
    }

    public Quote(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.optString("name");
    }

    public String poNumber() {
        return this.optString("po_number");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public String invoiceId() {
        return this.optString("invoice_id");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public OperationType operationType() {
        return this.reqEnum("operation_type", OperationType.class);
    }

    public String vatNumber() {
        return this.optString("vat_number");
    }

    public PriceType priceType() {
        return this.reqEnum("price_type", PriceType.class);
    }

    public Timestamp validTill() {
        return this.reqTimestamp("valid_till");
    }

    public Timestamp date() {
        return this.reqTimestamp("date");
    }

    public Long totalPayable() {
        return this.optLong("total_payable");
    }

    public Integer chargeOnAcceptance() {
        return this.optInteger("charge_on_acceptance");
    }

    public Integer subTotal() {
        return this.reqInteger("sub_total");
    }

    public Integer total() {
        return this.optInteger("total");
    }

    public Integer creditsApplied() {
        return this.optInteger("credits_applied");
    }

    public Integer amountPaid() {
        return this.optInteger("amount_paid");
    }

    public Integer amountDue() {
        return this.optInteger("amount_due");
    }

    public Integer version() {
        return this.optInteger("version");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public List<LineItem> lineItems() {
        return this.optList("line_items", LineItem.class);
    }

    public List<Discount> discounts() {
        return this.optList("discounts", Discount.class);
    }

    public List<LineItemDiscount> lineItemDiscounts() {
        return this.optList("line_item_discounts", LineItemDiscount.class);
    }

    public List<Tax> taxes() {
        return this.optList("taxes", Tax.class);
    }

    public List<LineItemTax> lineItemTaxes() {
        return this.optList("line_item_taxes", LineItemTax.class);
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public JSONArray notes() {
        return this.optJSONArray("notes");
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public BillingAddress billingAddress() {
        return this.optSubResource("billing_address", BillingAddress.class);
    }

    public Timestamp contractTermStart() {
        return this.optTimestamp("contract_term_start");
    }

    public Timestamp contractTermEnd() {
        return this.optTimestamp("contract_term_end");
    }

    public Integer contractTermTerminationFee() {
        return this.optInteger("contract_term_termination_fee");
    }

    public static Request retrieve(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static CreateSubForCustomerQuoteRequest createSubForCustomerQuote(String id) {
        String uri = Quote.uri("customers", Quote.nullCheck(id), "create_subscription_quote");
        return new CreateSubForCustomerQuoteRequest(HttpUtil.Method.POST, uri);
    }

    public static EditCreateSubForCustomerQuoteRequest editCreateSubForCustomerQuote(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "edit_create_subscription_quote");
        return new EditCreateSubForCustomerQuoteRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateSubscriptionQuoteRequest updateSubscriptionQuote() {
        String uri = Quote.uri("quotes", "update_subscription_quote");
        return new UpdateSubscriptionQuoteRequest(HttpUtil.Method.POST, uri);
    }

    public static EditUpdateSubscriptionQuoteRequest editUpdateSubscriptionQuote(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "edit_update_subscription_quote");
        return new EditUpdateSubscriptionQuoteRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateForOnetimeChargesRequest createForOnetimeCharges() {
        String uri = Quote.uri("quotes", "create_for_onetime_charges");
        return new CreateForOnetimeChargesRequest(HttpUtil.Method.POST, uri);
    }

    public static EditOneTimeQuoteRequest editOneTimeQuote(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "edit_one_time_quote");
        return new EditOneTimeQuoteRequest(HttpUtil.Method.POST, uri);
    }

    public static QuoteListRequest list() {
        String uri = Quote.uri("quotes");
        return new QuoteListRequest(uri);
    }

    public static ListRequest quoteLineGroupsForQuote(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "quote_line_groups");
        return new ListRequest(uri);
    }

    public static ConvertRequest convert(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "convert");
        return new ConvertRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateStatusRequest updateStatus(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "update_status");
        return new UpdateStatusRequest(HttpUtil.Method.POST, uri);
    }

    public static ExtendExpiryDateRequest extendExpiryDate(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "extend_expiry_date");
        return new ExtendExpiryDateRequest(HttpUtil.Method.POST, uri);
    }

    public static DeleteRequest delete(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    public static PdfRequest pdf(String id) {
        String uri = Quote.uri("quotes", Quote.nullCheck(id), "pdf");
        return new PdfRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PdfRequest
    extends Request<PdfRequest> {
        private PdfRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public PdfRequest consolidatedView(Boolean consolidatedView) {
            this.params.addOpt("consolidated_view", consolidatedView);
            return this;
        }

        public PdfRequest dispositionType(DispositionType dispositionType) {
            this.params.addOpt("disposition_type", (Object)dispositionType);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtendExpiryDateRequest
    extends Request<ExtendExpiryDateRequest> {
        private ExtendExpiryDateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ExtendExpiryDateRequest validTill(Timestamp validTill) {
            this.params.add("valid_till", validTill);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateStatusRequest
    extends Request<UpdateStatusRequest> {
        private UpdateStatusRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateStatusRequest status(Status status) {
            this.params.add("status", (Object)status);
            return this;
        }

        public UpdateStatusRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConvertRequest
    extends Request<ConvertRequest> {
        private ConvertRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ConvertRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public ConvertRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public ConvertRequest subscriptionPoNumber(String subscriptionPoNumber) {
            this.params.addOpt("subscription[po_number]", subscriptionPoNumber);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QuoteListRequest
    extends ListRequest<QuoteListRequest> {
        private QuoteListRequest(String uri) {
            super(uri);
        }

        public QuoteListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<QuoteListRequest> id() {
            return new StringFilter<QuoteListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<QuoteListRequest> customerId() {
            return new StringFilter<QuoteListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public StringFilter<QuoteListRequest> subscriptionId() {
            return new StringFilter<QuoteListRequest>("subscription_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public EnumFilter<Status, QuoteListRequest> status() {
            return new EnumFilter<Status, QuoteListRequest>("status", this);
        }

        public TimestampFilter<QuoteListRequest> date() {
            return new TimestampFilter<QuoteListRequest>("date", this);
        }

        public TimestampFilter<QuoteListRequest> updatedAt() {
            return new TimestampFilter<QuoteListRequest>("updated_at", this);
        }

        public QuoteListRequest sortByDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "date");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditOneTimeQuoteRequest
    extends Request<EditOneTimeQuoteRequest> {
        private EditOneTimeQuoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public EditOneTimeQuoteRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public EditOneTimeQuoteRequest notes(String notes) {
            this.params.addOpt("notes", notes);
            return this;
        }

        public EditOneTimeQuoteRequest expiresAt(Timestamp expiresAt) {
            this.params.addOpt("expires_at", expiresAt);
            return this;
        }

        public EditOneTimeQuoteRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public EditOneTimeQuoteRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public EditOneTimeQuoteRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public EditOneTimeQuoteRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public EditOneTimeQuoteRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public EditOneTimeQuoteRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public EditOneTimeQuoteRequest addonServicePeriod(int index, Integer addonServicePeriod) {
            this.params.addOpt("addons[service_period][" + index + "]", addonServicePeriod);
            return this;
        }

        public EditOneTimeQuoteRequest chargeAmount(int index, Integer chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public EditOneTimeQuoteRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        public EditOneTimeQuoteRequest chargeAvalaraSaleType(int index, AvalaraSaleType chargeAvalaraSaleType) {
            this.params.addOpt("charges[avalara_sale_type][" + index + "]", (Object)chargeAvalaraSaleType);
            return this;
        }

        public EditOneTimeQuoteRequest chargeAvalaraTransactionType(int index, Integer chargeAvalaraTransactionType) {
            this.params.addOpt("charges[avalara_transaction_type][" + index + "]", chargeAvalaraTransactionType);
            return this;
        }

        public EditOneTimeQuoteRequest chargeAvalaraServiceType(int index, Integer chargeAvalaraServiceType) {
            this.params.addOpt("charges[avalara_service_type][" + index + "]", chargeAvalaraServiceType);
            return this;
        }

        public EditOneTimeQuoteRequest chargeServicePeriod(int index, Integer chargeServicePeriod) {
            this.params.addOpt("charges[service_period][" + index + "]", chargeServicePeriod);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateForOnetimeChargesRequest
    extends Request<CreateForOnetimeChargesRequest> {
        private CreateForOnetimeChargesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateForOnetimeChargesRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public CreateForOnetimeChargesRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateForOnetimeChargesRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public CreateForOnetimeChargesRequest notes(String notes) {
            this.params.addOpt("notes", notes);
            return this;
        }

        public CreateForOnetimeChargesRequest expiresAt(Timestamp expiresAt) {
            this.params.addOpt("expires_at", expiresAt);
            return this;
        }

        public CreateForOnetimeChargesRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateForOnetimeChargesRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateForOnetimeChargesRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateForOnetimeChargesRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateForOnetimeChargesRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateForOnetimeChargesRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateForOnetimeChargesRequest addonServicePeriod(int index, Integer addonServicePeriod) {
            this.params.addOpt("addons[service_period][" + index + "]", addonServicePeriod);
            return this;
        }

        public CreateForOnetimeChargesRequest chargeAmount(int index, Integer chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CreateForOnetimeChargesRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        public CreateForOnetimeChargesRequest chargeAvalaraSaleType(int index, AvalaraSaleType chargeAvalaraSaleType) {
            this.params.addOpt("charges[avalara_sale_type][" + index + "]", (Object)chargeAvalaraSaleType);
            return this;
        }

        public CreateForOnetimeChargesRequest chargeAvalaraTransactionType(int index, Integer chargeAvalaraTransactionType) {
            this.params.addOpt("charges[avalara_transaction_type][" + index + "]", chargeAvalaraTransactionType);
            return this;
        }

        public CreateForOnetimeChargesRequest chargeAvalaraServiceType(int index, Integer chargeAvalaraServiceType) {
            this.params.addOpt("charges[avalara_service_type][" + index + "]", chargeAvalaraServiceType);
            return this;
        }

        public CreateForOnetimeChargesRequest chargeServicePeriod(int index, Integer chargeServicePeriod) {
            this.params.addOpt("charges[service_period][" + index + "]", chargeServicePeriod);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditUpdateSubscriptionQuoteRequest
    extends Request<EditUpdateSubscriptionQuoteRequest> {
        private EditUpdateSubscriptionQuoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public EditUpdateSubscriptionQuoteRequest notes(String notes) {
            this.params.addOpt("notes", notes);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest expiresAt(Timestamp expiresAt) {
            this.params.addOpt("expires_at", expiresAt);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest replaceCouponList(Boolean replaceCouponList) {
            this.params.addOpt("replace_coupon_list", replaceCouponList);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest forceTermReset(Boolean forceTermReset) {
            this.params.addOpt("force_term_reset", forceTermReset);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest reactivate(Boolean reactivate) {
            this.params.addOpt("reactivate", reactivate);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.addOpt("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        @Deprecated
        public EditUpdateSubscriptionQuoteRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest customerRegisteredForGst(Boolean customerRegisteredForGst) {
            this.params.addOpt("customer[registered_for_gst]", customerRegisteredForGst);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public EditUpdateSubscriptionQuoteRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateSubscriptionQuoteRequest
    extends Request<UpdateSubscriptionQuoteRequest> {
        private UpdateSubscriptionQuoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateSubscriptionQuoteRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateSubscriptionQuoteRequest notes(String notes) {
            this.params.addOpt("notes", notes);
            return this;
        }

        public UpdateSubscriptionQuoteRequest expiresAt(Timestamp expiresAt) {
            this.params.addOpt("expires_at", expiresAt);
            return this;
        }

        public UpdateSubscriptionQuoteRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public UpdateSubscriptionQuoteRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public UpdateSubscriptionQuoteRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public UpdateSubscriptionQuoteRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public UpdateSubscriptionQuoteRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public UpdateSubscriptionQuoteRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public UpdateSubscriptionQuoteRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public UpdateSubscriptionQuoteRequest replaceCouponList(Boolean replaceCouponList) {
            this.params.addOpt("replace_coupon_list", replaceCouponList);
            return this;
        }

        public UpdateSubscriptionQuoteRequest forceTermReset(Boolean forceTermReset) {
            this.params.addOpt("force_term_reset", forceTermReset);
            return this;
        }

        public UpdateSubscriptionQuoteRequest reactivate(Boolean reactivate) {
            this.params.addOpt("reactivate", reactivate);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.addOpt("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        @Deprecated
        public UpdateSubscriptionQuoteRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public UpdateSubscriptionQuoteRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public UpdateSubscriptionQuoteRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public UpdateSubscriptionQuoteRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public UpdateSubscriptionQuoteRequest customerRegisteredForGst(Boolean customerRegisteredForGst) {
            this.params.addOpt("customer[registered_for_gst]", customerRegisteredForGst);
            return this;
        }

        public UpdateSubscriptionQuoteRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public UpdateSubscriptionQuoteRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public UpdateSubscriptionQuoteRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public UpdateSubscriptionQuoteRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public UpdateSubscriptionQuoteRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public UpdateSubscriptionQuoteRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public UpdateSubscriptionQuoteRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public UpdateSubscriptionQuoteRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public UpdateSubscriptionQuoteRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public UpdateSubscriptionQuoteRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public UpdateSubscriptionQuoteRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public UpdateSubscriptionQuoteRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public UpdateSubscriptionQuoteRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public UpdateSubscriptionQuoteRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public UpdateSubscriptionQuoteRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditCreateSubForCustomerQuoteRequest
    extends Request<EditCreateSubForCustomerQuoteRequest> {
        private EditCreateSubForCustomerQuoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public EditCreateSubForCustomerQuoteRequest notes(String notes) {
            this.params.addOpt("notes", notes);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest expiresAt(Timestamp expiresAt) {
            this.params.addOpt("expires_at", expiresAt);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public EditCreateSubForCustomerQuoteRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateSubForCustomerQuoteRequest
    extends Request<CreateSubForCustomerQuoteRequest> {
        private CreateSubForCustomerQuoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateSubForCustomerQuoteRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public CreateSubForCustomerQuoteRequest notes(String notes) {
            this.params.addOpt("notes", notes);
            return this;
        }

        public CreateSubForCustomerQuoteRequest expiresAt(Timestamp expiresAt) {
            this.params.addOpt("expires_at", expiresAt);
            return this;
        }

        public CreateSubForCustomerQuoteRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateSubForCustomerQuoteRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateSubForCustomerQuoteRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateSubForCustomerQuoteRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CreateSubForCustomerQuoteRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CreateSubForCustomerQuoteRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubForCustomerQuoteRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateSubForCustomerQuoteRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateSubForCustomerQuoteRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CreateSubForCustomerQuoteRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CreateSubForCustomerQuoteRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public CreateSubForCustomerQuoteRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateSubForCustomerQuoteRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateSubForCustomerQuoteRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateSubForCustomerQuoteRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public CreateSubForCustomerQuoteRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public CreateSubForCustomerQuoteRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public CreateSubForCustomerQuoteRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public CreateSubForCustomerQuoteRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public CreateSubForCustomerQuoteRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public CreateSubForCustomerQuoteRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public CreateSubForCustomerQuoteRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public CreateSubForCustomerQuoteRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BillingAddress
    extends Resource<BillingAddress> {
        public BillingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItemTax
    extends Resource<LineItemTax> {
        public LineItemTax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public String taxName() {
            return this.reqString("tax_name");
        }

        public Double taxRate() {
            return this.reqDouble("tax_rate");
        }

        public Boolean isPartialTaxApplied() {
            return this.optBoolean("is_partial_tax_applied");
        }

        public Boolean isNonComplianceTax() {
            return this.optBoolean("is_non_compliance_tax");
        }

        public Integer taxableAmount() {
            return this.reqInteger("taxable_amount");
        }

        public Integer taxAmount() {
            return this.reqInteger("tax_amount");
        }

        public TaxJurisType taxJurisType() {
            return this.optEnum("tax_juris_type", TaxJurisType.class);
        }

        public String taxJurisName() {
            return this.optString("tax_juris_name");
        }

        public String taxJurisCode() {
            return this.optString("tax_juris_code");
        }

        public Integer taxAmountInLocalCurrency() {
            return this.optInteger("tax_amount_in_local_currency");
        }

        public String localCurrencyCode() {
            return this.optString("local_currency_code");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tax
    extends Resource<Tax> {
        public Tax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String name() {
            return this.reqString("name");
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItemDiscount
    extends Resource<LineItemDiscount> {
        public LineItemDiscount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.reqString("line_item_id");
        }

        public DiscountType discountType() {
            return this.reqEnum("discount_type", DiscountType.class);
        }

        public String couponId() {
            return this.optString("coupon_id");
        }

        public Integer discountAmount() {
            return this.reqInteger("discount_amount");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DiscountType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Discount
    extends Resource<Discount> {
        public Discount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItem
    extends Resource<LineItem> {
        public LineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.optString("id");
        }

        public String subscriptionId() {
            return this.optString("subscription_id");
        }

        public Timestamp dateFrom() {
            return this.reqTimestamp("date_from");
        }

        public Timestamp dateTo() {
            return this.reqTimestamp("date_to");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Integer amount() {
            return this.optInteger("amount");
        }

        public PricingModel pricingModel() {
            return this.optEnum("pricing_model", PricingModel.class);
        }

        public Boolean isTaxed() {
            return this.reqBoolean("is_taxed");
        }

        public Integer taxAmount() {
            return this.optInteger("tax_amount");
        }

        public Double taxRate() {
            return this.optDouble("tax_rate");
        }

        public Integer discountAmount() {
            return this.optInteger("discount_amount");
        }

        public Integer itemLevelDiscountAmount() {
            return this.optInteger("item_level_discount_amount");
        }

        public String description() {
            return this.reqString("description");
        }

        public String entityDescription() {
            return this.reqString("entity_description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public TaxExemptReason taxExemptReason() {
            return this.optEnum("tax_exempt_reason", TaxExemptReason.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public String customerId() {
            return this.optString("customer_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            PLAN_SETUP,
            PLAN,
            ADDON,
            ADHOC,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        CREATE_SUBSCRIPTION_FOR_CUSTOMER,
        CHANGE_SUBSCRIPTION,
        ONETIME_INVOICE,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OPEN,
        ACCEPTED,
        DECLINED,
        INVOICED,
        CLOSED,
        _UNKNOWN;

    }
}

