/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.ContractTerm;
import com.chargebee.models.CreditNoteEstimate;
import com.chargebee.models.InvoiceEstimate;
import com.chargebee.models.SubscriptionEstimate;
import com.chargebee.models.UnbilledCharge;
import com.chargebee.models.enums.AccountReceivablesHandling;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.AvalaraSaleType;
import com.chargebee.models.enums.BillingAlignmentMode;
import com.chargebee.models.enums.ChargeOn;
import com.chargebee.models.enums.ChargesHandling;
import com.chargebee.models.enums.CreditOptionForCurrentTermCharges;
import com.chargebee.models.enums.CustomerType;
import com.chargebee.models.enums.EntityCode;
import com.chargebee.models.enums.FreePeriodUnit;
import com.chargebee.models.enums.OfflinePaymentMethod;
import com.chargebee.models.enums.OnEvent;
import com.chargebee.models.enums.PauseOption;
import com.chargebee.models.enums.RefundableCreditsHandling;
import com.chargebee.models.enums.ResumeOption;
import com.chargebee.models.enums.Taxability;
import com.chargebee.models.enums.UnbilledChargesHandling;
import com.chargebee.models.enums.UnbilledChargesOption;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Estimate
extends Resource<Estimate> {
    public Estimate(String jsonStr) {
        super(jsonStr);
    }

    public Estimate(JSONObject jsonObj) {
        super(jsonObj);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public SubscriptionEstimate subscriptionEstimate() {
        return this.optSubResource("subscription_estimate", SubscriptionEstimate.class);
    }

    public InvoiceEstimate invoiceEstimate() {
        return this.optSubResource("invoice_estimate", InvoiceEstimate.class);
    }

    public List<InvoiceEstimate> invoiceEstimates() {
        return this.optList("invoice_estimates", InvoiceEstimate.class);
    }

    public InvoiceEstimate nextInvoiceEstimate() {
        return this.optSubResource("next_invoice_estimate", InvoiceEstimate.class);
    }

    public List<CreditNoteEstimate> creditNoteEstimates() {
        return this.optList("credit_note_estimates", CreditNoteEstimate.class);
    }

    public List<UnbilledCharge> unbilledChargeEstimates() {
        return this.optList("unbilled_charge_estimates", UnbilledCharge.class);
    }

    public static CreateSubscriptionRequest createSubscription() {
        String uri = Estimate.uri("estimates", "create_subscription");
        return new CreateSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateSubForCustomerEstimateRequest createSubForCustomerEstimate(String id) {
        String uri = Estimate.uri("customers", Estimate.nullCheck(id), "create_subscription_estimate");
        return new CreateSubForCustomerEstimateRequest(HttpUtil.Method.GET, uri);
    }

    public static UpdateSubscriptionRequest updateSubscription() {
        String uri = Estimate.uri("estimates", "update_subscription");
        return new UpdateSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static RenewalEstimateRequest renewalEstimate(String id) {
        String uri = Estimate.uri("subscriptions", Estimate.nullCheck(id), "renewal_estimate");
        return new RenewalEstimateRequest(HttpUtil.Method.GET, uri);
    }

    public static Request upcomingInvoicesEstimate(String id) {
        String uri = Estimate.uri("customers", Estimate.nullCheck(id), "upcoming_invoices_estimate");
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static ChangeTermEndRequest changeTermEnd(String id) {
        String uri = Estimate.uri("subscriptions", Estimate.nullCheck(id), "change_term_end_estimate");
        return new ChangeTermEndRequest(HttpUtil.Method.POST, uri);
    }

    public static CancelSubscriptionRequest cancelSubscription(String id) {
        String uri = Estimate.uri("subscriptions", Estimate.nullCheck(id), "cancel_subscription_estimate");
        return new CancelSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static PauseSubscriptionRequest pauseSubscription(String id) {
        String uri = Estimate.uri("subscriptions", Estimate.nullCheck(id), "pause_subscription_estimate");
        return new PauseSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static ResumeSubscriptionRequest resumeSubscription(String id) {
        String uri = Estimate.uri("subscriptions", Estimate.nullCheck(id), "resume_subscription_estimate");
        return new ResumeSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static GiftSubscriptionRequest giftSubscription() {
        String uri = Estimate.uri("estimates", "gift_subscription");
        return new GiftSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateInvoiceRequest createInvoice() {
        String uri = Estimate.uri("estimates", "create_invoice");
        return new CreateInvoiceRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateInvoiceRequest
    extends Request<CreateInvoiceRequest> {
        private CreateInvoiceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateInvoiceRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateInvoiceRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        @Deprecated
        public CreateInvoiceRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateInvoiceRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateInvoiceRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateInvoiceRequest authorizationTransactionId(String authorizationTransactionId) {
            this.params.addOpt("authorization_transaction_id", authorizationTransactionId);
            return this;
        }

        public CreateInvoiceRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CreateInvoiceRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public CreateInvoiceRequest invoiceCustomerId(String invoiceCustomerId) {
            this.params.addOpt("invoice[customer_id]", invoiceCustomerId);
            return this;
        }

        public CreateInvoiceRequest invoiceSubscriptionId(String invoiceSubscriptionId) {
            this.params.addOpt("invoice[subscription_id]", invoiceSubscriptionId);
            return this;
        }

        public CreateInvoiceRequest invoicePoNumber(String invoicePoNumber) {
            this.params.addOpt("invoice[po_number]", invoicePoNumber);
            return this;
        }

        public CreateInvoiceRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateInvoiceRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateInvoiceRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateInvoiceRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateInvoiceRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateInvoiceRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateInvoiceRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateInvoiceRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateInvoiceRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateInvoiceRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateInvoiceRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateInvoiceRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateInvoiceRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateInvoiceRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateInvoiceRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateInvoiceRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateInvoiceRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateInvoiceRequest addonDateFrom(int index, Timestamp addonDateFrom) {
            this.params.addOpt("addons[date_from][" + index + "]", addonDateFrom);
            return this;
        }

        public CreateInvoiceRequest addonDateTo(int index, Timestamp addonDateTo) {
            this.params.addOpt("addons[date_to][" + index + "]", addonDateTo);
            return this;
        }

        public CreateInvoiceRequest chargeAmount(int index, Integer chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CreateInvoiceRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        public CreateInvoiceRequest chargeAvalaraSaleType(int index, AvalaraSaleType chargeAvalaraSaleType) {
            this.params.addOpt("charges[avalara_sale_type][" + index + "]", (Object)chargeAvalaraSaleType);
            return this;
        }

        public CreateInvoiceRequest chargeAvalaraTransactionType(int index, Integer chargeAvalaraTransactionType) {
            this.params.addOpt("charges[avalara_transaction_type][" + index + "]", chargeAvalaraTransactionType);
            return this;
        }

        public CreateInvoiceRequest chargeAvalaraServiceType(int index, Integer chargeAvalaraServiceType) {
            this.params.addOpt("charges[avalara_service_type][" + index + "]", chargeAvalaraServiceType);
            return this;
        }

        public CreateInvoiceRequest chargeDateFrom(int index, Timestamp chargeDateFrom) {
            this.params.addOpt("charges[date_from][" + index + "]", chargeDateFrom);
            return this;
        }

        public CreateInvoiceRequest chargeDateTo(int index, Timestamp chargeDateTo) {
            this.params.addOpt("charges[date_to][" + index + "]", chargeDateTo);
            return this;
        }

        public CreateInvoiceRequest chargeTaxable(int index, Boolean chargeTaxable) {
            this.params.addOpt("charges[taxable][" + index + "]", chargeTaxable);
            return this;
        }

        public CreateInvoiceRequest chargeTaxProfileId(int index, String chargeTaxProfileId) {
            this.params.addOpt("charges[tax_profile_id][" + index + "]", chargeTaxProfileId);
            return this;
        }

        public CreateInvoiceRequest chargeAvalaraTaxCode(int index, String chargeAvalaraTaxCode) {
            this.params.addOpt("charges[avalara_tax_code][" + index + "]", chargeAvalaraTaxCode);
            return this;
        }

        public CreateInvoiceRequest chargeTaxjarProductCode(int index, String chargeTaxjarProductCode) {
            this.params.addOpt("charges[taxjar_product_code][" + index + "]", chargeTaxjarProductCode);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GiftSubscriptionRequest
    extends Request<GiftSubscriptionRequest> {
        private GiftSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public GiftSubscriptionRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public GiftSubscriptionRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public GiftSubscriptionRequest giftScheduledAt(Timestamp giftScheduledAt) {
            this.params.addOpt("gift[scheduled_at]", giftScheduledAt);
            return this;
        }

        public GiftSubscriptionRequest giftAutoClaim(Boolean giftAutoClaim) {
            this.params.addOpt("gift[auto_claim]", giftAutoClaim);
            return this;
        }

        public GiftSubscriptionRequest giftNoExpiry(Boolean giftNoExpiry) {
            this.params.addOpt("gift[no_expiry]", giftNoExpiry);
            return this;
        }

        public GiftSubscriptionRequest giftClaimExpiryDate(Timestamp giftClaimExpiryDate) {
            this.params.addOpt("gift[claim_expiry_date]", giftClaimExpiryDate);
            return this;
        }

        public GiftSubscriptionRequest gifterCustomerId(String gifterCustomerId) {
            this.params.add("gifter[customer_id]", gifterCustomerId);
            return this;
        }

        public GiftSubscriptionRequest gifterSignature(String gifterSignature) {
            this.params.add("gifter[signature]", gifterSignature);
            return this;
        }

        public GiftSubscriptionRequest gifterNote(String gifterNote) {
            this.params.addOpt("gifter[note]", gifterNote);
            return this;
        }

        public GiftSubscriptionRequest gifterPaymentSrcId(String gifterPaymentSrcId) {
            this.params.addOpt("gifter[payment_src_id]", gifterPaymentSrcId);
            return this;
        }

        public GiftSubscriptionRequest giftReceiverCustomerId(String giftReceiverCustomerId) {
            this.params.add("gift_receiver[customer_id]", giftReceiverCustomerId);
            return this;
        }

        public GiftSubscriptionRequest giftReceiverFirstName(String giftReceiverFirstName) {
            this.params.add("gift_receiver[first_name]", giftReceiverFirstName);
            return this;
        }

        public GiftSubscriptionRequest giftReceiverLastName(String giftReceiverLastName) {
            this.params.add("gift_receiver[last_name]", giftReceiverLastName);
            return this;
        }

        public GiftSubscriptionRequest giftReceiverEmail(String giftReceiverEmail) {
            this.params.add("gift_receiver[email]", giftReceiverEmail);
            return this;
        }

        public GiftSubscriptionRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public GiftSubscriptionRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public GiftSubscriptionRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public GiftSubscriptionRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public GiftSubscriptionRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResumeSubscriptionRequest
    extends Request<ResumeSubscriptionRequest> {
        private ResumeSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ResumeSubscriptionRequest resumeOption(ResumeOption resumeOption) {
            this.params.addOpt("resume_option", (Object)resumeOption);
            return this;
        }

        public ResumeSubscriptionRequest chargesHandling(ChargesHandling chargesHandling) {
            this.params.addOpt("charges_handling", (Object)chargesHandling);
            return this;
        }

        public ResumeSubscriptionRequest subscriptionResumeDate(Timestamp subscriptionResumeDate) {
            this.params.addOpt("subscription[resume_date]", subscriptionResumeDate);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PauseSubscriptionRequest
    extends Request<PauseSubscriptionRequest> {
        private PauseSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public PauseSubscriptionRequest pauseOption(PauseOption pauseOption) {
            this.params.addOpt("pause_option", (Object)pauseOption);
            return this;
        }

        public PauseSubscriptionRequest unbilledChargesHandling(UnbilledChargesHandling unbilledChargesHandling) {
            this.params.addOpt("unbilled_charges_handling", (Object)unbilledChargesHandling);
            return this;
        }

        public PauseSubscriptionRequest subscriptionPauseDate(Timestamp subscriptionPauseDate) {
            this.params.addOpt("subscription[pause_date]", subscriptionPauseDate);
            return this;
        }

        public PauseSubscriptionRequest subscriptionResumeDate(Timestamp subscriptionResumeDate) {
            this.params.addOpt("subscription[resume_date]", subscriptionResumeDate);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelSubscriptionRequest
    extends Request<CancelSubscriptionRequest> {
        private CancelSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CancelSubscriptionRequest endOfTerm(Boolean endOfTerm) {
            this.params.addOpt("end_of_term", endOfTerm);
            return this;
        }

        public CancelSubscriptionRequest creditOptionForCurrentTermCharges(CreditOptionForCurrentTermCharges creditOptionForCurrentTermCharges) {
            this.params.addOpt("credit_option_for_current_term_charges", (Object)creditOptionForCurrentTermCharges);
            return this;
        }

        public CancelSubscriptionRequest unbilledChargesOption(UnbilledChargesOption unbilledChargesOption) {
            this.params.addOpt("unbilled_charges_option", (Object)unbilledChargesOption);
            return this;
        }

        public CancelSubscriptionRequest accountReceivablesHandling(AccountReceivablesHandling accountReceivablesHandling) {
            this.params.addOpt("account_receivables_handling", (Object)accountReceivablesHandling);
            return this;
        }

        public CancelSubscriptionRequest refundableCreditsHandling(RefundableCreditsHandling refundableCreditsHandling) {
            this.params.addOpt("refundable_credits_handling", (Object)refundableCreditsHandling);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTermEndRequest
    extends Request<ChangeTermEndRequest> {
        private ChangeTermEndRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChangeTermEndRequest termEndsAt(Timestamp termEndsAt) {
            this.params.addOpt("term_ends_at", termEndsAt);
            return this;
        }

        public ChangeTermEndRequest prorate(Boolean prorate) {
            this.params.addOpt("prorate", prorate);
            return this;
        }

        public ChangeTermEndRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenewalEstimateRequest
    extends Request<RenewalEstimateRequest> {
        private RenewalEstimateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RenewalEstimateRequest includeDelayedCharges(Boolean includeDelayedCharges) {
            this.params.addOpt("include_delayed_charges", includeDelayedCharges);
            return this;
        }

        public RenewalEstimateRequest useExistingBalances(Boolean useExistingBalances) {
            this.params.addOpt("use_existing_balances", useExistingBalances);
            return this;
        }

        public RenewalEstimateRequest ignoreScheduledCancellation(Boolean ignoreScheduledCancellation) {
            this.params.addOpt("ignore_scheduled_cancellation", ignoreScheduledCancellation);
            return this;
        }

        public RenewalEstimateRequest ignoreScheduledChanges(Boolean ignoreScheduledChanges) {
            this.params.addOpt("ignore_scheduled_changes", ignoreScheduledChanges);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateSubscriptionRequest
    extends Request<UpdateSubscriptionRequest> {
        private UpdateSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateSubscriptionRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public UpdateSubscriptionRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public UpdateSubscriptionRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public UpdateSubscriptionRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public UpdateSubscriptionRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public UpdateSubscriptionRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public UpdateSubscriptionRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public UpdateSubscriptionRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public UpdateSubscriptionRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public UpdateSubscriptionRequest replaceCouponList(Boolean replaceCouponList) {
            this.params.addOpt("replace_coupon_list", replaceCouponList);
            return this;
        }

        public UpdateSubscriptionRequest prorate(Boolean prorate) {
            this.params.addOpt("prorate", prorate);
            return this;
        }

        public UpdateSubscriptionRequest endOfTerm(Boolean endOfTerm) {
            this.params.addOpt("end_of_term", endOfTerm);
            return this;
        }

        public UpdateSubscriptionRequest forceTermReset(Boolean forceTermReset) {
            this.params.addOpt("force_term_reset", forceTermReset);
            return this;
        }

        public UpdateSubscriptionRequest reactivate(Boolean reactivate) {
            this.params.addOpt("reactivate", reactivate);
            return this;
        }

        public UpdateSubscriptionRequest includeDelayedCharges(Boolean includeDelayedCharges) {
            this.params.addOpt("include_delayed_charges", includeDelayedCharges);
            return this;
        }

        public UpdateSubscriptionRequest useExistingBalances(Boolean useExistingBalances) {
            this.params.addOpt("use_existing_balances", useExistingBalances);
            return this;
        }

        public UpdateSubscriptionRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.addOpt("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        @Deprecated
        public UpdateSubscriptionRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public UpdateSubscriptionRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public UpdateSubscriptionRequest customerRegisteredForGst(Boolean customerRegisteredForGst) {
            this.params.addOpt("customer[registered_for_gst]", customerRegisteredForGst);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionFreePeriod(Integer subscriptionFreePeriod) {
            this.params.addOpt("subscription[free_period]", subscriptionFreePeriod);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionFreePeriodUnit(FreePeriodUnit subscriptionFreePeriodUnit) {
            this.params.addOpt("subscription[free_period_unit]", (Object)subscriptionFreePeriodUnit);
            return this;
        }

        @Deprecated
        public UpdateSubscriptionRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public UpdateSubscriptionRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public UpdateSubscriptionRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public UpdateSubscriptionRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public UpdateSubscriptionRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public UpdateSubscriptionRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public UpdateSubscriptionRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public UpdateSubscriptionRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public UpdateSubscriptionRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public UpdateSubscriptionRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public UpdateSubscriptionRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public UpdateSubscriptionRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public UpdateSubscriptionRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateSubForCustomerEstimateRequest
    extends Request<CreateSubForCustomerEstimateRequest> {
        private CreateSubForCustomerEstimateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateSubForCustomerEstimateRequest useExistingBalances(Boolean useExistingBalances) {
            this.params.addOpt("use_existing_balances", useExistingBalances);
            return this;
        }

        public CreateSubForCustomerEstimateRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public CreateSubForCustomerEstimateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateSubForCustomerEstimateRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateSubForCustomerEstimateRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateSubForCustomerEstimateRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CreateSubForCustomerEstimateRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CreateSubForCustomerEstimateRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubForCustomerEstimateRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionFreePeriod(Integer subscriptionFreePeriod) {
            this.params.addOpt("subscription[free_period]", subscriptionFreePeriod);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionFreePeriodUnit(FreePeriodUnit subscriptionFreePeriodUnit) {
            this.params.addOpt("subscription[free_period_unit]", (Object)subscriptionFreePeriodUnit);
            return this;
        }

        public CreateSubForCustomerEstimateRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CreateSubForCustomerEstimateRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public CreateSubForCustomerEstimateRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public CreateSubForCustomerEstimateRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public CreateSubForCustomerEstimateRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public CreateSubForCustomerEstimateRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public CreateSubForCustomerEstimateRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public CreateSubForCustomerEstimateRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public CreateSubForCustomerEstimateRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateSubscriptionRequest
    extends Request<CreateSubscriptionRequest> {
        private CreateSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateSubscriptionRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateSubscriptionRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateSubscriptionRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CreateSubscriptionRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CreateSubscriptionRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CreateSubscriptionRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubscriptionRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubscriptionRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public CreateSubscriptionRequest clientProfileId(String clientProfileId) {
            this.params.addOpt("client_profile_id", clientProfileId);
            return this;
        }

        public CreateSubscriptionRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CreateSubscriptionRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CreateSubscriptionRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CreateSubscriptionRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CreateSubscriptionRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CreateSubscriptionRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public CreateSubscriptionRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        @Deprecated
        public CreateSubscriptionRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CreateSubscriptionRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public CreateSubscriptionRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CreateSubscriptionRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CreateSubscriptionRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CreateSubscriptionRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CreateSubscriptionRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CreateSubscriptionRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CreateSubscriptionRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CreateSubscriptionRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateSubscriptionRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CreateSubscriptionRequest customerRegisteredForGst(Boolean customerRegisteredForGst) {
            this.params.addOpt("customer[registered_for_gst]", customerRegisteredForGst);
            return this;
        }

        public CreateSubscriptionRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CreateSubscriptionRequest customerEntityCode(EntityCode customerEntityCode) {
            this.params.addOpt("customer[entity_code]", (Object)customerEntityCode);
            return this;
        }

        public CreateSubscriptionRequest customerExemptNumber(String customerExemptNumber) {
            this.params.addOpt("customer[exempt_number]", customerExemptNumber);
            return this;
        }

        public CreateSubscriptionRequest subscriptionFreePeriod(Integer subscriptionFreePeriod) {
            this.params.addOpt("subscription[free_period]", subscriptionFreePeriod);
            return this;
        }

        public CreateSubscriptionRequest subscriptionFreePeriodUnit(FreePeriodUnit subscriptionFreePeriodUnit) {
            this.params.addOpt("subscription[free_period_unit]", (Object)subscriptionFreePeriodUnit);
            return this;
        }

        public CreateSubscriptionRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CreateSubscriptionRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CreateSubscriptionRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public CreateSubscriptionRequest customerExemptionDetails(JSONArray customerExemptionDetails) {
            this.params.addOpt("customer[exemption_details]", customerExemptionDetails);
            return this;
        }

        public CreateSubscriptionRequest customerCustomerType(CustomerType customerCustomerType) {
            this.params.addOpt("customer[customer_type]", (Object)customerCustomerType);
            return this;
        }

        public CreateSubscriptionRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateSubscriptionRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateSubscriptionRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateSubscriptionRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public CreateSubscriptionRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public CreateSubscriptionRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public CreateSubscriptionRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public CreateSubscriptionRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public CreateSubscriptionRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public CreateSubscriptionRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public CreateSubscriptionRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public CreateSubscriptionRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }
}

