/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;

public class ArrayFactory<T>
implements JsonReader.ClassFactory {
    private final Class<T> type;

    public ArrayFactory(Class<T> c) {
        this.type = c;
    }

    public T newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        Object[] items = jObj.getItems();
        Converter converter = resolver.getConverter();
        if (items == null) {
            return (T)jObj.setTarget(null);
        }
        int len = Array.getLength(items);
        Class<?> arrayType = this.getType();
        Class<?> componentType = arrayType.getComponentType();
        Object array = Array.newInstance(componentType, len);
        for (int i = 0; i < len; ++i) {
            Object val = Array.get(items, i);
            if (val != null) {
                if (val instanceof JsonObject) {
                    Class<?> type;
                    JsonObject jsonObject;
                    do {
                        jsonObject = (JsonObject)val;
                        type = jsonObject.getType();
                    } while (jsonObject.hasValue() && (val = jsonObject.getValue()) instanceof JsonObject);
                    if (type == null) {
                        type = componentType;
                    }
                    val = resolver.getConverter().convert(val, TypeUtilities.getRawClass(type));
                } else {
                    val = resolver.getConverter().convert(val, componentType);
                }
            }
            try {
                Array.set(array, i, val);
                continue;
            }
            catch (Exception e) {
                Array.set(array, i, converter.convert(val, componentType));
            }
        }
        return (T)jObj.setTarget(array);
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

