/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecurityAuditLogger {
    private static final Logger LOGGER = Logger.getLogger(SecurityAuditLogger.class.getName());
    private static final SecurityAuditLogger INSTANCE = new SecurityAuditLogger();
    private final AtomicLong totalOperations = new AtomicLong(0L);
    private final AtomicLong securityViolations = new AtomicLong(0L);
    private final AtomicLong performanceAnomalies = new AtomicLong(0L);
    private final AtomicLong classLoadingFailures = new AtomicLong(0L);
    private final AtomicLong memoryLimitViolations = new AtomicLong(0L);
    private final AtomicLong stackDepthViolations = new AtomicLong(0L);
    private final ConcurrentHashMap<String, AtomicLong> suspiciousPatterns = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicLong> blockedClasses = new ConcurrentHashMap();
    private volatile boolean auditEnabled = Boolean.parseBoolean(System.getProperty("json-io.security.audit.enabled", "false"));
    private volatile long performanceThresholdMs = Long.parseLong(System.getProperty("json-io.security.performance.threshold", "1000"));

    private SecurityAuditLogger() {
    }

    public static SecurityAuditLogger getInstance() {
        return INSTANCE;
    }

    public void setAuditEnabled(boolean enabled) {
        this.auditEnabled = enabled;
        if (enabled) {
            this.logSecurityEvent(SecurityEvent.AUDIT_ENABLED, "Security audit logging enabled", null);
        }
    }

    public void setPerformanceThreshold(long thresholdMs) {
        this.performanceThresholdMs = thresholdMs;
        this.logSecurityEvent(SecurityEvent.CONFIG_CHANGE, "Performance threshold set to " + thresholdMs + "ms", null);
    }

    public void logOperation(String operation, long durationMs, int inputSize, boolean success, String error) {
        if (!this.auditEnabled) {
            return;
        }
        this.totalOperations.incrementAndGet();
        if (!success) {
            this.securityViolations.incrementAndGet();
            this.logSecurityEvent(SecurityEvent.OPERATION_FAILED, String.format("Operation: %s, Duration: %dms, Size: %d, Error: %s", operation, durationMs, inputSize, error), error);
        }
        if (durationMs > this.performanceThresholdMs) {
            this.performanceAnomalies.incrementAndGet();
            this.logSecurityEvent(SecurityEvent.PERFORMANCE_ANOMALY, String.format("Slow operation: %s, Duration: %dms, Size: %d", operation, durationMs, inputSize), null);
        }
        if (success && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("JSON operation successful: %s, Duration: %dms, Size: %d", operation, durationMs, inputSize));
        }
    }

    public void logSecurityLimitViolation(String limitType, long attemptedValue, long maxValue, String context) {
        if (!this.auditEnabled) {
            return;
        }
        if ("memory".equals(limitType) || "collection".equals(limitType)) {
            this.memoryLimitViolations.incrementAndGet();
        } else if ("depth".equals(limitType) || "stack".equals(limitType)) {
            this.stackDepthViolations.incrementAndGet();
        }
        this.securityViolations.incrementAndGet();
        this.logSecurityEvent(SecurityEvent.SECURITY_LIMIT_VIOLATED, String.format("Security limit exceeded - Type: %s, Attempted: %d, Max: %d, Context: %s", limitType, attemptedValue, maxValue, context), null);
    }

    public void logSuspiciousPattern(String pattern, String context, String input) {
        if (!this.auditEnabled) {
            return;
        }
        this.suspiciousPatterns.computeIfAbsent(pattern, k -> new AtomicLong(0L)).incrementAndGet();
        String truncatedInput = input != null && input.length() > 200 ? input.substring(0, 200) + "..." : input;
        this.logSecurityEvent(SecurityEvent.SUSPICIOUS_PATTERN, String.format("Suspicious pattern detected - Pattern: %s, Context: %s, Input: %s", pattern, context, truncatedInput), null);
    }

    public void logClassLoadingSecurity(String className, boolean allowed, String reason) {
        if (!this.auditEnabled) {
            return;
        }
        if (!allowed) {
            this.classLoadingFailures.incrementAndGet();
            this.blockedClasses.computeIfAbsent(className, k -> new AtomicLong(0L)).incrementAndGet();
            this.logSecurityEvent(SecurityEvent.CLASS_LOADING_BLOCKED, String.format("Class loading blocked - Class: %s, Reason: %s", className, reason), null);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Class loading allowed: %s", className));
        }
    }

    public void logReflectionSecurity(String operation, String target, boolean allowed, String reason) {
        if (!this.auditEnabled) {
            return;
        }
        if (!allowed) {
            this.securityViolations.incrementAndGet();
            this.logSecurityEvent(SecurityEvent.REFLECTION_BLOCKED, String.format("Reflection blocked - Operation: %s, Target: %s, Reason: %s", operation, target, reason), null);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Reflection allowed - Operation: %s, Target: %s", operation, target));
        }
    }

    public SecurityAuditSummary getAuditSummary() {
        return new SecurityAuditSummary(this.totalOperations.get(), this.securityViolations.get(), this.performanceAnomalies.get(), this.classLoadingFailures.get(), this.memoryLimitViolations.get(), this.stackDepthViolations.get(), new ConcurrentHashMap<String, AtomicLong>(this.suspiciousPatterns), new ConcurrentHashMap<String, AtomicLong>(this.blockedClasses));
    }

    public void resetCounters() {
        this.totalOperations.set(0L);
        this.securityViolations.set(0L);
        this.performanceAnomalies.set(0L);
        this.classLoadingFailures.set(0L);
        this.memoryLimitViolations.set(0L);
        this.stackDepthViolations.set(0L);
        this.suspiciousPatterns.clear();
        this.blockedClasses.clear();
        if (this.auditEnabled) {
            this.logSecurityEvent(SecurityEvent.COUNTERS_RESET, "Security audit counters reset", null);
        }
    }

    private void logSecurityEvent(SecurityEvent event, String message, String error) {
        if (!this.auditEnabled) {
            return;
        }
        String logMessage = String.format("[SECURITY] %s: %s", event.name(), message);
        if (error != null) {
            LOGGER.warning(logMessage + " | Error: " + error);
        } else {
            LOGGER.info(logMessage);
        }
        if (event.isCritical()) {
            LOGGER.severe("CRITICAL SECURITY EVENT: " + logMessage);
        }
    }

    public static enum SecurityEvent {
        AUDIT_ENABLED(false),
        CONFIG_CHANGE(false),
        OPERATION_FAILED(true),
        PERFORMANCE_ANOMALY(false),
        SECURITY_LIMIT_VIOLATED(true),
        SUSPICIOUS_PATTERN(true),
        CLASS_LOADING_BLOCKED(true),
        REFLECTION_BLOCKED(true),
        COUNTERS_RESET(false);

        private final boolean critical;

        private SecurityEvent(boolean critical) {
            this.critical = critical;
        }

        public boolean isCritical() {
            return this.critical;
        }
    }

    public static class SecurityAuditSummary {
        public final long totalOperations;
        public final long securityViolations;
        public final long performanceAnomalies;
        public final long classLoadingFailures;
        public final long memoryLimitViolations;
        public final long stackDepthViolations;
        public final ConcurrentHashMap<String, AtomicLong> suspiciousPatterns;
        public final ConcurrentHashMap<String, AtomicLong> blockedClasses;

        SecurityAuditSummary(long totalOperations, long securityViolations, long performanceAnomalies, long classLoadingFailures, long memoryLimitViolations, long stackDepthViolations, ConcurrentHashMap<String, AtomicLong> suspiciousPatterns, ConcurrentHashMap<String, AtomicLong> blockedClasses) {
            this.totalOperations = totalOperations;
            this.securityViolations = securityViolations;
            this.performanceAnomalies = performanceAnomalies;
            this.classLoadingFailures = classLoadingFailures;
            this.memoryLimitViolations = memoryLimitViolations;
            this.stackDepthViolations = stackDepthViolations;
            this.suspiciousPatterns = suspiciousPatterns;
            this.blockedClasses = blockedClasses;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SecurityAuditSummary{\n");
            sb.append("  totalOperations=").append(this.totalOperations).append("\n");
            sb.append("  securityViolations=").append(this.securityViolations).append("\n");
            sb.append("  performanceAnomalies=").append(this.performanceAnomalies).append("\n");
            sb.append("  classLoadingFailures=").append(this.classLoadingFailures).append("\n");
            sb.append("  memoryLimitViolations=").append(this.memoryLimitViolations).append("\n");
            sb.append("  stackDepthViolations=").append(this.stackDepthViolations).append("\n");
            sb.append("  suspiciousPatterns=").append(this.suspiciousPatterns.size()).append(" types\n");
            sb.append("  blockedClasses=").append(this.blockedClasses.size()).append(" types\n");
            sb.append("}");
            return sb.toString();
        }
    }
}

