/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.reflect;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.Type;
import java.util.Arrays;

public class Injector {
    private static final boolean IS_JDK17_OR_HIGHER;
    private static final Object LOOKUP;
    private static final Method PRIVATE_LOOKUP_IN_METHOD;
    private static final Method FIND_VAR_HANDLE_METHOD;
    private static final MethodHandle VAR_HANDLE_SET_METHOD;
    private static final Class<?> VAR_HANDLE_CLASS;
    private final Field field;
    private final String displayName;
    private final String uniqueFieldName;
    private MethodHandle injector;
    private Object varHandle;
    private final boolean useFieldSet;

    public Injector(Field field, MethodHandle handle, String uniqueFieldName, String displayName) {
        this.field = field;
        this.displayName = displayName;
        this.uniqueFieldName = uniqueFieldName;
        this.injector = handle;
        this.useFieldSet = false;
    }

    private Injector(Field field, String uniqueFieldName, String displayName, boolean useFieldSet) {
        this.field = field;
        this.displayName = displayName;
        this.uniqueFieldName = uniqueFieldName;
        this.useFieldSet = useFieldSet;
    }

    private Injector(Field field, Object varHandle, String uniqueFieldName, String displayName) {
        this.field = field;
        this.displayName = displayName;
        this.uniqueFieldName = uniqueFieldName;
        this.varHandle = varHandle;
        this.useFieldSet = false;
    }

    public static Injector create(Field field, String uniqueFieldName) {
        boolean isFinal;
        if (field == null) {
            throw new JsonIoException("Field cannot be null");
        }
        if (uniqueFieldName == null || uniqueFieldName.trim().isEmpty()) {
            throw new JsonIoException("Unique field name cannot be null or empty");
        }
        String fieldName = field.getName();
        Class<?> declaringClass = field.getDeclaringClass();
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            throw new JsonIoException("Security policy denies field access to: " + fieldName + " in class: " + declaringClass.getName(), e);
        }
        if (!field.isAccessible()) {
            try {
                field.setAccessible(true);
            }
            catch (Exception ioe) {
                Injector varHandleInjector;
                if (IS_JDK17_OR_HIGHER && (varHandleInjector = Injector.createWithVarHandle(field, uniqueFieldName)) != null) {
                    return varHandleInjector;
                }
                return new Injector(field, uniqueFieldName, field.getName(), true);
            }
        }
        if ((isFinal = Modifier.isFinal(field.getModifiers())) && !IS_JDK17_OR_HIGHER) {
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
                }
            }
            catch (SecurityException e) {
                throw new JsonIoException("Security policy denies final field modification for: " + fieldName + " in class: " + declaringClass.getName(), e);
            }
            try {
                Field modifiersField = ReflectionUtils.getField(Field.class, (String)"modifiers");
                if (modifiersField == null) {
                    throw new JsonIoException("Unable to access modifiers field - possible security restriction");
                }
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (Exception ex) {
                throw new JsonIoException("Failed to remove final modifier from field: " + fieldName + " in class: " + declaringClass.getName() + ". This may be due to security restrictions.", ex);
            }
            return new Injector(field, uniqueFieldName, field.getName(), true);
        }
        try {
            MethodHandle handle = MethodHandles.lookup().unreflectSetter(field);
            return new Injector(field, handle, uniqueFieldName, field.getName());
        }
        catch (IllegalAccessException e) {
            Injector varHandleInjector;
            if (IS_JDK17_OR_HIGHER && (varHandleInjector = Injector.createWithVarHandle(field, uniqueFieldName)) != null) {
                return varHandleInjector;
            }
            return new Injector(field, uniqueFieldName, field.getName(), true);
        }
    }

    private static Injector createWithVarHandle(Field field, String uniqueFieldName) {
        if (PRIVATE_LOOKUP_IN_METHOD == null || FIND_VAR_HANDLE_METHOD == null || VAR_HANDLE_SET_METHOD == null || LOOKUP == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            catch (SecurityException e) {
                return null;
            }
        }
        try {
            Class<?> declaringClass = field.getDeclaringClass();
            if (declaringClass == null) {
                return null;
            }
            Object privateLookup = PRIVATE_LOOKUP_IN_METHOD.invoke(null, declaringClass, LOOKUP);
            if (privateLookup == null) {
                return null;
            }
            Object varHandle = FIND_VAR_HANDLE_METHOD.invoke(privateLookup, declaringClass, field.getName(), field.getType());
            if (varHandle == null) {
                return null;
            }
            return new Injector(field, varHandle, uniqueFieldName, field.getName());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Injector create(Field field, String methodName, String uniqueFieldName) {
        if (field == null) {
            throw new JsonIoException("Field cannot be null");
        }
        if (methodName == null || methodName.trim().isEmpty()) {
            throw new JsonIoException("Method name cannot be null or empty");
        }
        if (uniqueFieldName == null || uniqueFieldName.trim().isEmpty()) {
            throw new JsonIoException("Unique field name cannot be null or empty");
        }
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            throw new JsonIoException("Security policy denies method access for: " + methodName + " in class: " + field.getDeclaringClass().getName(), e);
        }
        try {
            MethodType methodType = MethodType.methodType(Void.TYPE, field.getType());
            MethodHandle handle = MethodHandles.lookup().findVirtual(field.getDeclaringClass(), methodName, methodType);
            return new Injector(field, handle, uniqueFieldName, methodName);
        }
        catch (NoSuchMethodException e) {
            throw new JsonIoException("Method not found: " + methodName + " in class: " + field.getDeclaringClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new JsonIoException("Access denied to method: " + methodName + " in class: " + field.getDeclaringClass().getName(), e);
        }
    }

    public void inject(Object object, Object value) {
        SecurityManager sm;
        if (object == null) {
            throw new JsonIoException("Attempting to set field: " + this.getName() + " on null object.");
        }
        Class<?> declaringClass = this.field.getDeclaringClass();
        if (!declaringClass.isInstance(object)) {
            throw new JsonIoException("Object is not an instance of the field's declaring class. Expected: " + declaringClass.getName() + ", Actual: " + object.getClass().getName() + " for field: " + this.getName());
        }
        String className = declaringClass.getName();
        if ((className.startsWith("java.lang.") || className.startsWith("java.security.")) && (sm = System.getSecurityManager()) != null) {
            try {
                sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            catch (SecurityException e) {
                throw new JsonIoException("Security policy denies injection into system class: " + className + " field: " + this.getName(), e);
            }
        }
        try {
            if (this.varHandle != null) {
                this.injectWithVarHandle(object, value);
            } else if (this.useFieldSet) {
                this.field.set(object, value);
            } else {
                this.injector.invoke(object, value);
            }
        }
        catch (ClassCastException e) {
            Class<?> fieldType = this.field.getType();
            String fieldName = this.getName();
            String displayName = this.getDisplayName();
            String msg = e.getMessage();
            if (StringUtilities.hasContent((String)msg) && msg.contains("LinkedHashMap")) {
                throw new JsonIoException("Unable to set field: " + fieldName + " using " + displayName + ".", e);
            }
            try {
                Object convertedValue = Converter.convert((Object)value, fieldType);
                if (this.varHandle != null) {
                    this.injectWithVarHandle(object, convertedValue);
                } else if (this.useFieldSet) {
                    this.field.set(object, convertedValue);
                } else {
                    this.injector.invoke(object, convertedValue);
                }
            }
            catch (Throwable t) {
                throw new JsonIoException("Unable to set field: " + fieldName + " using " + displayName + ". Getting a ClassCastException.", e);
            }
        }
        catch (Throwable t) {
            if (t instanceof JsonIoException) {
                throw (JsonIoException)t;
            }
            throw new JsonIoException("Unable to set field: " + this.getName() + " using " + this.getDisplayName(), t);
        }
    }

    private void injectWithVarHandle(Object object, Object value) throws Throwable {
        if (this.varHandle == null || VAR_HANDLE_SET_METHOD == null) {
            throw new JsonIoException("Unable to set field: " + this.getName() + " - VarHandle not available");
        }
        if (object == null) {
            throw new JsonIoException("Cannot inject into null object using VarHandle for field: " + this.getName());
        }
        try {
            Object[] args = new Object[]{this.varHandle, object, value};
            VAR_HANDLE_SET_METHOD.invokeWithArguments(Arrays.asList(args));
        }
        catch (Exception e) {
            throw new JsonIoException("VarHandle injection failed for field: " + this.getName() + " in class: " + this.field.getDeclaringClass().getName(), e);
        }
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public String getName() {
        return this.field.getName();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUniqueFieldName() {
        return this.uniqueFieldName;
    }

    private static int determineJdkMajorVersion() {
        try {
            Method versionMethod = ReflectionUtils.getMethod(Runtime.class, (String)"version", (Class[])new Class[0]);
            Object v = versionMethod.invoke((Object)Runtime.getRuntime(), new Object[0]);
            Method major = ReflectionUtils.getMethod(v.getClass(), (String)"major", (Class[])new Class[0]);
            return (Integer)major.invoke(v, new Object[0]);
        }
        catch (Exception ignore) {
            try {
                String version = System.getProperty("java.version");
                if (version.startsWith("1.")) {
                    return Integer.parseInt(version.substring(2, 3));
                }
                int dot = version.indexOf(46);
                if (dot != -1) {
                    return Integer.parseInt(version.substring(0, dot));
                }
                return Integer.parseInt(version);
            }
            catch (Exception ignored) {
                try {
                    String spec = System.getProperty("java.specification.version");
                    return spec.startsWith("1.") ? Integer.parseInt(spec.substring(2)) : Integer.parseInt(spec);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        }
    }

    static {
        int javaVersion = Injector.determineJdkMajorVersion();
        IS_JDK17_OR_HIGHER = javaVersion >= 17;
        Object lookup = null;
        Method privateLookupInMethod = null;
        Method findVarHandleMethod = null;
        MethodHandle varHandleSetMethod = null;
        Class<?> varHandleClass = null;
        if (javaVersion >= 9) {
            try {
                Class<?> methodHandlesClass = Class.forName("java.lang.invoke.MethodHandles");
                Class<?> lookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup");
                Method lookupMethod = ReflectionUtils.getMethod(methodHandlesClass, (String)"lookup", (Class[])new Class[0]);
                lookup = lookupMethod.invoke(null, new Object[0]);
                privateLookupInMethod = ReflectionUtils.getMethod(methodHandlesClass, (String)"privateLookupIn", (Class[])new Class[]{Class.class, lookupClass});
                varHandleClass = Class.forName("java.lang.invoke.VarHandle");
                findVarHandleMethod = ReflectionUtils.getMethod(lookupClass, (String)"findVarHandle", (Class[])new Class[]{Class.class, String.class, Class.class});
                MethodType setType = MethodType.methodType(Void.TYPE, Object.class, Object.class);
                varHandleSetMethod = MethodHandles.publicLookup().findVirtual(varHandleClass, "set", setType);
            }
            catch (Exception e) {
                lookup = null;
                privateLookupInMethod = null;
                findVarHandleMethod = null;
                varHandleSetMethod = null;
                varHandleClass = null;
            }
        }
        LOOKUP = lookup;
        PRIVATE_LOOKUP_IN_METHOD = privateLookupInMethod;
        FIND_VAR_HANDLE_METHOD = findVarHandleMethod;
        VAR_HANDLE_SET_METHOD = varHandleSetMethod;
        VAR_HANDLE_CLASS = varHandleClass;
    }
}

