/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.MathUtilities;
import com.cedarsoftware.util.TypeUtilities;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class JsonParser {
    private static final JsonObject EMPTY_ARRAY;
    private final FastReader input;
    private final StringBuilder strBuf = new StringBuilder(256);
    private final StringBuilder numBuf = new StringBuilder();
    private int curParseDepth = 0;
    private final boolean allowNanAndInfinity;
    private final int maxParseDepth;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final ReferenceTracker references;
    private final Map<String, String> stringCache;
    private final Map<Number, Number> numberCache;
    private final Map<String, String> substitutes = SUBSTITUTES;
    private static final ThreadLocal<char[]> STRING_BUFFER;
    private static final Map<String, String> STATIC_STRING_CACHE;
    private static final Map<Number, Number> STATIC_NUMBER_CACHE;
    private static final Map<String, String> SUBSTITUTES;
    private static final char[] ESCAPE_CHAR_MAP;
    private static final int[] HEX_VALUE_MAP;

    JsonParser(FastReader reader, Resolver resolver) {
        this.stringCache = new ParserStringCache(STATIC_STRING_CACHE);
        this.numberCache = new ParserNumberCache(STATIC_NUMBER_CACHE);
        this.input = reader;
        this.resolver = resolver;
        this.readOptions = resolver.getReadOptions();
        this.references = resolver.getReferences();
        this.maxParseDepth = this.readOptions.getMaxDepth();
        this.allowNanAndInfinity = this.readOptions.isAllowNanAndInfinity();
    }

    Object readValue(Type suggestedType) throws IOException {
        int c;
        if (this.curParseDepth > this.maxParseDepth) {
            this.error("Maximum parsing depth exceeded");
        }
        if ((c = this.skipWhitespaceRead(true)) >= 48 && c <= 57 || c == 45 || c == 78 || c == 73) {
            return this.readNumber(c);
        }
        switch (c) {
            case 34: {
                String str = this.readString();
                return str;
            }
            case 123: {
                this.input.pushback('{');
                JsonObject jObj = this.readJsonObject(suggestedType);
                return jObj;
            }
            case 91: {
                Type elementType = TypeUtilities.extractArrayComponentType((Type)suggestedType);
                return this.readArray(elementType);
            }
            case 93: {
                this.input.pushback(']');
                return EMPTY_ARRAY;
            }
            case 70: 
            case 102: {
                this.readToken("false");
                return false;
            }
            case 78: 
            case 110: {
                this.readToken("null");
                return null;
            }
            case 84: 
            case 116: {
                this.readToken("true");
                return true;
            }
        }
        return this.error("Unknown JSON value type");
    }

    private JsonObject readJsonObject(Type suggestedType) throws IOException {
        JsonObject jObj = new JsonObject();
        Type resolvedSuggestedType = TypeUtilities.resolveType((Type)suggestedType, (Type)suggestedType);
        jObj.setType(resolvedSuggestedType);
        FastReader in = this.input;
        this.skipWhitespaceRead(true);
        jObj.line = in.getLine();
        jObj.col = in.getCol();
        int c = this.skipWhitespaceRead(true);
        if (c == 125) {
            return new JsonObject();
        }
        in.pushback((char)c);
        ++this.curParseDepth;
        Map<String, Injector> injectors = this.readOptions.getDeepInjectorMap(TypeUtilities.getRawClass((Type)suggestedType));
        while (true) {
            Injector injector;
            Type fieldGenericType;
            String field;
            if (this.substitutes.containsKey(field = this.readFieldName())) {
                field = this.substitutes.get(field);
            }
            Type type = fieldGenericType = (injector = injectors.get(field)) == null ? null : injector.getGenericType();
            if (fieldGenericType != null) {
                fieldGenericType = TypeUtilities.resolveType((Type)suggestedType, (Type)fieldGenericType);
            }
            Object value = this.readValue(fieldGenericType);
            switch (field) {
                case "@type": {
                    Class<?> type2 = this.loadType(value);
                    jObj.setTypeString((String)value);
                    jObj.setType(type2);
                    break;
                }
                case "@enum": {
                    this.loadEnum(value, jObj);
                    break;
                }
                case "@ref": {
                    this.loadRef(value, jObj);
                    break;
                }
                case "@id": {
                    this.loadId(value, jObj);
                    break;
                }
                case "@items": {
                    this.loadItems((Object[])value, jObj);
                    break;
                }
                case "@keys": {
                    this.loadKeys(value, jObj);
                    break;
                }
                default: {
                    jObj.put(field, value);
                }
            }
            c = this.skipWhitespaceRead(true);
            if (c == 125) break;
            if (c == 44) continue;
            this.error("Object not ended with '}', instead found '" + (char)c + "'");
        }
        --this.curParseDepth;
        return jObj;
    }

    private Object readArray(Type suggestedType) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        ++this.curParseDepth;
        while (true) {
            int c;
            Object value;
            if ((value = this.readValue(suggestedType)) != EMPTY_ARRAY) {
                list.add(value);
            }
            if ((c = this.skipWhitespaceRead(true)) == 93) break;
            if (c == 44) continue;
            this.error("Expected ',' or ']' inside array");
        }
        --this.curParseDepth;
        return this.resolver.resolveArray(suggestedType, list);
    }

    private String readFieldName() throws IOException {
        int c = this.skipWhitespaceRead(true);
        if (c != 34) {
            this.error("Expected quote before field name");
        }
        String field = this.readString();
        c = this.skipWhitespaceRead(true);
        if (c != 58) {
            this.error("Expected ':' between field and value, instead found '" + (char)c + "'");
        }
        return field;
    }

    private void readToken(String token) throws IOException {
        int len = token.length();
        for (int i = 1; i < len; ++i) {
            int c = this.input.read();
            if (c == -1) {
                this.error("EOF reached while reading token: " + token);
            }
            c = Character.toLowerCase((char)c);
            char loTokenChar = token.charAt(i);
            if (loTokenChar == c) continue;
            this.error("Expected token: " + token);
        }
    }

    private Number readNumber(int c) throws IOException {
        FastReader in = this.input;
        boolean isFloat = false;
        if (this.allowNanAndInfinity && (c == 45 || c == 78 || c == 73)) {
            boolean isNeg;
            boolean bl = isNeg = c == 45;
            if (isNeg) {
                c = this.input.read();
            }
            if (c == 73) {
                this.readToken("infinity");
                return isNeg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (78 == c) {
                this.readToken("nan");
                return Double.NaN;
            }
            this.input.pushback((char)c);
            c = 45;
        }
        StringBuilder number = this.numBuf;
        number.setLength(0);
        number.append((char)c);
        while (true) {
            if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                number.append((char)c);
                continue;
            }
            if (c != 46 && c != 101 && c != 69) break;
            number.append((char)c);
            isFloat = true;
        }
        if (c != -1) {
            in.pushback((char)c);
        }
        try {
            String numStr = number.toString();
            Number val = isFloat ? (Number)this.readFloatingPoint(numStr) : (Number)this.readInteger(numStr);
            Number cachedInstance = this.numberCache.get(val);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            this.numberCache.put(val, val);
            return val;
        }
        catch (Exception e) {
            return (Number)this.error("Invalid number: " + number, e);
        }
    }

    private Number readInteger(String numStr) {
        if (this.readOptions.isIntegerTypeBigInteger()) {
            return new BigInteger(numStr);
        }
        try {
            return Long.parseLong(numStr);
        }
        catch (Exception e) {
            BigInteger bigInt = new BigInteger(numStr);
            if (this.readOptions.isIntegerTypeBoth()) {
                return bigInt;
            }
            return bigInt.longValue();
        }
    }

    private Number readFloatingPoint(String numStr) {
        if (this.readOptions.isFloatingPointBigDecimal()) {
            return new BigDecimal(numStr);
        }
        Number number = MathUtilities.parseToMinimalNumericType((String)numStr);
        if (this.readOptions.isFloatingPointBoth()) {
            return number;
        }
        return number.doubleValue();
    }

    private String readString() throws IOException {
        FastReader in = this.input;
        char[] ESCAPE_CHARS = ESCAPE_CHAR_MAP;
        int[] HEX_VALUES = HEX_VALUE_MAP;
        char[] buffer = STRING_BUFFER.get();
        int pos = 0;
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                this.error("EOF reached while reading JSON string");
            }
            if (c == 34) {
                if (this.curParseDepth == 0 && (c = this.skipWhitespaceRead(false)) != -1) {
                    throw new JsonIoException("EOF expected, content found after string");
                }
                return this.cacheString(new String(buffer, 0, pos));
            }
            if (c == 92) {
                StringBuilder sb = this.strBuf;
                sb.setLength(0);
                sb.append(buffer, 0, pos);
                c = in.read();
                if (c == -1) {
                    this.error("EOF reached while reading escape sequence");
                }
                this.processEscape(sb, c, in, ESCAPE_CHARS, HEX_VALUES);
                return this.readStringWithEscapes(sb, in, ESCAPE_CHARS, HEX_VALUES);
            }
            if (pos >= buffer.length) {
                StringBuilder sb = this.strBuf;
                sb.setLength(0);
                sb.append(buffer, 0, pos);
                sb.append((char)c);
                return this.readStringWithEscapes(sb, in, ESCAPE_CHARS, HEX_VALUES);
            }
            buffer[pos++] = (char)c;
        }
    }

    private String readStringWithEscapes(StringBuilder sb, FastReader in, char[] ESCAPE_CHARS, int[] HEX_VALUES) throws IOException {
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                this.error("EOF reached while reading JSON string");
            }
            if (c != 92 && c != 34) {
                sb.append((char)c);
                continue;
            }
            if (c == 34) {
                if (this.curParseDepth != 0 || (c = this.skipWhitespaceRead(false)) == -1) break;
                throw new JsonIoException("EOF expected, content found after string");
            }
            c = in.read();
            if (c == -1) {
                this.error("EOF reached while reading escape sequence");
            }
            this.processEscape(sb, c, in, ESCAPE_CHARS, HEX_VALUES);
        }
        return this.cacheString(sb.toString());
    }

    private void processEscape(StringBuilder sb, int c, FastReader in, char[] ESCAPE_CHARS, int[] HEX_VALUES) throws IOException {
        char escaped;
        if (c < ESCAPE_CHARS.length && (escaped = ESCAPE_CHARS[c]) != '\u0000') {
            sb.append(escaped);
            return;
        }
        if (c == 117) {
            int value = 0;
            for (int i = 0; i < 4; ++i) {
                int digit;
                c = in.read();
                if (c == -1) {
                    this.error("EOF reached while reading Unicode escape sequence");
                }
                int n = digit = c < 128 ? HEX_VALUES[c] : -1;
                if (digit < 0) {
                    this.error("Expected hexadecimal digit, got: " + (char)c);
                }
                value = value << 4 | digit;
            }
            if (value >= 55296 && value <= 56319) {
                int next = in.read();
                if (next == 92) {
                    next = in.read();
                    if (next == 117) {
                        int lowSurrogate = 0;
                        for (int i = 0; i < 4; ++i) {
                            int digit;
                            c = in.read();
                            if (c == -1) {
                                this.error("EOF reached while reading Unicode escape sequence");
                            }
                            int n = digit = c < 128 ? HEX_VALUES[c] : -1;
                            if (digit < 0) {
                                this.error("Expected hexadecimal digit, got: " + (char)c);
                            }
                            lowSurrogate = lowSurrogate << 4 | digit;
                        }
                        if (lowSurrogate >= 56320 && lowSurrogate <= 57343) {
                            int codePoint = 65536 + (value - 55296 << 10) + (lowSurrogate - 56320);
                            sb.appendCodePoint(codePoint);
                            return;
                        }
                        sb.append((char)value);
                        sb.append((char)lowSurrogate);
                        return;
                    }
                    in.pushback((char)next);
                    in.pushback('\\');
                } else if (next != -1) {
                    in.pushback((char)next);
                }
            }
            sb.append((char)value);
        } else {
            this.error("Invalid character escape sequence specified: " + (char)c);
        }
    }

    private String cacheString(String str) {
        int length = str.length();
        if (length == 0) {
            return "";
        }
        if (length <= 2) {
            return str.intern();
        }
        if (length < 33) {
            String cachedInstance = this.stringCache.get(str);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            this.stringCache.put(str, str);
        }
        return str;
    }

    private int skipWhitespaceRead(boolean throwOnEof) throws IOException {
        int c;
        FastReader in = this.input;
        while ((c = in.read()) == 32 || c == 10 || c == 13 || c == 9) {
        }
        if (c == -1 && throwOnEof) {
            this.error("EOF reached prematurely");
        }
        return c;
    }

    private void loadId(Object value, JsonObject jObj) {
        if (!(value instanceof Number)) {
            this.error("Expected a number for @id, instead got: " + value);
        }
        Long id = ((Number)value).longValue();
        this.references.put(id, jObj);
        jObj.setId(id);
    }

    private void loadRef(Object value, JsonValue jObj) {
        if (!(value instanceof Number)) {
            this.error("Expected a number for @ref, instead got: " + value);
        }
        jObj.setReferenceId(((Number)value).longValue());
    }

    private void loadEnum(Object value, JsonObject jObj) {
        if (!(value instanceof String)) {
            this.error("Expected a String for @enum, instead got: " + value);
        }
        Class<?> enumClass = this.stringToClass((String)value);
        jObj.setTypeString((String)value);
        jObj.setType(enumClass);
        if (jObj.getItems() == null) {
            jObj.setItems(ArrayUtilities.EMPTY_OBJECT_ARRAY);
        }
    }

    private Class<?> loadType(Object value) {
        String javaType;
        String substitute;
        if (!(value instanceof String)) {
            this.error("Expected a String for @type, instead got: " + value);
        }
        if ((substitute = this.readOptions.getTypeNameAlias(javaType = (String)value)) != null) {
            javaType = substitute;
        }
        return this.stringToClass(javaType);
    }

    private void loadItems(Object[] value, JsonObject jObj) {
        if (value == null) {
            return;
        }
        if (!value.getClass().isArray()) {
            this.error("Expected @items to have an array [], but found: " + value.getClass().getName());
        }
        jObj.setItems(value);
    }

    private void loadKeys(Object value, JsonObject jObj) {
        if (value == null) {
            return;
        }
        if (!value.getClass().isArray()) {
            this.error("Expected @keys to have an array [], but found: " + value.getClass().getName());
        }
        jObj.setKeys((Object[])value);
    }

    private Class<?> stringToClass(String className) {
        String resolvedName = this.readOptions.getTypeNameAlias(className);
        Class<Object> clazz = ClassUtilities.forName((String)resolvedName, (ClassLoader)this.readOptions.getClassLoader());
        if (clazz == null) {
            if (this.readOptions.isFailOnUnknownType()) {
                this.error("Unknown type (class) '" + className + "' not defined.");
            }
            if ((clazz = this.readOptions.getUnknownTypeClass()) == null) {
                clazz = LinkedHashMap.class;
            }
        }
        return clazz;
    }

    private Object error(String msg) {
        throw new JsonIoException(this.getMessage(msg));
    }

    private Object error(String msg, Exception e) {
        throw new JsonIoException(this.getMessage(msg), e);
    }

    private String getMessage(String msg) {
        return msg + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol() + "\n" + this.input.getLastSnippet();
    }

    static {
        String[] commonStrings;
        int i;
        EMPTY_ARRAY = new JsonObject();
        STRING_BUFFER = ThreadLocal.withInitial(() -> new char[4096]);
        STATIC_STRING_CACHE = new ConcurrentHashMap<String, String>(64);
        STATIC_NUMBER_CACHE = new ConcurrentHashMap<Number, Number>(16);
        SUBSTITUTES = new HashMap<String, String>(5);
        ESCAPE_CHAR_MAP = new char[128];
        HEX_VALUE_MAP = new int[128];
        JsonParser.ESCAPE_CHAR_MAP[92] = 92;
        JsonParser.ESCAPE_CHAR_MAP[47] = 47;
        JsonParser.ESCAPE_CHAR_MAP[34] = 34;
        JsonParser.ESCAPE_CHAR_MAP[39] = 39;
        JsonParser.ESCAPE_CHAR_MAP[98] = 8;
        JsonParser.ESCAPE_CHAR_MAP[102] = 12;
        JsonParser.ESCAPE_CHAR_MAP[110] = 10;
        JsonParser.ESCAPE_CHAR_MAP[114] = 13;
        JsonParser.ESCAPE_CHAR_MAP[116] = 9;
        Arrays.fill(HEX_VALUE_MAP, -1);
        for (i = 48; i <= 57; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = 10 + (i - 97);
        }
        for (i = 65; i <= 70; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = 10 + (i - 65);
        }
        SUBSTITUTES.put("@i", "@id");
        SUBSTITUTES.put("@r", "@ref");
        SUBSTITUTES.put("@e", "@items");
        SUBSTITUTES.put("@t", "@type");
        SUBSTITUTES.put("@k", "@keys");
        for (String s : commonStrings = new String[]{"", "true", "True", "TRUE", "false", "False", "FALSE", "null", "yes", "Yes", "YES", "no", "No", "NO", "on", "On", "ON", "off", "Off", "OFF", "id", "ID", "type", "value", "name", "@id", "@ref", "@items", "@type", "@keys", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}) {
            STATIC_STRING_CACHE.put(s, s);
        }
        STATIC_NUMBER_CACHE.put(-1L, -1L);
        STATIC_NUMBER_CACHE.put(0L, 0L);
        STATIC_NUMBER_CACHE.put(1L, 1L);
        STATIC_NUMBER_CACHE.put(-1.0, -1.0);
        STATIC_NUMBER_CACHE.put(0.0, 0.0);
        STATIC_NUMBER_CACHE.put(1.0, 1.0);
        STATIC_NUMBER_CACHE.put(Double.MIN_VALUE, Double.MIN_VALUE);
        STATIC_NUMBER_CACHE.put(Double.MAX_VALUE, Double.MAX_VALUE);
        STATIC_NUMBER_CACHE.put(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        STATIC_NUMBER_CACHE.put(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        STATIC_NUMBER_CACHE.put(Double.NaN, Double.NaN);
    }

    private static class ParserStringCache
    extends AbstractMap<String, String> {
        private final Map<String, String> staticCache;
        private final Map<String, String> instanceCache;

        public ParserStringCache(Map<String, String> staticCache) {
            this.staticCache = staticCache;
            this.instanceCache = new HashMap<String, String>(64);
        }

        @Override
        public String get(Object key) {
            String result = this.staticCache.get(key);
            if (result != null) {
                return result;
            }
            return this.instanceCache.get(key);
        }

        @Override
        public String put(String key, String value) {
            return this.instanceCache.put(key, value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
            entries.addAll(this.staticCache.entrySet());
            entries.addAll(this.instanceCache.entrySet());
            return entries;
        }
    }

    private static class ParserNumberCache
    extends AbstractMap<Number, Number> {
        private final Map<Number, Number> staticCache;
        private final Map<Number, Number> instanceCache;

        public ParserNumberCache(Map<Number, Number> staticCache) {
            this.staticCache = staticCache;
            this.instanceCache = new HashMap<Number, Number>(64);
        }

        @Override
        public Number get(Object key) {
            Number result = this.staticCache.get(key);
            if (result != null) {
                return result;
            }
            return this.instanceCache.get(key);
        }

        @Override
        public Number put(Number key, Number value) {
            return this.instanceCache.put(key, value);
        }

        @Override
        public Set<Map.Entry<Number, Number>> entrySet() {
            HashSet<Map.Entry<Number, Number>> entries = new HashSet<Map.Entry<Number, Number>>();
            entries.addAll(this.staticCache.entrySet());
            entries.addAll(this.instanceCache.entrySet());
            return entries;
        }
    }
}

