/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.CompactSet;
import java.util.Collection;

public class CompactSetFactory
implements JsonReader.ClassFactory {
    @Override
    public Collection newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        String order;
        String orderCode;
        Object configObj = jObj.get("config");
        Object dataObj = jObj.get("data");
        if (!(configObj instanceof String)) {
            throw new JsonIoException("CompactSet requires a config string");
        }
        String configStr = (String)configObj;
        if (!(dataObj instanceof Object[])) {
            throw new JsonIoException("CompactSet requires a data []");
        }
        Object[] data = (Object[])dataObj;
        jObj.remove("config");
        jObj.remove("data");
        jObj.setItems(data);
        String[] parts = configStr.split("/");
        if (parts.length != 3) {
            throw new JsonIoException("Invalid CompactSet config format: " + configStr);
        }
        boolean caseSensitive = "CS".equals(parts[0]);
        int compactSize = Integer.parseInt(parts[1].substring(1));
        switch (orderCode = parts[2]) {
            case "Sort": {
                order = "sorted";
                break;
            }
            case "Rev": {
                order = "reverse";
                break;
            }
            case "Ins": {
                order = "insertion";
                break;
            }
            default: {
                order = "unordered";
            }
        }
        CompactSet.Builder builder = CompactSet.builder().caseSensitive(caseSensitive).compactSize(compactSize);
        switch (order) {
            case "sorted": {
                builder.sortedOrder();
                break;
            }
            case "reverse": {
                builder.reverseOrder();
                break;
            }
            case "insertion": {
                builder.insertionOrder();
                break;
            }
            default: {
                builder.noOrder();
            }
        }
        CompactSet cset = builder.build();
        jObj.setTarget(cset);
        JsonReader reader = new JsonReader(resolver);
        reader.toJava(null, jObj);
        return cset;
    }
}

