/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIo;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Callable;

public class MetaUtils {
    private MetaUtils() {
    }

    public static String getLogMessage(String methodName, Object[] args) {
        return MetaUtils.getLogMessage(methodName, args, 64);
    }

    public static String getLogMessage(String methodName, Object[] args, int argCharLen) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        for (Object arg : args) {
            sb.append(MetaUtils.getJsonStringToMaxLength(arg, argCharLen));
            sb.append("  ");
        }
        String result = sb.toString().trim();
        return result + ')';
    }

    private static String getJsonStringToMaxLength(Object obj, int argCharLen) {
        WriteOptions options = new WriteOptionsBuilder().shortMetaKeys(true).showTypeInfoNever().build();
        String arg = JsonIo.toJson(obj, options);
        if (arg.length() > argCharLen) {
            arg = arg.substring(0, argCharLen) + "...";
        }
        return arg;
    }

    public static <K, V> V getValueWithDefaultForNull(Map map, K key, V defaultValue) {
        Object value = map.get(key);
        return value == null ? defaultValue : value;
    }

    public static <K, V> V getValueWithDefaultForMissing(Map map, K key, V defaultValue) {
        if (!map.containsKey(key)) {
            return defaultValue;
        }
        return map.get(key);
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        try {
            if (instance == null) {
                throw new IllegalStateException("Attempting to set field: " + field.getName() + " on null object.");
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set field: " + field.getName() + " on class: " + instance.getClass().getName() + " as field is not accessible.  Add a ClassFactory implementation to create the needed class, and use JsonReader.assignInstantiator() to associate your ClassFactory to the class: " + instance.getClass().getName(), e);
        }
    }

    public static boolean isLogicalPrimitive(Class<?> c) {
        return ClassUtilities.isPrimitive(c) || c.equals(String.class) || Number.class.isAssignableFrom(c) || Date.class.isAssignableFrom(c) || c.isEnum() || c.equals(Class.class);
    }

    public static Map<String, String> loadMapDefinition(String resName) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            String contents = ClassUtilities.loadResourceAsString((String)resName);
            Scanner scanner = new Scanner(contents);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.trim().startsWith("#") || line.isEmpty()) continue;
                String[] parts = line.split("=");
                map.put(parts[0].trim(), parts[1].trim());
            }
            scanner.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading in " + resName + ". The file should be in the resources folder. The contents are expected to have two strings separated by '='. You can use # or blank lines in the file, they will be skipped.");
        }
        return map;
    }

    public static Set<String> loadSetDefinition(String resName) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        try {
            String contents = ClassUtilities.loadResourceAsString((String)resName);
            Scanner scanner = new Scanner(contents);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.startsWith("#") || line.isEmpty()) continue;
                set.add(line);
            }
            scanner.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading in " + resName + ". The file should be in the resources folder. The contents have a single String per line.  You can use # (comment) or blank lines in the file, they will be skipped.");
        }
        return set;
    }

    @Deprecated
    public static String loadResourceAsString(String resourceName) {
        return ClassUtilities.loadResourceAsString((String)resourceName);
    }

    @Deprecated
    public static byte[] loadResourceAsBytes(String resourceName) {
        return ClassUtilities.loadResourceAsBytes((String)resourceName);
    }

    @Deprecated
    public static String removeLeadingAndTrailingQuotes(String input) {
        return StringUtilities.removeLeadingAndTrailingQuotes((String)input);
    }

    @Deprecated
    public static <T> T findClosest(Class<?> clazz, Map<Class<?>, T> workerClasses, T defaultClass) {
        return (T)ClassUtilities.findClosest(clazz, workerClasses, defaultClass);
    }

    @Deprecated
    public static void setUseUnsafe(boolean state) {
        ClassUtilities.setUseUnsafe((boolean)state);
    }

    @Deprecated
    public static Object newInstance(Converter converter, Class<?> c, Collection<?> argumentValues) {
        return ClassUtilities.newInstance((Converter)converter, c, argumentValues);
    }

    @Deprecated
    public static <T> T safelyIgnoreException(Callable<T> callable, T defaultValue) {
        return (T)ExceptionUtilities.safelyIgnoreException(callable, defaultValue);
    }

    @Deprecated
    public static void safelyIgnoreException(Runnable runnable) {
        ExceptionUtilities.safelyIgnoreException((Runnable)runnable);
    }

    @Deprecated
    public static int length(String s) {
        return StringUtilities.length((String)s);
    }

    @Deprecated
    public static int trimLength(String s) {
        return StringUtilities.trimLength((String)s);
    }

    @Deprecated
    public static Class<?> getClassIfEnum(Class<?> c) {
        return ClassUtilities.getClassIfEnum(c);
    }

    @Deprecated
    public static boolean isPrimitive(Class<?> c) {
        return ClassUtilities.isPrimitive(c);
    }

    @Deprecated
    public static void trySetAccessible(AccessibleObject object) {
        ExceptionUtilities.safelyIgnoreException(() -> object.setAccessible(true));
    }

    public static final class Dumpty
    extends Enum<Dumpty> {
        private static final /* synthetic */ Dumpty[] $VALUES;

        public static Dumpty[] values() {
            return (Dumpty[])$VALUES.clone();
        }

        public static Dumpty valueOf(String name) {
            return Enum.valueOf(Dumpty.class, name);
        }

        private static /* synthetic */ Dumpty[] $values() {
            return new Dumpty[0];
        }

        static {
            $VALUES = Dumpty.$values();
        }
    }
}

