/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class MapResolver
extends Resolver {
    protected MapResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Class<?> compType) {
        return null;
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        Object target = jsonObj.getTarget();
        Map<String, Injector> injectorMap = target == null ? null : this.getReadOptions().getDeepInjectorMap(target.getClass());
        ReferenceTracker refTracker = this.getReferences();
        Converter converter = this.getConverter();
        ReadOptions readOptions = this.getReadOptions();
        for (Map.Entry<Object, Object> e : jsonObj.entrySet()) {
            String fieldName = (String)e.getKey();
            Injector injector = injectorMap == null ? null : injectorMap.get(fieldName);
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, (Object)null);
                continue;
            }
            if (rhs.getClass().isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.setItems(rhs);
                this.push(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                boolean isNonRefClass;
                JsonObject jObj = (JsonObject)rhs;
                if (injector != null && (isNonRefClass = readOptions.isNonReferenceableClass(injector.getType()))) {
                    jObj.setValue(converter.convert(jObj.getValue(), injector.getType()));
                    continue;
                }
                Long refId = jObj.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = refTracker.getOrThrow(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                this.push(jObj);
                continue;
            }
            if (injector == null) continue;
            Class<?> fieldType = injector.getType();
            if (converter.isConversionSupportedFor(rhs.getClass(), fieldType)) {
                Object fieldValue = converter.convert(rhs, fieldType);
                jsonObj.put(fieldName, fieldValue);
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, (Object)null);
        }
        jsonObj.setTarget(null);
    }

    private void handleNestedArray(Object element, Class<?> componentType, Object target, int index) {
        JsonObject jsonObject = null;
        if (element instanceof JsonObject && ((JsonObject)element).isArray()) {
            jsonObject = (JsonObject)element;
        } else if (element != null && element.getClass().isArray()) {
            jsonObject = new JsonObject();
            jsonObject.setItems(element);
        }
        if (jsonObject != null) {
            if (componentType.isArray()) {
                jsonObject.setHintType(componentType);
                Object arrayElement = this.createInstance(jsonObject);
                this.setArrayElement(target, index, arrayElement);
            }
            this.push(jsonObject);
        }
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        Object items = jsonObj.getItems();
        if (items == null || Array.getLength(items) == 0) {
            return;
        }
        Object target = jsonObj.getTarget() != null ? jsonObj.getTarget() : jsonObj.getItems();
        ReferenceTracker refTracker = this.getReferences();
        Converter converter = this.getConverter();
        int len = Array.getLength(items);
        Class componentType = Object.class;
        if (jsonObj.getTarget() != null && (componentType = jsonObj.getTarget().getClass()).isArray()) {
            componentType = componentType.getComponentType();
        }
        for (int i = 0; i < len; ++i) {
            Object element = Array.get(items, i);
            if (element == null) {
                Array.set(target, i, null);
                continue;
            }
            if (element.getClass().isArray() || element instanceof JsonObject && ((JsonObject)element).isArray()) {
                this.handleNestedArray(element, componentType, target, i);
                continue;
            }
            if (converter.isConversionSupportedFor(element.getClass(), componentType)) {
                Object convertedValue = converter.convert(element, componentType);
                this.setArrayElement(target, i, convertedValue);
                continue;
            }
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                Long refId = jsonObject.getReferenceId();
                if (refId == null) {
                    Class<?> type = jsonObject.getJavaType();
                    if (type != null && converter.isConversionSupportedFor(Map.class, type)) {
                        Object converted = converter.convert((Object)jsonObject, type);
                        this.setArrayElement(target, i, converted);
                        jsonObject.setFinished();
                        continue;
                    }
                    this.push(jsonObject);
                    continue;
                }
                JsonObject refObject = refTracker.getOrThrow(refId);
                Class<?> type = refObject.getJavaType();
                if (type != null && converter.isConversionSupportedFor(Map.class, type)) {
                    Object convertedRef = converter.convert((Object)refObject, type);
                    refObject.setFinishedTarget(convertedRef, true);
                    this.setArrayElement(target, i, refObject.getTarget());
                    continue;
                }
                this.setArrayElement(target, i, refObject);
                continue;
            }
            this.setArrayElement(target, i, element);
        }
        jsonObj.setItems(target);
        jsonObj.setFinished();
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        Object items = jsonObj.getItems();
        Collection col = (Collection)jsonObj.getTarget();
        if (col == null) {
            col = (Collection)this.createInstance(jsonObj);
        }
        boolean isList = col instanceof List;
        int idx = 0;
        if (items != null) {
            int len = Array.getLength(items);
            for (int i = 0; i < len; ++i) {
                JsonObject jObj;
                Object element = Array.get(items, i);
                if (element == null) {
                    col.add(null);
                } else if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    col.add(element);
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject();
                    jObj.setHintType(Object.class);
                    jObj.setItems(element);
                    this.createInstance(jObj);
                    col.add(jObj.getTarget());
                    this.push(jObj);
                } else {
                    jObj = (JsonObject)element;
                    Long ref = jObj.getReferenceId();
                    if (ref != null) {
                        JsonObject refObject = this.getReferences().getOrThrow(ref);
                        if (refObject.getTarget() != null) {
                            col.add(refObject.getTarget());
                        } else {
                            this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, idx, (long)ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        jObj.setHintType(Object.class);
                        this.createInstance(jObj);
                        boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jObj.getJavaType());
                        if (!isNonRefClass) {
                            this.traverseSpecificType(jObj);
                        }
                        if (!(col instanceof EnumSet)) {
                            col.add(jObj.getTarget());
                        }
                    }
                }
                ++idx;
            }
        }
        jsonObj.setFinished();
    }

    @Override
    protected Object resolveArray(Class<?> suggestedType, List<Object> list) {
        if (suggestedType == null || suggestedType == Object.class) {
            return list.toArray();
        }
        JsonObject jsonArray = new JsonObject();
        if (Collection.class.isAssignableFrom(suggestedType)) {
            jsonArray.setHintType(suggestedType);
            jsonArray.setTarget(this.createInstance(jsonArray));
        } else {
            jsonArray.setTarget(Array.newInstance(suggestedType, list.size()));
        }
        jsonArray.setItems(list.toArray());
        return jsonArray;
    }
}

