/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectResolver
extends Resolver {
    private final ClassLoader classLoader;

    protected ObjectResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
        this.classLoader = readOptions.getClassLoader();
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        Object javaMate = jsonObj.getTarget();
        Iterator<Map.Entry<Object, Object>> i = jsonObj.entrySet().iterator();
        Class<?> cls = javaMate.getClass();
        ReadOptions readOptions = this.getReadOptions();
        Map<String, Injector> injectorMap = readOptions.getDeepInjectorMap(cls);
        while (i.hasNext()) {
            Map.Entry<Object, Object> e = i.next();
            String key = (String)e.getKey();
            Injector injector = injectorMap.get(key);
            Object rhs = e.getValue();
            if (injector != null) {
                this.assignField(jsonObj, injector, rhs);
                continue;
            }
            if (readOptions.getMissingFieldHandler() == null) continue;
            this.handleMissingField(jsonObj, rhs, key);
        }
    }

    @Override
    public void assignField(JsonObject jsonObj, Injector injector, Object rhs) {
        Object special;
        Object target = jsonObj.getTarget();
        Class<?> fieldType = injector.getType();
        if (rhs == null) {
            if (fieldType.isPrimitive()) {
                injector.inject(target, this.getConverter().convert(null, fieldType));
            } else {
                injector.inject(target, null);
            }
            return;
        }
        if (rhs instanceof JsonObject) {
            JsonObject jObj;
            if (injector.getGenericType() instanceof ParameterizedType) {
                this.markUntypedObjects(injector.getGenericType(), rhs, fieldType);
            }
            if ((jObj = (JsonObject)rhs).getJavaType() == null) {
                jObj.setJavaType(fieldType);
            }
        }
        if ((special = this.readWithFactoryIfExists(rhs, fieldType)) != null) {
            injector.inject(target, special);
        } else if (rhs.getClass().isArray()) {
            Object[] elements = (Object[])rhs;
            JsonObject jsonArray = new JsonObject();
            jsonArray.setJsonArray(elements);
            jsonArray.setHintType(fieldType);
            this.createInstance(jsonArray);
            injector.inject(target, jsonArray.getTarget());
            this.push(jsonArray);
        } else if (rhs instanceof JsonObject) {
            JsonObject jsRhs = (JsonObject)rhs;
            Long ref = jsRhs.getReferenceId();
            if (ref != null) {
                JsonObject refObject = this.getReferences().get(ref);
                if (refObject.getTarget() != null) {
                    injector.inject(target, refObject.getTarget());
                } else {
                    this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, injector.getName(), (long)ref));
                }
            } else {
                Object fieldObject = jsRhs.getTarget();
                injector.inject(target, fieldObject);
                boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jsRhs.getJavaType());
                if (!isNonRefClass) {
                    this.push(jsRhs);
                }
            }
        } else if (rhs instanceof String && ((String)rhs).trim().isEmpty() && fieldType != String.class) {
            injector.inject(target, null);
        } else {
            injector.inject(target, rhs);
        }
    }

    protected void handleMissingField(JsonObject jsonObj, Object rhs, String missingField) {
        Object target = jsonObj.getTarget();
        try {
            if (rhs == null) {
                this.storeMissingField(target, missingField, null);
                return;
            }
            Object special = this.readWithFactoryIfExists(rhs, null);
            if (special != null) {
                this.storeMissingField(target, missingField, special);
            } else if (rhs.getClass().isArray()) {
                this.storeMissingField(target, missingField, null);
            } else if (rhs instanceof JsonObject) {
                JsonObject jObj = (JsonObject)rhs;
                Long ref = jObj.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = this.getReferences().get(ref);
                    this.storeMissingField(target, missingField, refObject.getTarget());
                } else if (jObj.getJavaType() != null) {
                    Object javaInstance = this.createInstance(jObj);
                    boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jObj.getJavaType());
                    if (!isNonRefClass && !jObj.isFinished) {
                        this.push((JsonObject)rhs);
                    }
                    this.storeMissingField(target, missingField, javaInstance);
                } else {
                    this.storeMissingField(target, missingField, null);
                }
            } else {
                this.storeMissingField(target, missingField, rhs);
            }
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw e;
            }
            String message = e.getClass().getSimpleName() + " missing field '" + missingField + "' on target: " + ObjectResolver.safeToString(target) + " with value: " + rhs;
            throw new JsonIoException(message, e);
        }
    }

    private void storeMissingField(Object target, String missingField, Object value) {
        this.missingFields.add(new Resolver.Missingfields(target, missingField, value));
    }

    private static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            return o.getClass().toString();
        }
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        Object[] items = jsonObj.getJsonArray();
        Class mayEnumClass = null;
        String mayEnumClasName = (String)jsonObj.get("@enum");
        if (mayEnumClasName != null) {
            mayEnumClass = ClassUtilities.forName((String)mayEnumClasName, (ClassLoader)this.classLoader);
        }
        Collection col = (Collection)jsonObj.getTarget();
        boolean isList = col instanceof List;
        int idx = 0;
        if (items != null) {
            for (Object element : items) {
                if (element == null) {
                    col.add(null);
                } else {
                    JsonObject jObj;
                    Object special = this.readWithFactoryIfExists(element, null);
                    if (special != null) {
                        col.add(special);
                    } else if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                        col.add(mayEnumClass == null ? element : Enum.valueOf(mayEnumClass, (String)element));
                    } else if (element.getClass().isArray()) {
                        jObj = new JsonObject();
                        jObj.setHintType(Object.class);
                        jObj.setJsonArray((Object[])element);
                        this.createInstance(jObj);
                        col.add(jObj.getTarget());
                        this.push(jObj);
                    } else {
                        jObj = (JsonObject)element;
                        Long ref = jObj.getReferenceId();
                        if (ref != null) {
                            JsonObject refObject = this.getReferences().get(ref);
                            if (refObject.getTarget() != null) {
                                col.add(refObject.getTarget());
                            } else {
                                this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, idx, (long)ref));
                                if (isList) {
                                    col.add(null);
                                }
                            }
                        } else {
                            jObj.setHintType(Object.class);
                            this.createInstance(jObj);
                            boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jObj.getJavaType());
                            if (!isNonRefClass) {
                                this.traverseSpecificType(jObj);
                            }
                            if (!(col instanceof EnumSet)) {
                                col.add(jObj.getTarget());
                            }
                        }
                    }
                }
                ++idx;
            }
        }
        jsonObj.clear();
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        int len = jsonObj.getLength();
        if (len == 0) {
            return;
        }
        Object array = jsonObj.getTarget();
        Class<?> compType = array.getClass().getComponentType();
        Object[] jsonItems = jsonObj.getJsonArray();
        for (int i = 0; i < len; ++i) {
            Object element = jsonItems[i];
            if (element == null) {
                Array.set(array, i, null);
                continue;
            }
            Object special = this.readWithFactoryIfExists(element, compType);
            if (special != null) {
                if (compType.isEnum() && special instanceof String) {
                    special = Enum.valueOf(compType, (String)special);
                }
                Array.set(array, i, special);
                continue;
            }
            if (element.getClass().isArray()) {
                Object jsonArray;
                if (char[].class == compType) {
                    jsonArray = (Object[])element;
                    if (((Object[])jsonArray).length == 0) {
                        Array.set(array, i, new char[0]);
                        continue;
                    }
                    String value = (String)jsonArray[0];
                    int numChars = value.length();
                    char[] chars = new char[numChars];
                    for (int j = 0; j < numChars; ++j) {
                        chars[j] = value.charAt(j);
                    }
                    Array.set(array, i, chars);
                    continue;
                }
                jsonArray = new JsonObject();
                ((JsonObject)jsonArray).setJsonArray((Object[])element);
                ((JsonValue)jsonArray).setHintType(compType);
                Array.set(array, i, this.createInstance((JsonObject)jsonArray));
                this.push((JsonObject)jsonArray);
                continue;
            }
            if (element instanceof JsonObject) {
                JsonObject jsonElement = (JsonObject)element;
                Long ref = jsonElement.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = this.getReferences().get(ref);
                    if (refObject.getTarget() != null) {
                        Array.set(array, i, refObject.getTarget());
                        continue;
                    }
                    this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, i, (long)ref));
                    continue;
                }
                jsonElement.setHintType(compType);
                Object arrayElement = this.createInstance(jsonElement);
                Array.set(array, i, arrayElement);
                boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(arrayElement.getClass());
                if (isNonRefClass || jsonElement.isFinished) continue;
                this.push(jsonElement);
                continue;
            }
            if (element instanceof String && ((String)element).trim().isEmpty() && compType != String.class && compType != Object.class) {
                Array.set(array, i, null);
                continue;
            }
            Array.set(array, i, element);
        }
        jsonObj.clear();
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Class<?> inferredType) {
        JsonReader.JsonClassReader closestReader;
        Class<?> c;
        JsonObject jsonObj;
        if (o == null) {
            throw new JsonIoException("Bug in json-io, null must be checked before calling this method.");
        }
        ReadOptions readOptions = this.getReadOptions();
        if (inferredType != null && readOptions.isNotCustomReaderClass(inferredType)) {
            return null;
        }
        boolean isJsonObject = o instanceof JsonObject;
        if (!isJsonObject && inferredType == null) {
            return null;
        }
        if (isJsonObject) {
            jsonObj = (JsonObject)o;
            if (jsonObj.isReference()) {
                return null;
            }
            if (jsonObj.getTarget() == null) {
                c = jsonObj.getJavaType();
                if (c == null || inferredType == null) {
                    return null;
                }
                jsonObj.setHintType(c);
                Object factoryCreated = this.createInstance(jsonObj);
                if (factoryCreated != null && jsonObj.isFinished) {
                    return factoryCreated;
                }
            } else {
                c = jsonObj.getJavaType();
            }
        } else {
            c = inferredType.equals(Object.class) ? o.getClass() : inferredType;
            jsonObj = new JsonObject();
            jsonObj.setValue(o);
            jsonObj.setHintType(c);
        }
        if (readOptions.isNotCustomReaderClass(c)) {
            return null;
        }
        if (jsonObj.getTarget() == null && jsonObj.hasValue() && this.getConverter().isConversionSupportedFor(jsonObj.getValue().getClass(), c)) {
            Object target = this.getConverter().convert(jsonObj.getValue(), c);
            return jsonObj.setFinishedTarget(target, true);
        }
        JsonReader.ClassFactory classFactory = readOptions.getClassFactory(c);
        if (classFactory != null && jsonObj.getTarget() == null) {
            Object target = this.createInstanceUsingClassFactory(c, jsonObj);
            if (jsonObj.isFinished()) {
                return target;
            }
        }
        if ((closestReader = readOptions.getCustomReader(c)) == null) {
            return null;
        }
        Object read = closestReader.read(o, this);
        if (read == null) {
            return null;
        }
        return jsonObj.setFinishedTarget(read, true);
    }

    /*
     * WARNING - void declaration
     */
    private void markUntypedObjects(Type type, Object rhs, Class<?> fieldType) {
        ArrayDeque<Object[]> stack2 = new ArrayDeque<Object[]>();
        stack2.addFirst(new Object[]{type, rhs});
        Map<String, Injector> classFields = this.getReadOptions().getDeepInjectorMap(fieldType);
        while (!stack2.isEmpty()) {
            Object[] item = (Object[])stack2.removeFirst();
            Type t = (Type)item[0];
            Object instance = item[1];
            if (t instanceof ParameterizedType) {
                JsonObject jObj;
                Class<?> clazz = ObjectResolver.getRawType(t);
                ParameterizedType pType = (ParameterizedType)t;
                Type[] typeArgs = pType.getActualTypeArguments();
                if (typeArgs == null || typeArgs.length < 1 || clazz == null) continue;
                ObjectResolver.stampTypeOnJsonObject(instance, t);
                if (Map.class.isAssignableFrom(clazz)) {
                    JsonObject jsonObj = (JsonObject)instance;
                    Map.Entry<Object[], Object[]> pair = jsonObj.asTwoArrays();
                    Object[] objectArray = pair.getKey();
                    Object[] items = pair.getValue();
                    ObjectResolver.getTemplateTraverseWorkItem(stack2, objectArray, typeArgs[0]);
                    ObjectResolver.getTemplateTraverseWorkItem(stack2, items, typeArgs[1]);
                    continue;
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    Object[] array;
                    if (instance instanceof Object[]) {
                        Object[] array2 = (Object[])instance;
                        for (int i = 0; i < array2.length; ++i) {
                            Object object = array2[i];
                            stack2.addFirst(new Object[]{t, object});
                            if (object instanceof JsonObject) {
                                stack2.addFirst(new Object[]{t, object});
                                continue;
                            }
                            if (object instanceof Object[]) {
                                JsonObject coll = new JsonObject();
                                coll.setJavaType(clazz);
                                coll.setJsonArray((Object[])object);
                                List<Object> items = Arrays.asList((Object[])object);
                                stack2.addFirst(new Object[]{t, items});
                                array2[i] = coll;
                                continue;
                            }
                            stack2.addFirst(new Object[]{t, object});
                        }
                        continue;
                    }
                    if (instance instanceof Collection) {
                        Collection col = (Collection)instance;
                        for (Object e : col) {
                            stack2.addFirst(new Object[]{typeArgs[0], e});
                        }
                        continue;
                    }
                    if (!(instance instanceof JsonObject) || (array = (jObj = (JsonObject)instance).getJsonArray()) == null) continue;
                    for (Object object : array) {
                        stack2.addFirst(new Object[]{typeArgs[0], object});
                    }
                    continue;
                }
                if (!(instance instanceof JsonObject)) continue;
                jObj = (JsonObject)instance;
                for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
                    void var17_30;
                    Injector injector;
                    String fieldName = (String)entry.getKey();
                    if (fieldName.startsWith("this$") || (injector = classFields.get(fieldName)) == null || injector.getType().getTypeParameters().length <= 0 && !(injector.getGenericType() instanceof TypeVariable)) continue;
                    Type type2 = typeArgs[0];
                    if (entry.getValue() instanceof JsonObject && ((JsonObject)entry.getValue()).get("@enum") != null) {
                        Type type3 = injector.getGenericType();
                    }
                    stack2.addFirst(new Object[]{var17_30, entry.getValue()});
                }
                continue;
            }
            ObjectResolver.stampTypeOnJsonObject(instance, t);
        }
    }

    private static void getTemplateTraverseWorkItem(Deque<Object[]> stack2, Object[] items, Type type) {
        if (items == null || items.length < 1) {
            return;
        }
        Class<?> rawType = ObjectResolver.getRawType(type);
        if (rawType != null && Collection.class.isAssignableFrom(rawType)) {
            stack2.add(new Object[]{type, items});
        } else {
            for (Object o : items) {
                stack2.add(new Object[]{type, o});
            }
        }
    }

    private static void stampTypeOnJsonObject(Object o, Type t) {
        JsonObject jObj;
        Class<?> clazz;
        Class<?> clazz2 = clazz = t instanceof Class ? (Class<?>)t : ObjectResolver.getRawType(t);
        if (o instanceof JsonObject && clazz != null && (jObj = (JsonObject)o).getJavaType() == null && jObj.getTarget() == null) {
            jObj.setJavaType(clazz);
        }
    }

    private static Class<?> getRawType(Type t) {
        ParameterizedType pType;
        if (t instanceof ParameterizedType && (pType = (ParameterizedType)t).getRawType() instanceof Class) {
            return (Class)pType.getRawType();
        }
        return null;
    }
}

