/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.Resolver;
import java.util.ArrayList;

public class ThrowableFactory
implements JsonReader.ClassFactory {
    private static final String DETAIL_MESSAGE = "detailMessage";
    private static final String CAUSE = "cause";
    private static final String STACK_TRACE = "stackTrace";

    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        Object[] stackTrace;
        ArrayList<Object> arguments = new ArrayList<Object>();
        String message = (String)jObj.get(DETAIL_MESSAGE);
        JsonObject jsonCause = (JsonObject)jObj.get(CAUSE);
        Class causeType = jsonCause == null ? Throwable.class : jsonCause.getJavaType();
        causeType = causeType == null ? Throwable.class : causeType;
        Throwable cause = resolver.toJavaObjects(jsonCause, causeType);
        if (message != null) {
            arguments.add(message);
        }
        if (cause != null) {
            arguments.add(cause);
        }
        this.gatherRemainingValues(resolver, jObj, arguments, MetaUtils.setOf(DETAIL_MESSAGE, CAUSE, STACK_TRACE));
        Throwable t = (Throwable)MetaUtils.newInstance(resolver.getConverter(), c, arguments);
        if (t.getCause() == null && cause != null) {
            t.initCause(cause);
        }
        if ((stackTrace = (Object[])jObj.get(STACK_TRACE)) != null) {
            StackTraceElement[] elements = new StackTraceElement[stackTrace.length];
            for (int i = 0; i < stackTrace.length; ++i) {
                JsonObject stackTraceMap = (JsonObject)stackTrace[i];
                elements[i] = stackTraceMap == null ? null : resolver.toJavaObjects(stackTraceMap, StackTraceElement.class);
            }
            t.setStackTrace(elements);
        }
        return t;
    }

    @Override
    public boolean isObjectFinal() {
        return false;
    }
}

