/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayInputStream;
import com.cedarsoftware.util.FastByteArrayOutputStream;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.ConverterOptions;
import com.cedarsoftware.util.convert.DefaultConverterOptions;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReadOptionsBuilder;
import com.cedarsoftware.util.io.WriteOptions;
import com.cedarsoftware.util.io.WriteOptionsBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class JsonIo {
    private JsonIo() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toJson(Object srcObject, WriteOptions writeOptions) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        try (JsonWriter writer = new JsonWriter((OutputStream)out, writeOptions);){
            writer.write(srcObject);
            String string = out.toString();
            return string;
        }
        catch (JsonIoException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to convert object to JSON", e);
        }
    }

    public static void toJson(OutputStream out, Object source, WriteOptions writeOptions) {
        Convention.throwIfNull((Object)out, (String)"OutputStream cannot be null");
        JsonWriter writer = null;
        try {
            writer = new JsonWriter(out, writeOptions);
            writer.write(source);
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to convert object and send in JSON format to OutputStream.", e);
        }
        finally {
            if (writeOptions.isCloseStream() && writer != null) {
                writer.close();
            }
        }
    }

    public static <T> T toObjects(String json, ReadOptions readOptions, Class<T> rootType) {
        if (json == null) {
            json = "";
        }
        return JsonIo.toObjects((InputStream)new FastByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), readOptions, rootType);
    }

    public static <T> T toObjects(InputStream in, ReadOptions readOptions, Class<T> rootType) {
        Convention.throwIfNull((Object)in, (String)"InputStream cannot be null");
        JsonReader jr = null;
        try {
            T root;
            jr = new JsonReader(in, readOptions);
            T t = root = jr.readObject(rootType);
            return t;
        }
        catch (JsonIoException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JsonIoException(e);
        }
        finally {
            if (readOptions != null && readOptions.isCloseStream() && jr != null) {
                jr.close();
            }
        }
    }

    public static <T> T toObjects(JsonObject jsonObject, ReadOptions readOptions, Class<T> rootType) {
        if (readOptions == null) {
            readOptions = new ReadOptionsBuilder().returnAsJavaObjects().build();
        }
        JsonReader reader = new JsonReader(readOptions);
        return reader.convertJsonValueToJava(jsonObject, rootType);
    }

    public static String formatJson(String json, ReadOptions readOptions, WriteOptions writeOptions) {
        Convention.throwIfFalse((writeOptions == null || writeOptions.isPrettyPrint() ? 1 : 0) != 0, (String)"Pretty print must be turned on to format JSON.");
        Convention.throwIfFalse((readOptions == null || readOptions.isReturningJsonObjects() ? 1 : 0) != 0, (String)"To format and remove type information we must be returning objects as pure JSON");
        if (writeOptions == null) {
            writeOptions = new WriteOptionsBuilder().prettyPrint(true).build();
        }
        if (readOptions == null) {
            readOptions = new ReadOptionsBuilder().returnAsJavaObjects().build();
        }
        Object object = JsonIo.toObjects(json, readOptions, null);
        return JsonIo.toJson(object, writeOptions);
    }

    public static String formatJson(String json) {
        return JsonIo.formatJson(json, new ReadOptionsBuilder().returnAsNativeJsonObjects().build(), new WriteOptionsBuilder().prettyPrint(true).build());
    }

    public static <T> T deepCopy(Object source, ReadOptions readOptions, WriteOptions writeOptions) {
        if (source == null) {
            return null;
        }
        String json = JsonIo.toJson(source, writeOptions);
        return (T)JsonIo.toObjects(json, readOptions, source.getClass());
    }

    public static void main(String[] args) {
        String json = JsonIo.toJson(new Converter((ConverterOptions)new DefaultConverterOptions()).getSupportedConversions(), new WriteOptionsBuilder().prettyPrint(true).showTypeInfoNever().build());
        System.out.println("json-io supported conversions (source type to target types):");
        System.out.println(json);
    }
}

