/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Map<Object, Object> {
    private final Map<Object, Object> jsonStore = new LinkedHashMap<Object, Object>();
    private boolean isMap = false;
    private Integer hash = null;
    private static final Set<String> logicalPrimitives = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("boolean", "java.lang.Boolean", "double", "java.lang.Double", "long", "java.lang.Long", "byte", "java.lang.Byte", "char", "java.lang.Character", "float", "java.lang.Float", "int", "java.lang.Integer", "short", "java.lang.Short", "date", "java.util.Date", "BigInt", "java.math.BigInteger", "BigDec", "java.math.BigDecimal", "class", "java.lang.Class")));

    public String toString() {
        String jType = this.javaType == null ? "not set" : this.javaType.getName();
        String targetInfo = this.getTarget() == null ? "null" : jType;
        return "JsonObject(id:" + this.id + ", type:" + jType + ", target:" + targetInfo + ", line:" + this.line + ", col:" + this.col + ", size:" + this.size() + ")";
    }

    @Override
    public Object setFinishedTarget(Object o, boolean isFinished) {
        this.setTarget(o);
        this.isFinished = isFinished;
        return this.getTarget();
    }

    public boolean isLogicalPrimitive() {
        if (this.getJavaType() == null) {
            return false;
        }
        return logicalPrimitives.contains(this.getJavaTypeName());
    }

    public Object getPrimitiveValue(Converter converter, ClassLoader classloader) {
        Object value = this.getValue();
        String type = this.getJavaTypeName();
        if ("class".equals(type) || "java.lang.Class".equals(type)) {
            return ClassUtilities.forName((String)((String)value), (ClassLoader)classloader);
        }
        Class clazz = ClassUtilities.forName((String)type, (ClassLoader)classloader);
        if (clazz == null) {
            throw new JsonIoException("Invalid primitive type, line " + this.line + ", col " + this.col);
        }
        return converter.convert(value, clazz);
    }

    public boolean isMap() {
        return this.isMap || this.getTarget() instanceof Map;
    }

    public boolean isCollection() {
        if (this.getTarget() instanceof Collection) {
            return true;
        }
        if (this.containsKey("@items") && !this.containsKey("@keys")) {
            String typeName = this.getJavaTypeName();
            return typeName != null && !typeName.contains("[");
        }
        return false;
    }

    @Override
    public boolean isArray() {
        if (this.getTarget() == null) {
            if (this.getJavaType() != null) {
                return this.getJavaTypeName().contains("[");
            }
            return this.containsKey("@items") && !this.containsKey("@keys");
        }
        return this.getTarget().getClass().isArray();
    }

    public Object[] getArray() {
        return (Object[])this.get("@items");
    }

    public int getLength() {
        Integer items = this.getLenientSize();
        if (items != null) {
            return items;
        }
        throw new JsonIoException("getLength() called on a non-collection, line " + this.line + ", col " + this.col);
    }

    private Integer getLenientSize() {
        if (this.isArray()) {
            if (this.getTarget() == null) {
                Object[] items = (Object[])this.get("@items");
                return items == null ? 0 : items.length;
            }
            if (char[].class.isAssignableFrom(this.getTarget().getClass())) {
                return 1;
            }
            return Array.getLength(this.getTarget());
        }
        if (this.isCollection() || this.isMap()) {
            Object[] items = (Object[])this.get("@items");
            return items == null ? 0 : items.length;
        }
        return null;
    }

    public Class<?> getComponentType() {
        return this.getTarget().getClass().getComponentType();
    }

    public Object setValue(Object o) {
        return this.put("value", o);
    }

    public Object getValue() {
        return this.get("value");
    }

    public boolean hasValue() {
        return this.containsKey("value") && this.size() == 1;
    }

    void clearArray() {
        this.remove("@items");
        this.hash = null;
    }

    @Override
    public int size() {
        if (this.containsKey("@items")) {
            if (this.getArray() == null) {
                return 0;
            }
            return this.getArray().length;
        }
        if (this.containsKey("@ref")) {
            return 0;
        }
        return this.jsonStore.size();
    }

    private int calculateArrayHash() {
        int hashCode = 0;
        Object array = this.get("@items");
        if (array != null) {
            int len = Array.getLength(array);
            for (int j = 0; j < len; ++j) {
                Object elem = Array.get(array, j);
                hashCode += elem == null ? 0 : elem.hashCode();
            }
        } else {
            hashCode = super.hashCode();
        }
        return hashCode;
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            this.hash = this.isArray() || this.isCollection() ? Integer.valueOf(this.calculateArrayHash()) : Integer.valueOf(this.jsonStore.hashCode());
        }
        return this.hash;
    }

    @Override
    public boolean isEmpty() {
        return this.jsonStore.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.jsonStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.jsonStore.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.jsonStore.get(key);
    }

    @Override
    public Object remove(Object key) {
        this.hash = null;
        return this.jsonStore.remove(key);
    }

    @Override
    public Object put(Object key, Object value) {
        this.hash = null;
        if (key == null) {
            return this.jsonStore.put(null, value);
        }
        if ("@items".equals(key) && this.containsKey("@keys") || "@keys".equals(key) && this.containsKey("@items")) {
            this.isMap = true;
        }
        return this.jsonStore.put(key, value);
    }

    @Override
    public void putAll(Map<?, ?> map) {
        this.hash = null;
        this.jsonStore.putAll(map);
    }

    @Override
    public void clear() {
        super.clear();
        this.jsonStore.clear();
        this.hash = null;
    }

    @Override
    public Set<Object> keySet() {
        return this.jsonStore.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.jsonStore.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.jsonStore.entrySet();
    }
}

