/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonParser;
import com.cedarsoftware.io.MapResolver;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ObjectResolver;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.ReaderContext;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayInputStream;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.convert.Converter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonReader
implements Closeable,
ReaderContext {
    private final FastReader input;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final Converter converter;
    private final JsonParser parser;

    protected FastReader getReader(InputStream inputStream) {
        return new FastReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), 8192, 10);
    }

    public JsonReader(InputStream input, ReadOptions readOptions) {
        this(input, readOptions, new DefaultReferenceTracker());
    }

    public JsonReader(InputStream inputStream, ReadOptions readOptions, ReferenceTracker references) {
        this.readOptions = readOptions == null ? new ReadOptionsBuilder().returnAsJavaObjects().build() : readOptions;
        this.converter = new Converter(this.readOptions.getConverterOptions());
        this.input = this.getReader(inputStream);
        this.resolver = this.readOptions.isReturningJsonObjects() ? new MapResolver(this.readOptions, references, this.converter) : new ObjectResolver(this.readOptions, references, this.converter);
        this.parser = new JsonParser(this.input, this.resolver);
    }

    public JsonReader(ReadOptions readOptions) {
        this((InputStream)new FastByteArrayInputStream(new byte[0]), readOptions);
    }

    public <T> T readObject(Class<T> rootType) {
        Object graph;
        Object returnValue;
        try {
            returnValue = this.parser.readValue(rootType);
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException("error parsing JSON value", e);
        }
        if (returnValue == null) {
            return null;
        }
        JsonObject rootObj = new JsonObject();
        if (rootType != null) {
            rootObj.setHintType(rootType);
        }
        if (returnValue instanceof Object[]) {
            rootObj.setJavaType(Object[].class);
            rootObj.setTarget(returnValue);
            rootObj.put("@items", returnValue);
            graph = this.convertJsonValueToJava(rootObj, rootType);
        } else if (returnValue instanceof JsonObject) {
            graph = this.convertJsonValueToJava((JsonObject)returnValue, rootType);
        } else {
            rootObj.setValue(returnValue);
            graph = this.convertJsonValueToJava(rootObj, rootType);
            if (graph instanceof JsonObject && ((JsonObject)graph).getValue() != null) {
                graph = ((JsonObject)graph).getValue();
            }
        }
        if (this.readOptions.isReturningJsonObjects()) {
            return (T)returnValue;
        }
        return graph;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    public ClassLoader getClassLoader() {
        return this.readOptions.getClassLoader();
    }

    @Override
    public ReferenceTracker getReferences() {
        return this.resolver.getReferences();
    }

    @Override
    public <T> T reentrantConvertJsonValueToJava(JsonObject rootObj, Class<T> root) {
        return this.resolver.reentrantConvertJsonValueToJava(rootObj, root);
    }

    @Override
    public void traverseFields(Deque<JsonObject> stack, JsonObject jsonObj) {
        this.resolver.traverseFields(stack, jsonObj);
    }

    protected <T> T convertJsonValueToJava(JsonObject rootObj, Class<T> root) {
        try {
            if (root == null) {
                root = rootObj.getJavaType() == null ? Object.class : rootObj.getJavaType();
            }
            T t = this.reentrantConvertJsonValueToJava(rootObj, root);
            return t;
        }
        catch (Exception e) {
            if (this.readOptions.isCloseStream()) {
                MetaUtils.safelyIgnoreException(this::close);
            }
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
        finally {
            this.resolver.cleanup();
        }
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input != null) {
            return msg + "\nLast read: " + this.input.getLastSnippet() + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol();
        }
        return msg;
    }

    static class DefaultReferenceTracker
    implements ReferenceTracker {
        final Map<Long, JsonObject> references = new HashMap<Long, JsonObject>();

        DefaultReferenceTracker() {
        }

        @Override
        public JsonObject put(Long l, JsonObject o) {
            return this.references.put(l, o);
        }

        @Override
        public void clear() {
            this.references.clear();
        }

        @Override
        public int size() {
            return this.references.size();
        }

        @Override
        public JsonObject get(JsonObject jObj) {
            if (!jObj.isReference()) {
                return jObj;
            }
            return this.get(jObj.getReferenceId());
        }

        @Override
        public JsonObject get(Long id) {
            JsonObject target = this.references.get(id);
            if (target == null) {
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            while (target.isReference()) {
                id = target.getReferenceId();
                if ((target = this.references.get(id)) != null) continue;
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            return target;
        }
    }

    public static interface JsonClassReader {
        default public Object read(Object jOb, Deque<JsonObject> stack, ReaderContext context) {
            return this.read(jOb, stack);
        }

        default public Object read(Object jOb, Deque<JsonObject> stack) {
            return null;
        }
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }

    public static interface ClassFactory {
        default public Object newInstance(Class<?> c, JsonObject jObj, ReaderContext context) {
            return MetaUtils.newInstance(context.getConverter(), c, null);
        }

        default public Object newInstance(Class<?> c, JsonObject jObj) {
            return MetaUtils.newInstance(null, c, null);
        }

        default public boolean isObjectFinal() {
            return false;
        }

        default public void gatherRemainingValues(ReaderContext context, JsonObject jObj, List<Object> arguments, Set<String> excludedFields) {
            Convention.throwIfNull((Object)jObj, (String)"JsonObject cannot be null");
            for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
                JsonObject sub;
                Object value;
                if (excludedFields.contains(entry.getKey().toString()) || entry.getValue() == null || !(entry.getValue() instanceof JsonObject) || (value = context.reentrantConvertJsonValueToJava(sub = (JsonObject)entry.getValue(), sub.getJavaType())) == null || sub.getJavaType() == null) continue;
                arguments.add(value);
            }
        }
    }
}

