/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect.factories;

import com.cedarsoftware.util.reflect.Injector;
import com.cedarsoftware.util.reflect.InjectorFactory;
import com.cedarsoftware.util.reflect.factories.NonStandardInjectorNames;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;

public class MappedMethodInjectorFactory
implements InjectorFactory {
    private static final int METHOD_MODIFIERS = 9;

    @Override
    public Injector createInjector(Field field, Map<String, Method> possibleInjectors) {
        String fieldName = field.getName();
        Optional<String> possibleMethod = NonStandardInjectorNames.instance().getMapping(field.getDeclaringClass(), fieldName);
        Method method = possibleInjectors.get(possibleMethod.orElse(MappedMethodInjectorFactory.createGetterName(fieldName)));
        if (method == null || (method.getModifiers() & 9) != 1) {
            return null;
        }
        Class<?> type = method.getParameters()[0].getType();
        if (!type.isAssignableFrom(field.getType())) {
            return null;
        }
        try {
            return new Injector(field, method);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String createGetterName(String fieldName) {
        return "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }
}

