/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ReaderContext;
import java.util.Optional;

public class EnumClassFactory
implements JsonReader.ClassFactory {
    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, ReaderContext context) {
        String name = this.getEnumName(jObj);
        Optional<Class> cls = MetaUtils.getClassIfEnum(c);
        if (!cls.isPresent()) {
            throw new JsonIoException("Unable to load enum: " + c + ", class not found or is not an Enum.");
        }
        if (name != null) {
            return jObj.setFinishedTarget(this.fromString(cls.get(), name), false);
        }
        Object value = jObj.getValue();
        if (value instanceof String) {
            return jObj.setFinishedTarget(this.fromString(c, (String)value), true);
        }
        throw new JsonIoException("Unable to load enum: " + c + ", class not found or is not an Enum.");
    }

    protected Enum fromString(Class<?> c, String s) {
        return Enum.valueOf(c, s);
    }

    protected String getEnumName(JsonObject job) {
        String name = (String)job.get("Enum.name");
        return name != null ? name : (String)job.get("name");
    }
}

