/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.Primitives;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReferenceTracker;
import com.cedarsoftware.util.io.Resolver;
import com.cedarsoftware.util.reflect.ClassDescriptors;
import com.cedarsoftware.util.reflect.Injector;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Map;

public class MapResolver
extends Resolver {
    protected MapResolver(ReadOptions readOptions, ReferenceTracker references) {
        super(readOptions, references);
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Class compType, Deque<JsonObject> stack) {
        return null;
    }

    @Override
    public void traverseFields(Deque<JsonObject> stack, JsonObject jsonObj) {
        Object target = jsonObj.target;
        Map<String, Injector> injectorMap = target == null ? null : ClassDescriptors.instance().getDeepInjectorMap(target.getClass());
        for (Map.Entry e : jsonObj.entrySet()) {
            String fieldName = (String)e.getKey();
            Injector injector = injectorMap == null ? null : injectorMap.get(fieldName);
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, (Object)null);
                continue;
            }
            if (rhs.getClass().isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.put("@items", rhs);
                stack.addFirst(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                JsonObject jObj = (JsonObject)rhs;
                if (injector != null && this.getReadOptions().isLogicalPrimitive(injector.getType())) {
                    jObj.put("value", MetaUtils.convert(injector.getType(), jObj.getValue()));
                    continue;
                }
                Long refId = jObj.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = this.getReferences().get(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                stack.addFirst(jObj);
                continue;
            }
            if (injector == null) continue;
            Class<?> fieldType = injector.getType();
            if (Primitives.isPrimitive(fieldType) || BigDecimal.class.equals(fieldType) || BigInteger.class.equals(fieldType) || Date.class.equals(fieldType)) {
                jsonObj.put(fieldName, MetaUtils.convert(fieldType, rhs));
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, (Object)null);
        }
        jsonObj.target = null;
    }

    @Override
    protected void traverseCollection(Deque<JsonObject> stack, JsonObject jsonObj) {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return;
        }
        int idx = 0;
        ArrayList<Object> copy = new ArrayList<Object>(items.length);
        for (Object element : items) {
            JsonObject jsonObject;
            copy.add(element);
            if (element instanceof Object[]) {
                jsonObject = new JsonObject();
                jsonObject.put("@items", element);
                stack.addFirst(jsonObject);
            } else if (element instanceof JsonObject) {
                jsonObject = (JsonObject)element;
                Long refId = jsonObject.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = this.getReferences().get(refId);
                    copy.set(idx, refObject);
                } else {
                    stack.addFirst(jsonObject);
                }
            }
            ++idx;
        }
        jsonObj.target = null;
        for (int i = 0; i < items.length; ++i) {
            items[i] = copy.get(i);
        }
    }

    @Override
    protected void traverseArray(Deque<JsonObject> stack, JsonObject jsonObj) {
        this.traverseCollection(stack, jsonObj);
    }
}

