/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.Convention;
import com.cedarsoftware.util.io.FastReader;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonParser;
import com.cedarsoftware.util.io.MapResolver;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ObjectResolver;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReadOptionsBuilder;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.ReferenceTracker;
import com.cedarsoftware.util.io.Resolver;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;

public class JsonReader
implements Closeable {
    public static final String CUSTOM_READER_MAP = "CUSTOM_READERS";
    public static final String NOT_CUSTOM_READER_MAP = "NOT_CUSTOM_READERS";
    public static final String USE_MAPS = "USE_MAPS";
    public static final String UNKNOWN_OBJECT = "UNKNOWN_OBJECT";
    public static final String FAIL_ON_UNKNOWN_TYPE = "FAIL_ON_UNKNOWN_TYPE";
    public static final String JSON_READER = "JSON_READER";
    public static final String OBJECT_RESOLVER = "OBJECT_RESOLVER";
    public static final String TYPE_NAME_MAP = "TYPE_NAME_MAP";
    public static final String MISSING_FIELD_HANDLER = "MISSING_FIELD_HANDLER";
    public static final String CLASSLOADER = "CLASSLOADER";
    static final String TYPE_NAME_MAP_REVERSE = "TYPE_NAME_MAP_REVERSE";
    public static final String FACTORIES = "FACTORIES";
    static final int DEFAULT_MAX_PARSE_DEPTH = 1000;
    private final FastReader input;
    @Deprecated
    private final Map<String, Object> args = new HashMap<String, Object>();
    private static volatile boolean allowNanAndInfinity = false;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final JsonParser parser;

    @Deprecated
    private static void addPossibleReader(Map map, String fqClassName, Supplier<JsonClassReader> reader) {
        ReadOptionsBuilder.addPossiblePermanentReader(map, fqClassName, reader);
    }

    @Deprecated
    public static void assignInstantiator(String className, ClassFactory factory) {
        ReadOptionsBuilder.assignInstantiator(className, factory);
    }

    @Deprecated
    public static void assignInstantiator(Class<?> c, ClassFactory factory) {
        ReadOptionsBuilder.assignInstantiator(c, factory);
    }

    @Deprecated
    public void addReader(Class<?> c, JsonClassReader reader) {
        this.readOptions.addReader(c, reader);
    }

    @Deprecated
    public void addNotCustomReader(Class<?> c) {
        this.readOptions.addNonCustomizableClass(c);
    }

    public static <T> T toObjects(InputStream input, ReadOptions options) {
        try (JsonReader jr = new JsonReader(input, options);){
            Object object = jr.readObject();
            return (T)object;
        }
    }

    public static <T> T toObjects(byte[] bytes, ReadOptions options) {
        return JsonReader.toObjects(new ByteArrayInputStream(bytes), options);
    }

    public static <T> T toObjects(String jsonString, ReadOptions options) {
        if (jsonString == null) {
            return null;
        }
        return JsonReader.toObjects(jsonString.getBytes(StandardCharsets.UTF_8), options);
    }

    public static <T> T toObjects(String json) {
        return JsonReader.toObjects(json, new ReadOptionsBuilder().build());
    }

    @Deprecated
    public static <T> T jsonToJava(String json) {
        return JsonReader.toObjects(json);
    }

    @Deprecated
    public static Object jsonToJava(String json, Map<String, Object> optionalArgs, int maxDepth) {
        if (json == null) {
            return null;
        }
        return JsonReader.jsonToJava(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), optionalArgs, maxDepth);
    }

    @Deprecated
    public static <T> T jsonToJava(String json, Map<String, Object> optionalArgs) {
        return (T)JsonReader.jsonToJava(json, optionalArgs, 1000);
    }

    @Deprecated
    public static <T> T jsonToJava(InputStream inputStream, Map<String, Object> optionalArgs, int maxDepth) {
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
            optionalArgs.put(USE_MAPS, false);
        }
        if (!optionalArgs.containsKey(USE_MAPS)) {
            optionalArgs.put(USE_MAPS, false);
        }
        try (JsonReader jr = new JsonReader(inputStream, optionalArgs, maxDepth);){
            Object object = jr.readObject();
            return (T)object;
        }
    }

    @Deprecated
    public static <T> T jsonToJava(InputStream inputStream, Map<String, Object> optionalArgs) {
        return JsonReader.jsonToJava(inputStream, optionalArgs, 1000);
    }

    @Deprecated
    public static Map jsonToMaps(String json, int maxDepth) {
        return JsonReader.jsonToMaps(json, new HashMap<String, Object>(), maxDepth);
    }

    @Deprecated
    public static Map jsonToMaps(String json) {
        return JsonReader.jsonToMaps(json, new HashMap<String, Object>(), 1000);
    }

    @Deprecated
    public static Map jsonToMaps(String json, Map<String, Object> optionalArgs, int maxDepth) {
        if (json == null) {
            return null;
        }
        return JsonReader.jsonToMaps(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), optionalArgs, maxDepth);
    }

    @Deprecated
    public static Map jsonToMaps(String json, Map<String, Object> optionalArgs) {
        return JsonReader.jsonToMaps(json, optionalArgs, 1000);
    }

    @Deprecated
    public static Map jsonToMaps(InputStream inputStream, Map<String, Object> optionalArgs, int maxDepth) {
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        optionalArgs.put(USE_MAPS, true);
        try (JsonReader jr = new JsonReader(inputStream, optionalArgs, maxDepth);){
            Map map = JsonReader.adjustOutputMap(jr.readObject());
            return map;
        }
    }

    @Deprecated
    public static Map jsonToMaps(InputStream inputStream, Map<String, Object> optionalArgs) {
        return JsonReader.jsonToMaps(inputStream, optionalArgs, 1000);
    }

    public static <T> T toMaps(String json) {
        return JsonReader.toMaps(json, new ReadOptionsBuilder().build());
    }

    public static <T> T toMaps(String json, ReadOptions readOptions) {
        if (json == null) {
            return null;
        }
        return JsonReader.toMaps(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), readOptions);
    }

    public static <T> T toMaps(InputStream inputStream, ReadOptions readOptions) {
        Convention.throwIfNull(inputStream, "inputStream cannot be null");
        Convention.throwIfNull(readOptions, "readOptions cannot be null");
        try (JsonReader jr = new JsonReader(inputStream, readOptions.ensureUsingMaps());){
            Object object = jr.readObject();
            return (T)object;
        }
    }

    @Deprecated
    private static Map adjustOutputMap(Object ret) {
        if (ret instanceof Map) {
            return (Map)ret;
        }
        if (ret != null && ret.getClass().isArray()) {
            JsonObject retMap = new JsonObject();
            retMap.put("@items", ret);
            return retMap;
        }
        JsonObject retMap = new JsonObject();
        retMap.put("@items", new Object[]{ret});
        return retMap;
    }

    @Deprecated
    public JsonReader(int maxDepth) {
        this.args.put(USE_MAPS, false);
        this.args.put(CLASSLOADER, JsonReader.class.getClassLoader());
        this.args.put(JSON_READER, this);
        this.readOptions = ReadOptionsBuilder.fromMap(this.args).withMaxDepth(maxDepth).build();
        this.input = null;
        this.parser = null;
        DefaultReferenceTracker references = new DefaultReferenceTracker();
        this.resolver = this.readOptions.isUsingMaps() ? new MapResolver(this.readOptions, references) : new ObjectResolver(this.readOptions, references);
        this.args.put(OBJECT_RESOLVER, this.resolver);
        ReaderContext.instance().initialize(this);
    }

    @Deprecated
    public JsonReader() {
        this(1000);
    }

    @Deprecated
    public JsonReader(InputStream inputStream, int maxDepth) {
        this(inputStream, false, maxDepth);
    }

    @Deprecated
    public JsonReader(InputStream inputStream) {
        this(inputStream, 1000);
    }

    @Deprecated
    public JsonReader(Map<String, Object> optionalArgs, int maxDepth) {
        this((InputStream)new ByteArrayInputStream(new byte[0]), optionalArgs, maxDepth);
    }

    @Deprecated
    public JsonReader(Map<String, Object> optionalArgs) {
        this(optionalArgs, 1000);
    }

    @Deprecated
    static Map makeArgMap(Map<String, Object> args, boolean useMaps) {
        args.put(USE_MAPS, useMaps);
        return args;
    }

    protected FastReader getReader(InputStream inputStream) {
        return new FastReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8), 8192, 10);
    }

    @Deprecated
    public JsonReader(InputStream inputStream, boolean useMaps, int maxDepth) {
        this(inputStream, (Map<String, Object>)JsonReader.makeArgMap(new HashMap<String, Object>(), useMaps), maxDepth);
    }

    @Deprecated
    public JsonReader(InputStream inputStream, boolean useMaps) {
        this(inputStream, useMaps, 1000);
    }

    @Deprecated
    public JsonReader(InputStream inputStream, Map<String, Object> optionalArgs, int maxDepth) {
        this.args.putAll((Map<String, Object>)(optionalArgs == null ? new HashMap<String, Object>() : optionalArgs));
        this.args.put(JSON_READER, this);
        this.readOptions = ReadOptionsBuilder.fromMap(optionalArgs).withMaxDepth(maxDepth).build();
        DefaultReferenceTracker references = new DefaultReferenceTracker();
        this.resolver = this.readOptions.isUsingMaps() ? new MapResolver(this.readOptions, references) : new ObjectResolver(this.readOptions, references);
        this.input = this.getReader(inputStream);
        this.parser = new JsonParser(this.input, this.readOptions, (ReferenceTracker)references);
        this.args.put(OBJECT_RESOLVER, this.resolver);
        ReaderContext.instance().initialize(this);
    }

    @Deprecated
    public JsonReader(InputStream inputStream, Map<String, Object> optionalArgs) {
        this(inputStream, optionalArgs, 1000);
    }

    @Deprecated
    public JsonReader(String json, Map<String, Object> optionalArgs, int maxDepth) {
        this(json.getBytes(StandardCharsets.UTF_8), optionalArgs, maxDepth);
    }

    @Deprecated
    public JsonReader(String json, Map<String, Object> optionalArgs) {
        this(json, optionalArgs, 1000);
    }

    @Deprecated
    public JsonReader(byte[] inp, Map<String, Object> optionalArgs, int maxDepth) {
        this((InputStream)new ByteArrayInputStream(inp), optionalArgs, maxDepth);
    }

    @Deprecated
    public JsonReader(byte[] inp, Map<String, Object> optionalArgs) {
        this(inp, optionalArgs, 1000);
    }

    public JsonReader(String json) {
        this(json, new ReadOptionsBuilder().build());
    }

    public JsonReader(String json, ReadOptions readOptions) {
        this(json.getBytes(StandardCharsets.UTF_8), readOptions);
    }

    public JsonReader(byte[] bytes, ReadOptions readOptions) {
        this((InputStream)new ByteArrayInputStream(bytes), readOptions);
    }

    public JsonReader(InputStream inp, ReadOptions readOptions) {
        this(inp, readOptions, new DefaultReferenceTracker());
    }

    public JsonReader(InputStream input, ReadOptions readOptions, ReferenceTracker references) {
        this.args.putAll(readOptions.toMap());
        this.args.put(JSON_READER, this);
        this.readOptions = readOptions;
        this.input = this.getReader(input);
        this.resolver = this.useMaps() ? new MapResolver(readOptions, references) : new ObjectResolver(readOptions, references);
        this.parser = new JsonParser(this.input, this.readOptions, references);
        ReaderContext.instance().initialize(this);
    }

    public JsonReader(ReadOptions options) {
        this(new byte[0], options);
    }

    public Object readObject() {
        Object graph;
        Object o;
        int maxDepth = this.readOptions.getMaxDepth();
        JsonObject root = new JsonObject();
        try {
            o = this.parser.readValue(root, true);
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException("error parsing JSON value", e);
        }
        if (o instanceof Object[]) {
            root.setType(Object[].class.getName());
            root.setTarget(o);
            root.put("@items", o);
            graph = this.convertParsedMapsToJava(root);
        } else {
            Object object = graph = o instanceof JsonObject ? this.convertParsedMapsToJava((JsonObject)o) : o;
        }
        if (this.useMaps()) {
            return o;
        }
        return graph;
    }

    @Deprecated
    public Object jsonObjectsToJava(JsonObject root) {
        this.getArgs().put(USE_MAPS, false);
        ReadOptions options = this.readOptions.ensureUsingObjects();
        ReaderContext.instance().initialize(this);
        return this.convertParsedMapsToJava(root);
    }

    protected boolean useMaps() {
        return this.readOptions.isUsingMaps();
    }

    public ClassLoader getClassLoader() {
        return this.readOptions.getClassLoader();
    }

    public <T> T reentrantConvertParsedMapsToJava(JsonObject root, Class<T> hint) {
        Object graph;
        if (root == null) {
            return null;
        }
        if (root.isReference()) {
            root = this.resolver.getReferences().get(root);
        }
        if (root.isFinished) {
            graph = root.target;
        } else {
            Object instance = this.resolver.createInstance(hint, root);
            graph = root.isFinished ? instance : this.resolver.convertMapsToObjects(root);
        }
        return (T)graph;
    }

    protected Object convertParsedMapsToJava(JsonObject root) {
        try {
            Object object = this.reentrantConvertParsedMapsToJava(root, Object.class);
            return object;
        }
        catch (Exception e) {
            MetaUtils.safelyIgnoreException(() -> this.close());
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
        finally {
            this.resolver.cleanup();
        }
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input != null) {
            return msg + "\nLast read: " + this.input.getLastSnippet() + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol();
        }
        return msg;
    }

    @Deprecated
    public Map<String, Object> getArgs() {
        return this.args;
    }

    public static void setAllowNanAndInfinity(boolean allowNanAndInfinity) {
        JsonReader.allowNanAndInfinity = allowNanAndInfinity;
    }

    public static boolean isAllowNanAndInfinity() {
        return allowNanAndInfinity;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    private static class DefaultReferenceTracker
    implements ReferenceTracker {
        final Map<Long, JsonObject> references = new HashMap<Long, JsonObject>();

        private DefaultReferenceTracker() {
        }

        @Override
        public JsonObject put(Long l, JsonObject o) {
            return this.references.put(l, o);
        }

        @Override
        public void clear() {
            this.references.clear();
        }

        @Override
        public int size() {
            return this.references.size();
        }

        @Override
        public JsonObject get(JsonObject jObj) {
            if (!jObj.isReference()) {
                return jObj;
            }
            return this.get(jObj.getReferenceId());
        }

        @Override
        public JsonObject get(Long id) {
            JsonObject target = this.references.get(id);
            if (target == null) {
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            while (target.isReference()) {
                id = target.getReferenceId();
                if ((target = this.references.get(id)) != null) continue;
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            return target;
        }
    }

    public static class MapFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class<?> c, JsonObject jObj) {
            if (SortedMap.class.isAssignableFrom(c)) {
                return new TreeMap();
            }
            if (Map.class.isAssignableFrom(c)) {
                return new LinkedHashMap();
            }
            throw new JsonIoException("MapFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static class CollectionFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class<?> c, JsonObject jObj) {
            if (List.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(c)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(c)) {
                return new LinkedHashSet();
            }
            if (Collection.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            throw new JsonIoException("CollectionFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    @Deprecated
    public static interface JsonClassReaderEx
    extends JsonClassReader {

        @Deprecated
        public static class Support {
            @Deprecated
            public static JsonReader getReader(Map<String, Object> args) {
                return ReaderContext.instance().getReader();
            }
        }
    }

    public static interface JsonClassReader
    extends JsonClassReaderBase {
        default public Object read(Object jOb, Deque<JsonObject> stack, ReadOptions readOptions) {
            return this.read(jOb, stack, readOptions.toMap(), ReaderContext.instance().getReader());
        }

        @Deprecated
        default public Object read(Object jOb, Deque<JsonObject> stack, Map<String, Object> args, JsonReader reader) {
            return this.read(jOb, stack, args);
        }

        @Override
        @Deprecated
        default public Object read(Object jOb, Deque<JsonObject> stack, Map<String, Object> args) {
            return this.read(jOb, stack);
        }

        default public Object read(Object jOb, Deque<JsonObject> stack) {
            return null;
        }
    }

    @Deprecated
    public static interface JsonClassReaderBase {
        public Object read(Object var1, Deque<JsonObject> var2, Map<String, Object> var3);
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }

    public static interface ClassFactory {
        default public Object newInstance(Class<?> c, JsonObject jObj) {
            return MetaUtils.newInstance(c, null);
        }

        default public boolean isObjectFinal() {
            return false;
        }

        default public void gatherRemainingValues(JsonObject jObj, List<Object> arguments, Set<String> excludedFields) {
            JsonReader reader = ReaderContext.instance().getReader();
            Convention.throwIfNull(jObj, "JsonObject cannot be null");
            for (Map.Entry entry : jObj.entrySet()) {
                if (excludedFields.contains(entry.getKey().toString())) continue;
                Object o = entry.getValue();
                if (o instanceof JsonObject) {
                    JsonObject sub = (JsonObject)o;
                    Object value = reader.reentrantConvertParsedMapsToJava(sub, MetaUtils.classForName(sub.getType(), reader.getClassLoader()));
                    if (value == null) continue;
                    if (sub.getType() != null) {
                        arguments.add(value);
                        continue;
                    }
                    if (sub.getTargetClass() == null) continue;
                    arguments.add(value);
                    continue;
                }
                if (o == null) continue;
                arguments.add(o);
            }
        }
    }
}

