/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ReaderContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ThrowableFactory
implements JsonReader.ClassFactory {
    private static final String DETAIL_MESSAGE = "detailMessage";
    private static final String CAUSE = "cause";
    private static final String STACK_TRACE = "stackTrace";

    @Override
    public Object newInstance(Class<?> c, JsonObject jObj) {
        Object[] stackTrace;
        JsonReader reader = ReaderContext.instance().getReader();
        HashMap hints = new HashMap();
        String message = (String)jObj.get(DETAIL_MESSAGE);
        Throwable cause = reader.reentrantConvertParsedMapsToJava((JsonObject)jObj.get(CAUSE), Throwable.class);
        if (message != null) {
            hints.computeIfAbsent(String.class, k -> new ArrayList()).add(new MetaUtils.ParameterHint(DETAIL_MESSAGE, message));
        }
        if (cause != null) {
            hints.put(Throwable.class, MetaUtils.listOf(new MetaUtils.ParameterHint(CAUSE, cause)));
        }
        MetaUtils.buildHints(reader, jObj, hints, MetaUtils.setOf(DETAIL_MESSAGE, CAUSE, STACK_TRACE));
        ArrayList<Object> argumentValues = new ArrayList<Object>();
        for (List hint : hints.values()) {
            for (MetaUtils.ParameterHint arg : hint) {
                argumentValues.add(arg.getObject());
            }
        }
        Throwable t = (Throwable)MetaUtils.newInstance(c, argumentValues);
        if (t.getCause() == null && cause != null) {
            t.initCause(cause);
        }
        if ((stackTrace = (Object[])jObj.get(STACK_TRACE)) != null) {
            StackTraceElement[] elements = new StackTraceElement[stackTrace.length];
            for (int i = 0; i < stackTrace.length; ++i) {
                JsonObject stackTraceMap = (JsonObject)stackTrace[i];
                elements[i] = stackTraceMap == null ? null : reader.reentrantConvertParsedMapsToJava(stackTraceMap, StackTraceElement.class);
            }
            t.setStackTrace(elements);
        }
        return t;
    }

    @Override
    public boolean isObjectFinal() {
        return false;
    }
}

