/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class LocalDateTimeFactory
extends AbstractTemporalFactory<LocalDateTime> {
    public LocalDateTimeFactory(DateTimeFormatter dateFormatter) {
        super(dateFormatter);
    }

    public LocalDateTimeFactory() {
        super(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    @Override
    protected LocalDateTime fromString(String s) {
        try {
            return LocalDateTime.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            Date date = Readers.DateReader.parseDate(s);
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
    }

    @Override
    protected LocalDateTime fromNumber(Number l) {
        return LocalDateTime.from(Instant.ofEpochMilli(l.longValue()));
    }

    @Override
    protected LocalDateTime fromJsonObject(JsonObject job) {
        String date = (String)job.get("date");
        String time = (String)job.get("time");
        if (date == null || time == null) {
            throw new IllegalArgumentException("'date' and 'time' or 'value' are required fields when parsing object using LocalDateTimeFactory");
        }
        LocalDate localDate = LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalTime localTime = LocalTime.parse(time, DateTimeFormatter.ISO_LOCAL_TIME);
        return LocalDateTime.of(localDate, localTime);
    }
}

