/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReferenceTracker;
import com.cedarsoftware.util.io.Resolver;
import java.util.HashMap;
import java.util.Map;

public class ReaderContext {
    private static ThreadLocal<ReaderContext> conversionContext = ThreadLocal.withInitial(ReaderContext::new);
    private final ReferenceTracker referenceTracker = new ReferenceTrackerImpl();
    private JsonReader reader;
    private ReadOptions readOptions;

    public static ReaderContext instance() {
        return conversionContext.get();
    }

    private ReaderContext() {
    }

    public void clearAll() {
        this.referenceTracker.clear();
    }

    public void initialize(ReadOptions readOptions, JsonReader reader) {
        this.referenceTracker.clear();
        this.reader = reader;
        this.readOptions = readOptions;
    }

    public Resolver getResolver() {
        return this.reader.getResolver();
    }

    public ReferenceTracker getReferenceTracker() {
        return this.referenceTracker;
    }

    public JsonReader getReader() {
        return this.reader;
    }

    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    private class ReferenceTrackerImpl
    implements ReferenceTracker {
        final Map<Long, JsonObject> references = new HashMap<Long, JsonObject>();

        private ReferenceTrackerImpl() {
        }

        @Override
        public JsonObject put(Long l, JsonObject o) {
            return this.references.put(l, o);
        }

        @Override
        public void clear() {
            this.references.clear();
        }

        @Override
        public int size() {
            return this.references.size();
        }

        @Override
        public JsonObject get(JsonObject jObj) {
            if (!jObj.isReference()) {
                return jObj;
            }
            return this.get(jObj.getReferenceId());
        }

        @Override
        public JsonObject get(Long id) {
            JsonObject target = this.references.get(id);
            if (target == null) {
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            while (target.isReference()) {
                id = target.getReferenceId();
                if ((target = this.references.get(id)) != null) continue;
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            return target;
        }
    }
}

