/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReadOptionsBuilder {
    private final ConcurrentMap<String, Object> readOptions = new ConcurrentHashMap<String, Object>();

    public ReadOptionsBuilder setUnknownTypeClass(Class<?> c) {
        this.readOptions.put("UNKNOWN_OBJECT", c.getName());
        return this;
    }

    public ReadOptionsBuilder setMissingFieldHandler(JsonReader.MissingFieldHandler missingFieldHandler) {
        this.readOptions.put("MISSING_FIELD_HANDLER", missingFieldHandler);
        return this;
    }

    public ReadOptionsBuilder failOnUnknownType() {
        this.readOptions.put("FAIL_ON_UNKNOWN_TYPE", Boolean.TRUE);
        return this;
    }

    public ReadOptionsBuilder withClassLoader(ClassLoader classLoader) {
        this.readOptions.put("CLASSLOADER", classLoader);
        return this;
    }

    public ReadOptionsBuilder returnAsMaps() {
        this.readOptions.put("USE_MAPS", Boolean.TRUE);
        return this;
    }

    public ReadOptionsBuilder withCustomTypeName(Class<?> type, String newTypeName) {
        return this.withCustomTypeName(type.getName(), newTypeName);
    }

    public ReadOptionsBuilder withCustomTypeName(String type, String newTypeName) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "TYPE_NAME_MAP").put(type, newTypeName);
        return this;
    }

    public ReadOptionsBuilder withCustomTypeNameMap(Map<String, String> map) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "TYPE_NAME_MAP").putAll(map);
        return this;
    }

    public ReadOptionsBuilder withCustomReader(Class<?> c, JsonReader.JsonClassReader reader) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "CUSTOM_READERS").put(c, reader);
        return this;
    }

    public ReadOptionsBuilder withCustomReaders(Map<? extends Class<?>, ? extends JsonReader.JsonClassReader> map) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "CUSTOM_READERS").putAll(map);
        return this;
    }

    public ReadOptionsBuilder withNonCustomizableClass(Class<?> c) {
        MetaUtils.computeSetIfAbsent(this.readOptions, "NOT_CUSTOM_READERS").add(c);
        return this;
    }

    public ReadOptionsBuilder withNonCustomizableClasses(Collection<Class<?>> collection) {
        MetaUtils.computeSetIfAbsent(this.readOptions, "NOT_CUSTOM_READERS").addAll(collection);
        return this;
    }

    public ReadOptionsBuilder withClassFactory(Class<?> type, JsonReader.ClassFactory factory) {
        return this.withClassFactory(type.getName(), factory);
    }

    public ReadOptionsBuilder withClassFactories(Map<String, ? extends JsonReader.ClassFactory> factories) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "FACTORIES").putAll(factories);
        return this;
    }

    public ReadOptionsBuilder withClassFactory(String type, JsonReader.ClassFactory factory) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "FACTORIES").put(type, factory);
        return this;
    }

    public Map<String, Object> build() {
        return this.readOptions;
    }
}

