/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.ArgumentHelper;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ObjectResolver;
import com.cedarsoftware.util.io.Writers;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JsonWriter
implements Closeable,
Flushable {
    public static final String JSON_WRITER = "JSON_WRITER";
    public static final String CUSTOM_WRITER_MAP = "CUSTOM_WRITERS";
    public static final String NOT_CUSTOM_WRITER_MAP = "NOT_CUSTOM_WRITERS";
    public static final String DATE_FORMAT = "DATE_FORMAT";
    public static final String LOCAL_DATE_FORMAT = "LOCAL_DATE_FORMAT";
    public static final String DATE_AS_TIMESTAMP = "DATE_AS_TIMESTAMP";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String ISO_8601_FORMAT = "uuuu-MM-dd";
    public static final String TYPE = "TYPE";
    public static final String PRETTY_PRINT = "PRETTY_PRINT";
    public static final String FIELD_SPECIFIERS = "FIELD_SPECIFIERS";
    public static final String FIELD_NAME_BLACK_LIST = "FIELD_NAME_BLACK_LIST";
    private static final String FIELD_BLACK_LIST = "FIELD_BLACK_LIST";
    public static final String ENUM_PUBLIC_ONLY = "ENUM_PUBLIC_ONLY";
    public static final String WRITE_LONGS_AS_STRINGS = "WLAS";
    public static final String TYPE_NAME_MAP = "TYPE_NAME_MAP";
    public static final String SHORT_META_KEYS = "SHORT_META_KEYS";
    public static final String SKIP_NULL_FIELDS = "SKIP_NULL";
    public static final String CLASSLOADER = "CLASSLOADER";
    public static final String WRITE_ENUMS_AS_OBJECTS = "WRITE_ENUMS_AS_OBJECTS";
    public static final String FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS = "FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS";
    private static Map<Class<?>, JsonClassWriter> BASE_WRITERS;
    private final Map<Class<?>, JsonClassWriter> writers = new HashMap(BASE_WRITERS);
    private static Set<Class<?>> BASE_STATICALLY_INITIALIZED_CLASSES;
    private final Set<Class<?>> staticallyInitializedClasses = new HashSet(BASE_STATICALLY_INITIALIZED_CLASSES);
    private final Map<Class<?>, JsonClassWriter> writerCache = new HashMap();
    private final Set<Class<?>> notCustom = new HashSet();
    public static final Set<String> EMPTY_SET;
    private static final Object[] byteStrings;
    private static final String NEW_LINE;
    private static final Long ZERO;
    private static final NullClass nullWriter;
    private static final JsonClassWriter enumAsStringWriter;
    private final Map<Object, Long> objVisited = new IdentityHashMap<Object, Long>();
    private final Map<Object, Long> objsReferenced = new IdentityHashMap<Object, Long>();
    private final Writer out;
    private Map<String, String> typeNameMap = null;
    private boolean shortMetaKeys = false;
    private boolean neverShowType = false;
    private boolean alwaysShowType = false;
    private boolean isPrettyPrint = false;
    private boolean isEnumPublicOnly = false;
    private boolean writeLongsAsStrings = false;
    private boolean skipNullFields = false;
    private boolean forceMapFormatWithKeyArrays = false;
    private JsonClassWriter enumWriter = enumAsStringWriter;
    private long identity = 1L;
    private int depth = 0;
    final Map<String, Object> args = new HashMap<String, Object>();
    private static volatile boolean allowNanAndInfinity;

    public static boolean isAllowNanAndInfinity() {
        return allowNanAndInfinity;
    }

    public static void setAllowNanAndInfinity(boolean lenient) {
        allowNanAndInfinity = lenient;
    }

    protected String getSubstituteTypeNameIfExists(String typeName) {
        if (this.typeNameMap == null) {
            return null;
        }
        return this.typeNameMap.get(typeName);
    }

    protected String getSubstituteTypeName(String typeName) {
        if (this.typeNameMap == null) {
            return typeName;
        }
        String shortName = this.typeNameMap.get(typeName);
        return shortName == null ? typeName : shortName;
    }

    public static String objectToJson(Object item) {
        return JsonWriter.objectToJson(item, null);
    }

    public static String objectToJson(Object item, Map<String, Object> optionalArgs) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            JsonWriter writer = new JsonWriter(stream, optionalArgs);
            writer.write(item);
            writer.close();
            return new String(stream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to convert object to JSON", e);
        }
    }

    public static String formatJson(String json) {
        return JsonWriter.formatJson(json, null, null);
    }

    public static String formatJson(String json, Map readingArgs, Map writingArgs) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (readingArgs != null) {
            args.putAll(readingArgs);
        }
        args.put("USE_MAPS", true);
        Object obj = JsonReader.jsonToJava(json, args);
        args.clear();
        if (writingArgs != null) {
            args.putAll(writingArgs);
        }
        args.put(PRETTY_PRINT, true);
        return JsonWriter.objectToJson(obj, args);
    }

    public JsonWriter(OutputStream out) {
        this(out, null);
    }

    public JsonWriter(OutputStream out, Map<String, Object> optionalArgs) {
        Field f;
        Map<String, Field> classFields;
        ArrayList<Field> newList;
        List fields;
        Class c;
        HashMap copy;
        Collection notCustomClasses;
        Map customWriters;
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        this.args.putAll(optionalArgs);
        this.args.put(JSON_WRITER, this);
        this.typeNameMap = (Map)this.args.get(TYPE_NAME_MAP);
        this.shortMetaKeys = ArgumentHelper.isTrue(this.args.get(SHORT_META_KEYS));
        this.alwaysShowType = ArgumentHelper.isTrue(this.args.get(TYPE));
        this.neverShowType = Boolean.FALSE.equals(this.args.get(TYPE)) || "false".equals(this.args.get(TYPE));
        this.isPrettyPrint = ArgumentHelper.isTrue(this.args.get(PRETTY_PRINT));
        this.writeLongsAsStrings = ArgumentHelper.isTrue(this.args.get(WRITE_LONGS_AS_STRINGS));
        this.skipNullFields = ArgumentHelper.isTrue(this.args.get(SKIP_NULL_FIELDS));
        this.isEnumPublicOnly = ArgumentHelper.isTrue(this.args.get(ENUM_PUBLIC_ONLY));
        this.enumWriter = ArgumentHelper.isTrue(this.args.get(WRITE_ENUMS_AS_OBJECTS)) ? new Writers.EnumAsObjectWriter(this.isEnumPublicOnly) : enumAsStringWriter;
        this.forceMapFormatWithKeyArrays = ArgumentHelper.isTrue(this.args.get(FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS));
        if (!this.args.containsKey(CLASSLOADER)) {
            this.args.put(CLASSLOADER, JsonWriter.class.getClassLoader());
        }
        if ((customWriters = (Map)this.args.get(CUSTOM_WRITER_MAP)) != null) {
            this.writers.putAll(customWriters);
        }
        if ((notCustomClasses = (Collection)this.args.get(NOT_CUSTOM_WRITER_MAP)) != null) {
            this.notCustom.addAll(notCustomClasses);
        }
        if (optionalArgs.containsKey(FIELD_SPECIFIERS)) {
            Map specifiers = (Map)this.args.get(FIELD_SPECIFIERS);
            copy = new HashMap();
            for (Map.Entry entry : specifiers.entrySet()) {
                c = (Class)entry.getKey();
                fields = (List)entry.getValue();
                newList = new ArrayList<Field>(fields.size());
                classFields = MetaUtils.getDeepDeclaredFields(c);
                for (String field : fields) {
                    f = classFields.get(field);
                    if (f == null) {
                        throw new JsonIoException("Unable to locate field: " + field + " on class: " + c.getName() + ". Make sure the fields in the FIELD_SPECIFIERS map existing on the associated class.");
                    }
                    newList.add(f);
                }
                copy.put(c, newList);
            }
            this.args.put(FIELD_SPECIFIERS, copy);
        } else {
            this.args.put(FIELD_SPECIFIERS, new HashMap());
        }
        if (optionalArgs.containsKey(FIELD_NAME_BLACK_LIST)) {
            Map blackList = (Map)this.args.get(FIELD_NAME_BLACK_LIST);
            copy = new HashMap();
            for (Map.Entry entry : blackList.entrySet()) {
                c = (Class)entry.getKey();
                fields = (List)entry.getValue();
                newList = new ArrayList(fields.size());
                classFields = MetaUtils.getDeepDeclaredFields(c);
                for (String field : fields) {
                    f = classFields.get(field);
                    if (f == null) {
                        throw new JsonIoException("Unable to locate field: " + field + " on class: " + c.getName() + ". Make sure the fields in the FIELD_NAME_BLACK_LIST map existing on the associated class.");
                    }
                    newList.add(f);
                }
                copy.put(c, newList);
            }
            this.args.put(FIELD_BLACK_LIST, copy);
        } else {
            this.args.put(FIELD_BLACK_LIST, new HashMap());
        }
        this.out = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    ClassLoader getClassLoader() {
        return (ClassLoader)this.args.get(CLASSLOADER);
    }

    public void tabIn() throws IOException {
        this.tab(this.out, 1);
    }

    public void newLine() throws IOException {
        this.tab(this.out, 0);
    }

    public void tabOut() throws IOException {
        this.tab(this.out, -1);
    }

    private void tab(Writer output, int delta) throws IOException {
        if (!this.isPrettyPrint) {
            return;
        }
        output.write(NEW_LINE);
        this.depth += delta;
        for (int i = 0; i < this.depth; ++i) {
            output.write("  ");
        }
    }

    public boolean writeIfMatching(Object o, boolean showType, Writer output) {
        Class<?> c;
        if (this.neverShowType) {
            showType = false;
        }
        if (this.notCustom.contains(c = o.getClass())) {
            return false;
        }
        try {
            return this.writeCustom(c, o, showType, output);
        }
        catch (IOException e) {
            throw new JsonIoException("Unable to write custom formatted object:", e);
        }
    }

    public boolean writeArrayElementIfMatching(Class<?> arrayComponentClass, Object o, boolean showType, Writer output) {
        if (!o.getClass().isAssignableFrom(arrayComponentClass) || this.notCustom.contains(o.getClass())) {
            return false;
        }
        try {
            return this.writeCustom(arrayComponentClass, o, showType, output);
        }
        catch (IOException e) {
            throw new JsonIoException("Unable to write custom formatted object as array element:", e);
        }
    }

    protected boolean writeCustom(Class<?> arrayComponentClass, Object o, boolean showType, Writer output) throws IOException {
        JsonClassWriter closestWriter;
        if (this.neverShowType) {
            showType = false;
        }
        if ((closestWriter = this.getCustomWriter(arrayComponentClass)) == null) {
            return false;
        }
        if (this.writeOptionalReference(o)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(o);
        if (closestWriter.hasPrimitiveForm(this.args) && (!referenced && !showType || closestWriter instanceof Writers.JsonStringWriter)) {
            closestWriter.writePrimitiveForm(o, output, this.args);
            return true;
        }
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(this.getId(o));
            if (showType) {
                output.write(44);
                this.newLine();
            }
        }
        if (showType) {
            this.writeType(o, output);
        }
        if (referenced || showType) {
            output.write(44);
            this.newLine();
        }
        closestWriter.write(o, showType || referenced, output, this.args);
        this.tabOut();
        output.write(125);
        return true;
    }

    private JsonClassWriter getCustomWriter(Class<?> c) {
        JsonClassWriter writer = this.writerCache.get(c);
        if (writer == null) {
            writer = this.forceGetCustomWriter(c);
            this.writerCache.put(c, writer);
        }
        if (writer != nullWriter) {
            return writer;
        }
        if (this.isEnumPublicOnly) {
            return null;
        }
        return MetaUtils.getClassIfEnum(c).isPresent() ? this.enumWriter : null;
    }

    private JsonClassWriter forceGetCustomWriter(Class<?> c) {
        JsonClassWriter closestWriter = nullWriter;
        int minDistance = Integer.MAX_VALUE;
        for (Map.Entry<Class<?>, JsonClassWriter> entry : this.writers.entrySet()) {
            Class<?> clz = entry.getKey();
            if (clz == c) {
                return entry.getValue();
            }
            int distance = MetaUtils.getDistance(clz, c);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestWriter = entry.getValue();
        }
        return closestWriter;
    }

    public void addWriter(Class<?> c, JsonClassWriter writer) {
        this.writers.put(c, writer);
    }

    public static void addWriterPermanent(Class<?> c, JsonClassWriter writer) {
        BASE_WRITERS.put(c, writer);
    }

    public void addNotCustomWriter(Class<?> c) {
        this.notCustom.add(c);
    }

    public static void addStaticallyInitializedClasses(Class<?> c) {
        BASE_STATICALLY_INITIALIZED_CLASSES.add(c);
    }

    public void write(Object obj) {
        this.traceReferences(obj);
        this.objVisited.clear();
        try {
            this.writeImpl(obj, true);
        }
        catch (Exception e) {
            throw new JsonIoException("Error writing object to JSON:", e);
        }
        this.flush();
        this.objVisited.clear();
        this.objsReferenced.clear();
    }

    protected void traceReferences(Object root) {
        if (root == null) {
            return;
        }
        Map fieldSpecifiers = (Map)this.args.get(FIELD_SPECIFIERS);
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.addFirst(root);
        Map<Object, Long> visited = this.objVisited;
        Map<Object, Long> referenced = this.objsReferenced;
        while (!stack.isEmpty()) {
            Class<?> clazz;
            Object obj = stack.removeFirst();
            if (!MetaUtils.isLogicalPrimitive(obj.getClass())) {
                Long id = visited.get(obj);
                if (id != null) {
                    if (!id.equals(ZERO)) continue;
                    id = this.identity++;
                    visited.put(obj, id);
                    referenced.put(obj, id);
                    continue;
                }
                visited.put(obj, ZERO);
            }
            if ((clazz = obj.getClass()).isArray()) {
                if (MetaUtils.isLogicalPrimitive(clazz.getComponentType())) continue;
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(obj, i);
                    if (o == null) continue;
                    stack.addFirst(o);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                try {
                    Map map = (Map)obj;
                    Iterator i = map.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry item;
                        Map.Entry entry = item = i.next();
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (value != null && !MetaUtils.isLogicalPrimitive(value.getClass())) {
                            stack.addFirst(value);
                        }
                        if (key == null || MetaUtils.isLogicalPrimitive(key.getClass())) continue;
                        stack.addFirst(key);
                    }
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    continue;
                }
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                for (Object item : (Collection)obj) {
                    if (item == null || MetaUtils.isLogicalPrimitive(item.getClass())) continue;
                    stack.addFirst(item);
                }
                continue;
            }
            if (MetaUtils.isLogicalPrimitive(obj.getClass())) continue;
            this.traceFields(stack, obj, fieldSpecifiers);
        }
    }

    protected void traceFields(Deque<Object> stack, Object obj, Map<Class<?>, List<Field>> fieldSpecifiers) {
        Collection<Field> fields = JsonWriter.getFieldsUsingSpecifier(obj.getClass(), fieldSpecifiers);
        List<Field> fieldsBySpec = fields;
        if (fields == null) {
            fields = MetaUtils.getDeepDeclaredFields(obj.getClass()).values();
        }
        List<Field> fieldBlackListForClass = JsonWriter.getFieldsUsingSpecifier(obj.getClass(), (Map)this.args.get(FIELD_BLACK_LIST));
        for (Field field : fields) {
            if ((field.getModifiers() & 0x80) != 0 && (fieldsBySpec == null || !fieldsBySpec.contains(field))) continue;
            try {
                Object o;
                if (fieldBlackListForClass != null && fieldBlackListForClass.contains(field) || (o = field.get(obj)) == null || MetaUtils.isLogicalPrimitive(o.getClass())) continue;
                stack.addFirst(o);
            }
            catch (Exception exception) {}
        }
    }

    private static List<Field> getFieldsUsingSpecifier(Class<?> classBeingWritten, Map<Class<?>, List<Field>> fieldSpecifiers) {
        Iterator<Map.Entry<Class<?>, List<Field>>> i = fieldSpecifiers.entrySet().iterator();
        int minDistance = Integer.MAX_VALUE;
        List<Field> fields = null;
        while (i.hasNext()) {
            Map.Entry<Class<?>, List<Field>> entry = i.next();
            Class<?> c = entry.getKey();
            if (c == classBeingWritten) {
                return entry.getValue();
            }
            int distance = MetaUtils.getDistance(c, classBeingWritten);
            if (distance >= minDistance) continue;
            minDistance = distance;
            fields = entry.getValue();
        }
        return fields;
    }

    private boolean writeOptionalReference(Object obj) throws IOException {
        if (obj == null || MetaUtils.isLogicalPrimitive(obj.getClass())) {
            return false;
        }
        Writer output = this.out;
        if (this.objVisited.containsKey(obj)) {
            String id = this.getId(obj);
            if (id == null) {
                return false;
            }
            output.write(this.shortMetaKeys ? "{\"@r\":" : "{\"@ref\":");
            output.write(id);
            output.write(125);
            return true;
        }
        this.objVisited.put(obj, null);
        return false;
    }

    public void writeImpl(Object obj, boolean showType) throws IOException {
        this.writeImpl(obj, showType, true, true);
    }

    public void writeImpl(Object obj, boolean showType, boolean allowRef, boolean allowCustom) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        if (obj instanceof ProcessBuilder || obj instanceof Process || obj instanceof ClassLoader || obj instanceof Constructor || obj instanceof Method || obj instanceof Field) {
            this.out.write("null");
            return;
        }
        if (obj == null) {
            this.out.write("null");
            return;
        }
        if (allowCustom && this.writeIfMatching(obj, showType, this.out)) {
            return;
        }
        if (allowRef && this.writeOptionalReference(obj)) {
            return;
        }
        if (obj.getClass().isArray()) {
            this.writeArray(obj, showType);
        } else if (obj instanceof EnumSet) {
            this.writeEnumSet((EnumSet)obj);
        } else if (obj instanceof Collection) {
            this.writeCollection((Collection)obj, showType);
        } else if (obj instanceof JsonObject) {
            JsonObject jObj = (JsonObject)obj;
            if (jObj.isArray()) {
                this.writeJsonObjectArray(jObj, showType);
            } else if (jObj.isCollection()) {
                this.writeJsonObjectCollection(jObj, showType);
            } else if (jObj.isMap()) {
                if (!this.writeJsonObjectMapWithStringKeys(jObj, showType)) {
                    this.writeJsonObjectMap(jObj, showType);
                }
            } else {
                this.writeJsonObjectObject(jObj, showType);
            }
        } else if (obj instanceof Map) {
            if (!this.writeMapWithStringKeys((Map)obj, showType)) {
                this.writeMap((Map)obj, showType);
            }
        } else {
            this.writeObject(obj, showType, false);
        }
    }

    private void writeId(String id) throws IOException {
        this.out.write(this.shortMetaKeys ? "\"@i\":" : "\"@id\":");
        this.out.write(id == null ? "0" : id);
    }

    private void writeType(Object obj, Writer output) throws IOException {
        if (this.neverShowType) {
            return;
        }
        output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
        Class<?> c = obj.getClass();
        String typeName = c.getName();
        String shortName = this.getSubstituteTypeNameIfExists(typeName);
        if (shortName != null) {
            output.write(shortName);
            output.write(34);
            return;
        }
        String s = c.getName();
        if (s.equals("java.lang.Boolean")) {
            output.write("boolean");
        } else if (s.equals("java.lang.Byte")) {
            output.write("byte");
        } else if (s.equals("java.lang.Character")) {
            output.write("char");
        } else if (s.equals("java.lang.Class")) {
            output.write("class");
        } else if (s.equals("java.lang.Double")) {
            output.write("double");
        } else if (s.equals("java.lang.Float")) {
            output.write("float");
        } else if (s.equals("java.lang.Integer")) {
            output.write("int");
        } else if (s.equals("java.lang.Long")) {
            output.write("long");
        } else if (s.equals("java.lang.Short")) {
            output.write("short");
        } else if (s.equals("java.lang.String")) {
            output.write("string");
        } else if (s.equals("java.util.Date")) {
            output.write("date");
        } else {
            output.write(c.getName());
        }
        output.write(34);
    }

    private void writePrimitive(Object obj, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        if (obj instanceof Character) {
            JsonWriter.writeJsonUtf8String(String.valueOf(obj), this.out);
        } else if (obj instanceof Long && this.writeLongsAsStrings) {
            if (showType) {
                this.out.write(this.shortMetaKeys ? "{\"@t\":\"" : "{\"@type\":\"");
                this.out.write(this.getSubstituteTypeName("long"));
                this.out.write("\",\"value\":\"");
                this.out.write(obj.toString());
                this.out.write("\"}");
            } else {
                this.out.write(34);
                this.out.write(obj.toString());
                this.out.write(34);
            }
        } else if (!JsonWriter.isAllowNanAndInfinity() && obj instanceof Double && (Double.isNaN((Double)obj) || Double.isInfinite((Double)obj))) {
            this.out.write("null");
        } else if (!JsonWriter.isAllowNanAndInfinity() && obj instanceof Float && (Float.isNaN(((Float)obj).floatValue()) || Float.isInfinite(((Float)obj).floatValue()))) {
            this.out.write("null");
        } else {
            this.out.write(obj.toString());
        }
    }

    private void writeArray(Object array, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        Class<?> arrayType = array.getClass();
        int len = Array.getLength(array);
        boolean referenced = this.objsReferenced.containsKey(array);
        boolean typeWritten = showType && !arrayType.equals(Object[].class);
        Writer output = this.out;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(this.getId(array));
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            this.writeType(array, output);
            output.write(44);
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.shortMetaKeys ? "\"@e\":[]" : "\"@items\":[]");
                this.tabOut();
                output.write(125);
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        } else {
            output.write(91);
        }
        this.tabIn();
        int lenMinus1 = len - 1;
        if (byte[].class == arrayType) {
            this.writeByteArray((byte[])array, lenMinus1);
        } else if (char[].class == arrayType) {
            JsonWriter.writeJsonUtf8String(new String((char[])array), output);
        } else if (short[].class == arrayType) {
            this.writeShortArray((short[])array, lenMinus1);
        } else if (int[].class == arrayType) {
            this.writeIntArray((int[])array, lenMinus1);
        } else if (long[].class == arrayType) {
            this.writeLongArray((long[])array, lenMinus1);
        } else if (float[].class == arrayType) {
            this.writeFloatArray((float[])array, lenMinus1);
        } else if (double[].class == arrayType) {
            this.writeDoubleArray((double[])array, lenMinus1);
        } else if (boolean[].class == arrayType) {
            this.writeBooleanArray((boolean[])array, lenMinus1);
        } else {
            Class<?> componentClass = array.getClass().getComponentType();
            boolean isPrimitiveArray = MetaUtils.isPrimitive(componentClass);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(array, i);
                if (value == null) {
                    output.write("null");
                } else if (!this.writeArrayElementIfMatching(componentClass, value, false, output)) {
                    if (isPrimitiveArray || value instanceof Boolean || value instanceof Long || value instanceof Double) {
                        this.writePrimitive(value, value.getClass() != componentClass);
                    } else if (this.neverShowType && MetaUtils.isPrimitive(value.getClass())) {
                        this.writePrimitive(value, false);
                    } else {
                        boolean forceType = this.isForceType(value.getClass(), componentClass);
                        this.writeImpl(value, forceType || this.alwaysShowType);
                    }
                }
                if (i == lenMinus1) continue;
                output.write(44);
                this.newLine();
            }
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeBooleanArray(boolean[] booleans, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(booleans[i] ? "true," : "false,");
        }
        output.write(Boolean.toString(booleans[lenMinus1]));
    }

    private void writeDoubleArray(double[] doubles, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(this.doubleToString(doubles[i]));
            output.write(44);
        }
        output.write(this.doubleToString(doubles[lenMinus1]));
    }

    private void writeFloatArray(float[] floats, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(this.floatToString(floats[i]));
            output.write(44);
        }
        output.write(this.floatToString(floats[lenMinus1]));
    }

    private String doubleToString(double d) {
        if (JsonWriter.isAllowNanAndInfinity()) {
            return Double.toString(d);
        }
        return Double.isNaN(d) || Double.isInfinite(d) ? "null" : Double.toString(d);
    }

    private String floatToString(float d) {
        if (JsonWriter.isAllowNanAndInfinity()) {
            return Float.toString(d);
        }
        return Float.isNaN(d) || Float.isInfinite(d) ? "null" : Float.toString(d);
    }

    private void writeLongArray(long[] longs, int lenMinus1) throws IOException {
        Writer output = this.out;
        if (this.writeLongsAsStrings) {
            for (int i = 0; i < lenMinus1; ++i) {
                output.write(34);
                output.write(Long.toString(longs[i]));
                output.write(34);
                output.write(44);
            }
            output.write(34);
            output.write(Long.toString(longs[lenMinus1]));
            output.write(34);
        } else {
            for (int i = 0; i < lenMinus1; ++i) {
                output.write(Long.toString(longs[i]));
                output.write(44);
            }
            output.write(Long.toString(longs[lenMinus1]));
        }
    }

    private void writeIntArray(int[] ints, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(Integer.toString(ints[i]));
            output.write(44);
        }
        output.write(Integer.toString(ints[lenMinus1]));
    }

    private void writeShortArray(short[] shorts, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(Integer.toString(shorts[i]));
            output.write(44);
        }
        output.write(Integer.toString(shorts[lenMinus1]));
    }

    private void writeByteArray(byte[] bytes, int lenMinus1) throws IOException {
        Writer output = this.out;
        Object[] byteStrs = byteStrings;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write((char[])byteStrs[bytes[i] + 128]);
            output.write(44);
        }
        output.write((char[])byteStrs[bytes[lenMinus1] + 128]);
    }

    private void writeCollection(Collection col, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(col);
        boolean isEmpty = col.isEmpty();
        if (referenced || showType) {
            output.write(123);
            this.tabIn();
        } else if (isEmpty) {
            output.write(91);
        }
        this.writeIdAndTypeIfNeeded(col, showType, referenced);
        if (isEmpty) {
            if (referenced || showType) {
                this.tabOut();
                output.write(125);
            } else {
                output.write(93);
            }
            return;
        }
        this.beginCollection(showType, referenced);
        Iterator i = col.iterator();
        this.writeElements(output, i);
        this.tabOut();
        output.write(93);
        if (showType || referenced) {
            this.tabOut();
            output.write("}");
        }
    }

    private void writeElements(Writer output, Iterator i) throws IOException {
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
    }

    private void writeIdAndTypeIfNeeded(Object col, boolean showType, boolean referenced) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        if (referenced) {
            this.writeId(this.getId(col));
        }
        if (showType) {
            if (referenced) {
                this.out.write(44);
                this.newLine();
            }
            this.writeType(col, this.out);
        }
    }

    private void beginCollection(boolean showType, boolean referenced) throws IOException {
        if (showType || referenced) {
            this.out.write(44);
            this.newLine();
            this.out.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        } else {
            this.out.write(91);
        }
        this.tabIn();
    }

    private void writeJsonObjectArray(JsonObject jObj, boolean showType) throws IOException {
        boolean typeWritten;
        if (this.neverShowType) {
            showType = false;
        }
        int len = jObj.getLength();
        String type = jObj.type;
        Class arrayClass = type == null || Object[].class.getName().equals(type) ? Object[].class : MetaUtils.classForName(type, this.getClassLoader());
        Writer output = this.out;
        boolean isObjectArray = Object[].class == arrayClass;
        Class<?> componentClass = arrayClass.getComponentType();
        boolean referenced = this.adjustIfReferenced(jObj);
        boolean bl = typeWritten = showType && !isObjectArray;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(Long.toString(jObj.id));
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(arrayClass.getName()));
            output.write("\",");
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.shortMetaKeys ? "\"@e\":[]" : "\"@items\":[]");
                this.tabOut();
                output.write("}");
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        } else {
            output.write(91);
        }
        this.tabIn();
        Object[] items = (Object[])jObj.get("@items");
        int lenMinus1 = len - 1;
        for (int i = 0; i < len; ++i) {
            Object value = items[i];
            if (value == null) {
                output.write("null");
            } else if (Character.class == componentClass || Character.TYPE == componentClass) {
                JsonWriter.writeJsonUtf8String((String)value, output);
            } else if (value instanceof Boolean || value instanceof Long || value instanceof Double) {
                this.writePrimitive(value, value.getClass() != componentClass);
            } else if (this.neverShowType && MetaUtils.isPrimitive(value.getClass())) {
                this.writePrimitive(value, false);
            } else if (value instanceof String) {
                JsonWriter.writeJsonUtf8String((String)value, output);
            } else if (!this.writeArrayElementIfMatching(componentClass, value, false, output)) {
                boolean forceType = this.isForceType(value.getClass(), componentClass);
                this.writeImpl(value, forceType || this.alwaysShowType);
            }
            if (i == lenMinus1) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeJsonObjectCollection(JsonObject jObj, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        String type = jObj.type;
        Class<?> colClass = MetaUtils.classForName(type, this.getClassLoader());
        boolean referenced = this.adjustIfReferenced(jObj);
        Writer output = this.out;
        int len = jObj.getLength();
        if (referenced || showType || len == 0) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(String.valueOf(jObj.id));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(colClass.getName()));
            output.write(34);
        }
        if (len == 0) {
            this.tabOut();
            output.write(125);
            return;
        }
        this.beginCollection(showType, referenced);
        Object[] items = (Object[])jObj.get("@items");
        int itemsLen = items.length;
        int itemsLenMinus1 = itemsLen - 1;
        for (int i = 0; i < itemsLen; ++i) {
            this.writeCollectionElement(items[i]);
            if (i == itemsLenMinus1) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write("]");
        if (showType || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeJsonObjectMap(JsonObject jObj, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        Writer output = this.out;
        showType = this.emitIdAndTypeIfNeeded(jObj, showType, output);
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType) {
            output.write(44);
            this.newLine();
        }
        this.writeMapToEnd(jObj, output);
    }

    private boolean writeJsonObjectMapWithStringKeys(JsonObject jObj, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        if (this.forceMapFormatWithKeyArrays || !JsonWriter.ensureJsonPrimitiveKeys(jObj)) {
            return false;
        }
        Writer output = this.out;
        this.emitIdAndTypeIfNeeded(jObj, showType, output);
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return true;
        }
        if (showType) {
            output.write(44);
            this.newLine();
        }
        return this.writeMapBody(jObj.entrySet().iterator());
    }

    private boolean emitIdAndTypeIfNeeded(JsonObject jObj, boolean showType, Writer output) throws IOException {
        boolean referenced = this.adjustIfReferenced(jObj);
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            String type;
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            if ((type = jObj.getType()) != null) {
                Class<?> mapClass = MetaUtils.classForName(type, this.getClassLoader());
                output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
                output.write(this.getSubstituteTypeName(mapClass.getName()));
                output.write(34);
            } else {
                showType = false;
            }
        }
        return showType;
    }

    private void writeJsonObjectObject(JsonObject jObj, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.adjustIfReferenced(jObj);
        showType = showType && jObj.type != null;
        Class<?> type = null;
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.id));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(jObj.type));
            output.write(34);
            try {
                type = MetaUtils.classForName(jObj.type, this.getClassLoader());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType || referenced) {
            output.write(44);
            this.newLine();
        }
        Iterator i = jObj.entrySet().iterator();
        boolean first = true;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (this.skipNullFields && entry.getValue() == null) continue;
            if (!first) {
                output.write(44);
                this.newLine();
            }
            first = false;
            String fieldName = (String)entry.getKey();
            output.write(34);
            output.write(fieldName);
            output.write("\":");
            Object value = entry.getValue();
            if (value == null) {
                output.write("null");
                continue;
            }
            if (this.neverShowType && MetaUtils.isPrimitive(value.getClass())) {
                this.writePrimitive(value, false);
                continue;
            }
            if (value instanceof BigDecimal || value instanceof BigInteger) {
                this.writeImpl(value, !JsonWriter.doesValueTypeMatchFieldType(type, fieldName, value));
                continue;
            }
            if (value instanceof Number || value instanceof Boolean) {
                output.write(value.toString());
                continue;
            }
            if (value instanceof String) {
                JsonWriter.writeJsonUtf8String((String)value, output);
                continue;
            }
            if (value instanceof Character) {
                JsonWriter.writeJsonUtf8String(String.valueOf(value), output);
                continue;
            }
            this.writeImpl(value, !JsonWriter.doesValueTypeMatchFieldType(type, fieldName, value));
        }
        this.tabOut();
        output.write(125);
    }

    private boolean adjustIfReferenced(JsonObject jObj) {
        Long idx = this.objsReferenced.get(jObj);
        if (!jObj.hasId() && idx != null && idx > 0L) {
            jObj.id = idx;
        }
        return this.objsReferenced.containsKey(jObj) && jObj.hasId();
    }

    private static boolean doesValueTypeMatchFieldType(Class<?> type, String fieldName, Object value) {
        if (type != null) {
            Map<String, Field> classFields = MetaUtils.getDeepDeclaredFields(type);
            Field field = classFields.get(fieldName);
            return field != null && value.getClass() == field.getType();
        }
        return false;
    }

    private void writeMap(Map map, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(map);
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(this.getId(map));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            this.writeType(map, output);
        }
        if (map.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType || referenced) {
            output.write(44);
            this.newLine();
        }
        this.writeMapToEnd(map, output);
    }

    private void writeMapToEnd(Map map, Writer output) throws IOException {
        output.write(this.shortMetaKeys ? "\"@k\":[" : "\"@keys\":[");
        this.tabIn();
        Iterator<Object> i = map.keySet().iterator();
        this.writeElements(output, i);
        this.tabOut();
        output.write("],");
        this.newLine();
        output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        this.tabIn();
        i = map.values().iterator();
        this.writeElements(output, i);
        this.tabOut();
        output.write(93);
        this.tabOut();
        output.write(125);
    }

    private boolean writeMapWithStringKeys(Map map, boolean showType) throws IOException {
        if (this.neverShowType) {
            showType = false;
        }
        if (this.forceMapFormatWithKeyArrays || !JsonWriter.ensureJsonPrimitiveKeys(map)) {
            return false;
        }
        boolean referenced = this.objsReferenced.containsKey(map);
        this.out.write(123);
        this.tabIn();
        this.writeIdAndTypeIfNeeded(map, showType, referenced);
        if (map.isEmpty()) {
            this.tabOut();
            this.out.write(125);
            return true;
        }
        if (showType || referenced) {
            this.out.write(44);
            this.newLine();
        }
        return this.writeMapBody(map.entrySet().iterator());
    }

    private boolean writeMapBody(Iterator i) throws IOException {
        Writer output = this.out;
        while (i.hasNext()) {
            Map.Entry att2value = (Map.Entry)i.next();
            JsonWriter.writeJsonUtf8String((String)att2value.getKey(), output);
            output.write(":");
            this.writeCollectionElement(att2value.getValue());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(125);
        return true;
    }

    public static boolean ensureJsonPrimitiveKeys(Map map) {
        for (Object o : map.keySet()) {
            if (o instanceof String) continue;
            return false;
        }
        return true;
    }

    private void writeCollectionElement(Object o) throws IOException {
        if (o == null) {
            this.out.write("null");
        } else if (o instanceof Boolean || o instanceof Double) {
            this.writePrimitive(o, false);
        } else if (o instanceof Long) {
            this.writePrimitive(o, this.writeLongsAsStrings);
        } else if (o instanceof String) {
            JsonWriter.writeJsonUtf8String((String)o, this.out);
        } else if (this.neverShowType && MetaUtils.isPrimitive(o.getClass())) {
            this.writePrimitive(o, false);
        } else {
            this.writeImpl(o, true);
        }
    }

    public void writeEnumSet(EnumSet<?> enumSet) throws IOException {
        this.out.write(123);
        this.tabIn();
        boolean referenced = this.objsReferenced.containsKey(enumSet);
        if (referenced) {
            this.writeId(this.getId(enumSet));
            this.out.write(44);
            this.newLine();
        }
        JsonWriter.writeJsonUtf8String("@enum", this.out);
        this.out.write(58);
        Enum ee = null;
        if (!enumSet.isEmpty()) {
            ee = (Enum)enumSet.iterator().next();
        } else {
            EnumSet<?> complement = EnumSet.complementOf(enumSet);
            if (!complement.isEmpty()) {
                ee = (Enum)complement.iterator().next();
            }
        }
        Field elementTypeField = MetaUtils.getField(EnumSet.class, "elementType");
        Class elementType = (Class<MetaUtils.Dumpty>)this.getValueByReflect(enumSet, elementTypeField);
        if (elementType == null) {
            elementType = ee == null ? MetaUtils.Dumpty.class : ee.getClass();
        }
        JsonWriter.writeJsonUtf8String(elementType.getName(), this.out);
        if (!enumSet.isEmpty()) {
            Map<String, Field> mapOfFields = MetaUtils.getDeepDeclaredFields(elementType);
            int enumFieldsCount = mapOfFields.size();
            this.out.write(",");
            this.newLine();
            JsonWriter.writeJsonUtf8String("@items", this.out);
            this.out.write(":[");
            if (enumFieldsCount > 2) {
                this.newLine();
            }
            boolean firstInSet = true;
            for (Enum e : enumSet) {
                if (!firstInSet) {
                    this.out.write(",");
                    if (enumFieldsCount > 2) {
                        this.newLine();
                    }
                }
                firstInSet = false;
                if (enumFieldsCount <= 2) {
                    JsonWriter.writeJsonUtf8String(e.name(), this.out);
                    continue;
                }
                boolean firstInEntry = true;
                this.out.write(123);
                for (Field f : mapOfFields.values()) {
                    firstInEntry = this.writeField(e, firstInEntry, f.getName(), f, false);
                }
                this.out.write(125);
            }
            this.out.write("]");
        }
        this.tabOut();
        this.out.write(125);
    }

    public void writeObject(Object obj, boolean showType, boolean bodyOnly) throws IOException {
        this.writeObject(obj, showType, bodyOnly, EMPTY_SET);
    }

    public void writeObject(Object obj, boolean showType, boolean bodyOnly, Set<String> fieldsToExclude) throws IOException {
        boolean first;
        if (this.neverShowType) {
            showType = false;
        }
        boolean referenced = this.objsReferenced.containsKey(obj);
        if (!bodyOnly) {
            this.out.write(123);
            this.tabIn();
            if (referenced) {
                this.writeId(this.getId(obj));
            }
            if (referenced && showType) {
                this.out.write(44);
                this.newLine();
            }
            if (showType) {
                this.writeType(obj, this.out);
            }
        }
        boolean bl = first = !showType;
        if (referenced && !showType) {
            first = false;
        }
        Map fieldSpecifiers = (Map)this.args.get(FIELD_SPECIFIERS);
        List<Field> fieldBlackListForClass = JsonWriter.getFieldsUsingSpecifier(obj.getClass(), (Map)this.args.get(FIELD_BLACK_LIST));
        List<Field> externallySpecifiedFields = JsonWriter.getFieldsUsingSpecifier(obj.getClass(), fieldSpecifiers);
        if (externallySpecifiedFields != null) {
            for (Field field : externallySpecifiedFields) {
                if (fieldBlackListForClass != null && fieldBlackListForClass.contains(field) || fieldsToExclude.contains(field.getName())) continue;
                first = this.writeField(obj, first, field.getName(), field, true);
            }
        } else {
            Map<String, Field> classFields = MetaUtils.getDeepDeclaredFields(obj.getClass());
            for (Map.Entry<String, Field> entry : classFields.entrySet()) {
                String fieldName = entry.getKey();
                Field field = entry.getValue();
                if (fieldBlackListForClass != null && fieldBlackListForClass.contains(field) || fieldsToExclude.contains(field.getName())) continue;
                first = this.writeField(obj, first, fieldName, field, false);
            }
        }
        if (!bodyOnly) {
            this.tabOut();
            this.out.write(125);
        }
    }

    private Object getValueByReflect(Object obj, Field field) {
        try {
            return field.get(obj);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private boolean writeField(Object obj, boolean first, String fieldName, Field field, boolean allowTransient) throws IOException {
        if (!allowTransient && (field.getModifiers() & 0x80) != 0) {
            return first;
        }
        int modifiers = field.getModifiers();
        Class<?> fieldDeclaringClass = field.getDeclaringClass();
        Object o = null;
        if (Enum.class.isAssignableFrom(fieldDeclaringClass)) {
            if (!"name".equals(field.getName())) {
                if (!Modifier.isPublic(modifiers) && this.isEnumPublicOnly) {
                    return first;
                }
                o = this.getValueByReflect(obj, field);
            } else {
                o = ((Enum)obj).name();
            }
        } else {
            o = ObjectResolver.isBasicWrapperType(fieldDeclaringClass) ? obj : this.getValueByReflect(obj, field);
        }
        if (this.skipNullFields && o == null) {
            return first;
        }
        if (!first) {
            this.out.write(44);
            this.newLine();
        }
        JsonWriter.writeJsonUtf8String(fieldName, this.out);
        this.out.write(58);
        if (o == null) {
            this.out.write("null");
            return false;
        }
        Class<?> type = field.getType();
        boolean forceType = this.isForceType(o.getClass(), type);
        if (MetaUtils.isPrimitive(type) || this.neverShowType && MetaUtils.isPrimitive(o.getClass())) {
            this.writePrimitive(o, false);
        } else {
            this.writeImpl(o, forceType || this.alwaysShowType, true, true);
        }
        return false;
    }

    private boolean isForceType(Class<?> objectClass, Class<?> declaredType) {
        if (objectClass == declaredType) {
            return false;
        }
        if (declaredType.isEnum() && declaredType.isAssignableFrom(objectClass)) {
            Optional<Class> optionalClass = MetaUtils.getClassIfEnum(objectClass);
            return declaredType != optionalClass.orElse(null);
        }
        if (!this.staticallyInitializedClasses.contains(declaredType)) {
            return true;
        }
        return this.getCustomWriter(declaredType) == null;
    }

    public static void writeJsonUtf8String(String s, Writer output) throws IOException {
        output.write(34);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        output.write("\\b");
                        break;
                    }
                    case '\f': {
                        output.write("\\f");
                        break;
                    }
                    case '\n': {
                        output.write("\\n");
                        break;
                    }
                    case '\r': {
                        output.write("\\r");
                        break;
                    }
                    case '\t': {
                        output.write("\\t");
                        break;
                    }
                    default: {
                        output.write(String.format("\\u%04X", c));
                        break;
                    }
                }
                continue;
            }
            if (c == '\\' || c == '\"') {
                output.write(92);
                output.write(c);
                continue;
            }
            output.write(c);
        }
        output.write(34);
    }

    @Override
    public void flush() {
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writerCache.clear();
        this.writers.clear();
    }

    private String getId(Object o) {
        long id;
        if (o instanceof JsonObject && (id = ((JsonObject)o).id) != -1L) {
            return String.valueOf(id);
        }
        Long id2 = this.objsReferenced.get(o);
        return id2 == null ? null : Long.toString(id2);
    }

    public Map<Object, Long> getObjVisited() {
        return this.objVisited;
    }

    public Map<Object, Long> getObjsReferenced() {
        return this.objsReferenced;
    }

    static {
        EMPTY_SET = new HashSet<String>();
        byteStrings = new Object[256];
        NEW_LINE = System.getProperty("line.separator");
        ZERO = 0L;
        nullWriter = new NullClass();
        enumAsStringWriter = new Writers.EnumsAsStringWriter();
        for (int i = -128; i <= 127; i = (int)((short)(i + 1))) {
            char[] chars = Integer.toString(i).toCharArray();
            JsonWriter.byteStrings[i + 128] = chars;
        }
        HashMap temp = new HashMap();
        temp.put(String.class, new Writers.JsonStringWriter());
        temp.put(Date.class, new Writers.DateWriter());
        temp.put(AtomicBoolean.class, new Writers.AtomicBooleanWriter());
        temp.put(AtomicInteger.class, new Writers.AtomicIntegerWriter());
        temp.put(AtomicLong.class, new Writers.AtomicLongWriter());
        temp.put(BigInteger.class, new Writers.BigIntegerWriter());
        temp.put(BigDecimal.class, new Writers.BigDecimalWriter());
        temp.put(java.sql.Date.class, new Writers.DateWriter());
        temp.put(Timestamp.class, new Writers.TimestampWriter());
        temp.put(Calendar.class, new Writers.CalendarWriter());
        temp.put(TimeZone.class, new Writers.TimeZoneWriter());
        temp.put(Locale.class, new Writers.LocaleWriter());
        temp.put(Class.class, new Writers.ClassWriter());
        temp.put(StringBuilder.class, new Writers.StringBuilderWriter());
        temp.put(StringBuffer.class, new Writers.StringBufferWriter());
        temp.put(UUID.class, new Writers.UUIDWriter());
        temp.put(URL.class, new Writers.URLWriter());
        temp.put(LocalDate.class, new Writers.LocalDateWriter());
        temp.put(LocalTime.class, new Writers.LocalTimeWriter());
        temp.put(LocalDateTime.class, new Writers.LocalDateTimeWriter());
        temp.put(ZonedDateTime.class, new Writers.ZonedDateTimeWriter());
        HashSet staticallyInitializedClasses = new HashSet();
        staticallyInitializedClasses.add(TimeZone.class);
        try {
            Class<?> zoneInfoClass = Class.forName("sun.util.calendar.ZoneInfo");
            temp.put(zoneInfoClass, new Writers.TimeZoneWriter());
            staticallyInitializedClasses.add(zoneInfoClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        BASE_STATICALLY_INITIALIZED_CLASSES = staticallyInitializedClasses;
        BASE_WRITERS = temp;
        allowNanAndInfinity = false;
    }

    static final class NullClass
    implements JsonClassWriter {
        NullClass() {
        }
    }

    @Deprecated
    public static interface JsonClassWriterEx
    extends JsonClassWriter {
        public static final String JSON_WRITER = "JSON_WRITER";

        @Deprecated
        public static class Support {
            public static JsonWriter getWriter(Map<String, Object> args) {
                return (JsonWriter)args.get("JSON_WRITER");
            }
        }
    }

    public static interface JsonClassWriter
    extends JsonClassWriterBase {
        default public void write(Object o, boolean showType, Writer output, Map<String, Object> args) throws IOException {
            this.write(o, showType, output);
        }

        default public void write(Object o, boolean showType, Writer output) throws IOException {
        }

        default public boolean hasPrimitiveForm(Map args) {
            return this.hasPrimitiveForm();
        }

        default public boolean hasPrimitiveForm() {
            return false;
        }

        default public void writePrimitiveForm(Object o, Writer output, Map args) throws IOException {
            this.writePrimitiveForm(o, output);
        }

        default public void writePrimitiveForm(Object o, Writer output) throws IOException {
        }

        default public JsonWriter getWriter(Map<String, Object> args) {
            return (JsonWriter)args.get(JsonWriter.JSON_WRITER);
        }
    }

    @Deprecated
    public static interface JsonClassWriterBase {
    }
}

