/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.Readers;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JsonObject
extends LinkedHashMap<Object, Object> {
    public static final String KEYS = "@keys";
    public static final String ITEMS = "@items";
    public static final String ID = "@id";
    public static final String REF = "@ref";
    public static final String TYPE = "@type";
    public static final String SHORT_TYPE = "@t";
    public static final String SHORT_ITEMS = "@e";
    public static final String SHORT_KEYS = "@k";
    public static final String SHORT_ID = "@i";
    public static final String SHORT_REF = "@r";
    public static final String VALUE = "value";
    static Set<String> primitives = new HashSet<String>();
    static Set<String> primitiveWrappers = new HashSet<String>();
    Object target;
    boolean isMap = false;
    boolean isFinished = false;
    String type;
    long id = -1L;
    int line;
    int col;
    Integer hash = null;

    @Override
    public String toString() {
        return "mLen:" + this.getLenientSize() + " type:" + this.type + " line:" + this.line + ", col:" + this.col + " id:" + this.id;
    }

    public boolean hasId() {
        return this.id > 0L;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public Object setFinishedTarget(Object o, boolean isFinished) {
        this.target = o;
        this.isFinished = isFinished;
        return this.target;
    }

    public Class<?> getTargetClass() {
        return this.target.getClass();
    }

    public boolean isLogicalPrimitive() {
        return primitiveWrappers.contains(this.type) || primitives.contains(this.type) || "date".equals(this.type) || "java.math.BigInteger".equals(this.type) || "java.math.BigDecimal".equals(this.type);
    }

    public Object getPrimitiveValue() {
        if ("boolean".equals(this.type) || "double".equals(this.type) || "long".equals(this.type)) {
            return this.get(VALUE);
        }
        if ("byte".equals(this.type)) {
            Number b = (Number)this.get(VALUE);
            return b.byteValue();
        }
        if ("char".equals(this.type)) {
            String c = (String)this.get(VALUE);
            return Character.valueOf(c.charAt(0));
        }
        if ("float".equals(this.type)) {
            Number f = (Number)this.get(VALUE);
            return Float.valueOf(f.floatValue());
        }
        if ("int".equals(this.type)) {
            Number integer = (Number)this.get(VALUE);
            return integer.intValue();
        }
        if ("short".equals(this.type)) {
            Number s = (Number)this.get(VALUE);
            return s.shortValue();
        }
        if ("date".equals(this.type)) {
            Object date = this.get(VALUE);
            if (date instanceof Long) {
                return new Date((Long)date);
            }
            if (date instanceof String) {
                return Readers.DateReader.parseDate((String)date);
            }
            throw new JsonIoException("Unknown date type: " + this.type);
        }
        if ("java.math.BigInteger".equals(this.type)) {
            Object value = this.get(VALUE);
            return Readers.bigIntegerFrom(value);
        }
        if ("java.math.BigDecimal".equals(this.type)) {
            Object value = this.get(VALUE);
            return Readers.bigDecimalFrom(value);
        }
        throw new JsonIoException("Invalid primitive type, line " + this.line + ", col " + this.col);
    }

    public boolean isReference() {
        return this.containsKey(REF);
    }

    public Long getReferenceId() {
        return (Long)this.get(REF);
    }

    public boolean isMap() {
        return this.isMap || this.target instanceof Map;
    }

    public boolean isCollection() {
        if (this.target instanceof Collection) {
            return true;
        }
        if (this.containsKey(ITEMS) && !this.containsKey(KEYS)) {
            return this.type != null && !this.type.contains("[");
        }
        return false;
    }

    public boolean isArray() {
        if (this.target == null) {
            if (this.type != null) {
                return this.type.contains("[");
            }
            return this.containsKey(ITEMS) && !this.containsKey(KEYS);
        }
        return this.target.getClass().isArray();
    }

    public Object[] getArray() {
        return (Object[])this.get(ITEMS);
    }

    public int getLength() {
        Integer items = this.getLenientSize();
        if (items != null) {
            return items;
        }
        throw new JsonIoException("getLength() called on a non-collection, line " + this.line + ", col " + this.col);
    }

    private Integer getLenientSize() {
        if (this.isArray()) {
            if (this.target == null) {
                Object[] items = (Object[])this.get(ITEMS);
                return items == null ? 0 : items.length;
            }
            return Array.getLength(this.target);
        }
        if (this.isCollection() || this.isMap()) {
            Object[] items = (Object[])this.get(ITEMS);
            return items == null ? 0 : items.length;
        }
        return null;
    }

    public Class<?> getComponentType() {
        return this.target.getClass().getComponentType();
    }

    void moveBytesToMate() {
        byte[] bytes = (byte[])this.target;
        Object[] items = this.getArray();
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            bytes[i] = ((Number)items[i]).byteValue();
        }
    }

    void moveCharsToMate() {
        Object[] items = this.getArray();
        if (items == null) {
            this.target = null;
        } else if (items.length == 0) {
            this.target = new char[0];
        } else if (items.length == 1) {
            String s = (String)items[0];
            this.target = s.toCharArray();
        } else {
            throw new JsonIoException("char[] should only have one String in the [], found " + items.length + ", line " + this.line + ", col " + this.col);
        }
    }

    @Override
    public Object put(Object key, Object value) {
        this.hash = null;
        if (key == null) {
            return super.put(null, value);
        }
        if (key.equals(TYPE)) {
            String oldType = this.type;
            this.type = (String)value;
            return oldType;
        }
        if (key.equals(ID)) {
            Long oldId = this.id;
            this.id = (Long)value;
            return oldId;
        }
        if (ITEMS.equals(key) && this.containsKey(KEYS) || KEYS.equals(key) && this.containsKey(ITEMS)) {
            this.isMap = true;
        }
        return super.put(key, value);
    }

    public Object setValue(Object o) {
        return this.put(VALUE, o);
    }

    public Object getValue() {
        return this.get(VALUE);
    }

    @Override
    public void clear() {
        super.clear();
        this.type = null;
        this.hash = null;
        this.id = -1L;
    }

    void clearArray() {
        this.remove(ITEMS);
        this.hash = null;
    }

    @Override
    public int size() {
        if (this.containsKey(ITEMS)) {
            Object value = this.get(ITEMS);
            if (value instanceof Object[]) {
                return ((Object[])value).length;
            }
            if (value == null) {
                return 0;
            }
            throw new JsonIoException("JsonObject with @items, but no array [] associated to it, line " + this.line + ", col " + this.col);
        }
        if (this.containsKey(REF)) {
            return 0;
        }
        return super.size();
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            this.hash = this.keySet().hashCode() + this.values().hashCode();
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        JsonObject that = (JsonObject)other;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        return this.compareEntrySet(that);
    }

    private boolean compareEntrySet(JsonObject that) {
        Iterator i = this.entrySet().iterator();
        Iterator j = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Map.Entry thatEntry = j.next();
            if (!Objects.equals(entry.getKey(), thatEntry.getKey())) {
                return false;
            }
            if (Objects.equals(entry.getValue(), thatEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getId() {
        return this.id;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    static {
        primitives.add("boolean");
        primitives.add("byte");
        primitives.add("char");
        primitives.add("double");
        primitives.add("float");
        primitives.add("int");
        primitives.add("long");
        primitives.add("short");
        primitiveWrappers.add("java.lang.Boolean");
        primitiveWrappers.add("java.lang.Byte");
        primitiveWrappers.add("java.lang.Character");
        primitiveWrappers.add("java.lang.Double");
        primitiveWrappers.add("java.lang.Float");
        primitiveWrappers.add("java.lang.Integer");
        primitiveWrappers.add("java.lang.Long");
        primitiveWrappers.add("java.lang.Short");
    }
}

