/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.FastPushbackReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class FastPushbackBufferedReader
extends BufferedReader
implements FastPushbackReader {
    private final int[] buf = new int[256];
    private int idx = 0;
    private int unread = Integer.MAX_VALUE;
    protected int line = 1;
    protected int col = 0;

    public FastPushbackBufferedReader(Reader reader) {
        super(reader);
    }

    @Override
    public String getLastSnippet() {
        int i;
        StringBuilder s = new StringBuilder();
        for (i = this.idx; i < this.buf.length && !this.appendChar(s, i); ++i) {
        }
        for (i = 0; i < this.idx && !this.appendChar(s, i); ++i) {
        }
        return s.toString();
    }

    private boolean appendChar(StringBuilder s, int i) {
        try {
            int snip = this.buf[i];
            if (snip == 0) {
                return true;
            }
            s.appendCodePoint(snip);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        int ch;
        if (this.unread == Integer.MAX_VALUE) {
            ch = super.read();
        } else {
            ch = this.unread;
            this.unread = Integer.MAX_VALUE;
        }
        if ((this.buf[this.idx++] = ch) == 10) {
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
        if (this.idx >= this.buf.length) {
            this.idx = 0;
        }
        return ch;
    }

    @Override
    public void unread(int c) throws IOException {
        this.unread = c;
        if (this.unread == 10) {
            --this.line;
        } else {
            --this.col;
        }
        this.idx = this.idx < 1 ? this.buf.length - 1 : --this.idx;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getCol() {
        return this.col;
    }
}

