/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.cache;

import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import com.cedarsoftware.util.MapUtilities;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class ThreadedLRUCacheStrategy<K, V>
implements Map<K, V>,
Closeable {
    private static final int DEFAULT_CLEANUP_INTERVAL_MS = 500;
    private static final int MAX_CLEANUP_BATCH = 10000;
    private final int capacity;
    private final ConcurrentMap<K, Node<K, V>> cache;
    private final WeakReference<ThreadedLRUCacheStrategy<K, V>> selfRef;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean cleanupInProgress = new AtomicBoolean(false);
    private static final Set<WeakReference<ThreadedLRUCacheStrategy<?, ?>>> ALL_CACHES = ConcurrentHashMap.newKeySet();
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "LRUCache-Cleanup-Thread");
        thread.setDaemon(true);
        return thread;
    });
    private static final ScheduledFuture<?> SHARED_CLEANUP_TASK = scheduler.scheduleAtFixedRate(ThreadedLRUCacheStrategy::cleanupAllCaches, 500L, 500L, TimeUnit.MILLISECONDS);

    public ThreadedLRUCacheStrategy(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least 1.");
        }
        this.capacity = capacity;
        this.cache = new ConcurrentHashMapNullSafe<K, Node<K, V>>(capacity);
        WeakReference<ThreadedLRUCacheStrategy<K, V>> ref = this.selfRef = new WeakReference<ThreadedLRUCacheStrategy>(this);
        ALL_CACHES.add(ref);
    }

    @Deprecated
    public ThreadedLRUCacheStrategy(int capacity, int cleanupDelayMillis) {
        this(capacity);
    }

    private static void cleanupAllCaches() {
        try {
            Iterator<WeakReference<ThreadedLRUCacheStrategy<?, ?>>> iter = ALL_CACHES.iterator();
            while (iter.hasNext()) {
                WeakReference<ThreadedLRUCacheStrategy<?, ?>> ref = iter.next();
                ThreadedLRUCacheStrategy cache = (ThreadedLRUCacheStrategy)ref.get();
                if (cache == null) {
                    iter.remove();
                    continue;
                }
                if (cache.closed.get()) continue;
                try {
                    cache.cleanup();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.close();
    }

    public void forceCleanup() {
        this.cleanup();
    }

    static int getRegisteredCacheCount() {
        return ALL_CACHES.size();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            WeakReference<ThreadedLRUCacheStrategy<K, V>> ref = this.selfRef;
            ALL_CACHES.remove(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if (!this.cleanupInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            int size = this.cache.size();
            int excess = size - this.capacity;
            if (excess <= 0) {
                return;
            }
            Node[] nodes = this.cache.values().toArray(new Node[0]);
            int numNodes = nodes.length;
            long[] timestamps = new long[numNodes];
            for (int i2 = 0; i2 < numNodes; ++i2) {
                timestamps[i2] = nodes[i2].timestamp;
            }
            Integer[] indices = new Integer[numNodes];
            for (int i3 = 0; i3 < numNodes; ++i3) {
                indices[i3] = i3;
            }
            Arrays.sort(indices, Comparator.comparingLong(i -> timestamps[i]));
            int nodesToRemove = excess > this.capacity * 10 ? excess : Math.min(excess, 10000);
            for (int i4 = 0; i4 < nodesToRemove && i4 < numNodes; ++i4) {
                Node node = nodes[indices[i4]];
                this.cache.remove(node.key, node);
            }
        }
        finally {
            this.cleanupInProgress.set(false);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.cache.get(key);
        if (node != null) {
            node.updateTimestamp();
            return node.value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Node<K, V> newNode = new Node<K, V>(key, value);
        Node<K, V> oldNode = this.cache.put(key, newNode);
        if (oldNode != null) {
            newNode.updateTimestamp();
            return oldNode.value;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public V remove(Object key) {
        Node node = (Node)this.cache.remove(key);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Node node = this.cache.computeIfAbsent(key, k -> {
            Object value = mappingFunction.apply((Object)k);
            return value != null ? new Node(k, value) : null;
        });
        if (node != null) {
            node.updateTimestamp();
            return node.value;
        }
        return null;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Node<K, V> newNode = new Node<K, V>(key, value);
        Node<K, V> oldNode = this.cache.putIfAbsent(key, newNode);
        if (oldNode != null) {
            oldNode.updateTimestamp();
            return oldNode.value;
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node node : this.cache.values()) {
            if (!Objects.equals(node.value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ConcurrentSet entrySet = new ConcurrentSet();
        for (Node node : this.cache.values()) {
            entrySet.add(new AbstractMap.SimpleEntry(node.key, node.value));
        }
        return Collections.unmodifiableSet(entrySet);
    }

    @Override
    public Set<K> keySet() {
        ConcurrentSet keySet = new ConcurrentSet();
        for (Node node : this.cache.values()) {
            keySet.add(node.key);
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (Node node : this.cache.values()) {
            values.add(node.value);
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.entrySet().equals(other.entrySet());
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Node node : this.cache.values()) {
            Object key = node.key;
            Object value = node.value;
            hashCode = 31 * hashCode + (key == null ? 0 : key.hashCode());
            hashCode = 31 * hashCode + (value == null ? 0 : value.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        return MapUtilities.mapToString(this);
    }

    private static class Node<K, V> {
        final K key;
        volatile V value;
        volatile long timestamp;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
            this.timestamp = System.nanoTime();
        }

        void updateTimestamp() {
            this.timestamp = System.nanoTime();
        }
    }
}

