/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.cache;

import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class LockingLRUCacheStrategy<K, V>
implements Map<K, V> {
    private final int capacity;
    private final ConcurrentHashMapNullSafe<Object, Node<K, V>> cache;
    private final Node<K, V> head;
    private final Node<K, V> tail;
    private final Lock lock = new ReentrantLock();

    public LockingLRUCacheStrategy(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least 1.");
        }
        this.capacity = capacity;
        this.cache = new ConcurrentHashMapNullSafe(capacity);
        this.head = new Node<Object, Object>(null, null);
        this.tail = new Node<Object, Object>(null, null);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    private void moveToHead(Node<K, V> node) {
        if (node.prev == null || node.next == null) {
            return;
        }
        this.removeNode(node);
        this.addToHead(node);
    }

    private void addToHead(Node<K, V> node) {
        node.next = this.head.next;
        node.next.prev = node;
        this.head.next = node;
        node.prev = this.head;
    }

    private void removeNode(Node<K, V> node) {
        if (node.prev != null && node.next != null) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
    }

    private Node<K, V> removeTail() {
        Node node = this.tail.prev;
        if (node != this.head) {
            this.removeNode(node);
            node.prev = null;
            node.next = null;
        }
        return node;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.cache.get(key);
        if (node == null) {
            return null;
        }
        if (this.lock.tryLock()) {
            try {
                this.moveToHead(node);
            }
            finally {
                this.lock.unlock();
            }
        }
        return node.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.lock();
        try {
            Node node = (Node)this.cache.get(key);
            if (node != null) {
                Object oldValue = node.value;
                node.value = value;
                this.moveToHead(node);
                Object v = oldValue;
                return v;
            }
            Node<K, V> newNode = new Node<K, V>(key, value);
            this.cache.put(key, newNode);
            this.addToHead(newNode);
            if (this.cache.size() > this.capacity) {
                Node<K, V> tailToRemove = this.removeTail();
                this.cache.remove(tailToRemove.key);
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.lock.lock();
        try {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.lock.lock();
        try {
            Node node = (Node)this.cache.remove(key);
            if (node != null) {
                this.removeNode(node);
                Object v = node.value;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.lock.lock();
        try {
            Node node = (Node)this.cache.get(key);
            if (node != null) {
                this.moveToHead(node);
                Object v = node.value;
                return v;
            }
            V value = mappingFunction.apply(key);
            if (value != null) {
                this.put(key, value);
            }
            V v = value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.lock.lock();
        try {
            Node node = (Node)this.cache.get(key);
            if (node != null) {
                this.moveToHead(node);
                Object v = node.value;
                return v;
            }
            this.put(key, value);
            V v = null;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.head.next = this.tail;
            this.tail.prev = this.head;
            this.cache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.lock.lock();
        try {
            Node node = this.head.next;
            while (node != this.tail) {
                if (Objects.equals(node.value, value)) {
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.lock.lock();
        try {
            LinkedHashMap map = new LinkedHashMap();
            Node node = this.head.next;
            while (node != this.tail) {
                map.put(node.key, node.value);
                node = node.next;
            }
            Set set = map.entrySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        this.lock.lock();
        try {
            LinkedHashMap map = new LinkedHashMap();
            Node node = this.head.next;
            while (node != this.tail) {
                map.put(node.key, node.value);
                node = node.next;
            }
            Set set = map.keySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        this.lock.lock();
        try {
            LinkedHashMap map = new LinkedHashMap();
            Node node = this.head.next;
            while (node != this.tail) {
                map.put(node.key, node.value);
                node = node.next;
            }
            Collection collection = map.values();
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.entrySet().equals(other.entrySet());
    }

    public String toString() {
        this.lock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            Node node = this.head.next;
            while (node != this.tail) {
                sb.append(this.formatElement(node.key)).append("=").append(this.formatElement(node.value)).append(", ");
                node = node.next;
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("}");
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String formatElement(Object element) {
        if (element == this) {
            return "(this Collection)";
        }
        return String.valueOf(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.lock.lock();
        try {
            int hashCode = 1;
            Node node = this.head.next;
            while (node != this.tail) {
                Object key = node.key;
                Object value = node.value;
                hashCode = 31 * hashCode + (key == null ? 0 : key.hashCode());
                hashCode = 31 * hashCode + (value == null ? 0 : value.hashCode());
                node = node.next;
            }
            int n = hashCode;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class Node<K, V> {
        K key;
        V value;
        Node<K, V> prev;
        Node<K, V> next;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

