/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class Traverser {
    private static final Logger LOG = Logger.getLogger(Traverser.class.getName());
    private static final int DEFAULT_MAX_STACK_DEPTH = 1000000;
    private static final int DEFAULT_MAX_OBJECTS_VISITED = 100000;
    private static final int DEFAULT_MAX_COLLECTION_SIZE = 50000;
    private static final int DEFAULT_MAX_ARRAY_LENGTH = 50000;
    private final Set<Object> objVisited = Collections.newSetFromMap(new IdentityHashMap());
    private final Consumer<NodeVisit> nodeVisitor;
    private final boolean collectFields;
    private int objectsVisited = 0;

    private static void initializeSystemPropertyDefaults() {
        if (System.getProperty("traverser.max.stack.depth") == null) {
            System.setProperty("traverser.max.stack.depth", "0");
        }
        if (System.getProperty("traverser.max.objects.visited") == null) {
            System.setProperty("traverser.max.objects.visited", "0");
        }
        if (System.getProperty("traverser.max.collection.size") == null) {
            System.setProperty("traverser.max.collection.size", "0");
        }
        if (System.getProperty("traverser.max.array.length") == null) {
            System.setProperty("traverser.max.array.length", "0");
        }
    }

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("traverser.security.enabled", "false"));
    }

    private static int getMaxStackDepth() {
        if (!Traverser.isSecurityEnabled()) {
            return 0;
        }
        String maxDepthProp = System.getProperty("traverser.max.stack.depth");
        if (maxDepthProp != null) {
            try {
                int value = Integer.parseInt(maxDepthProp);
                return Math.max(0, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1000000;
    }

    private static int getMaxObjectsVisited() {
        if (!Traverser.isSecurityEnabled()) {
            return 0;
        }
        String maxObjectsProp = System.getProperty("traverser.max.objects.visited");
        if (maxObjectsProp != null) {
            try {
                int value = Integer.parseInt(maxObjectsProp);
                return Math.max(0, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 100000;
    }

    private static int getMaxCollectionSize() {
        if (!Traverser.isSecurityEnabled()) {
            return 0;
        }
        String maxSizeProp = System.getProperty("traverser.max.collection.size");
        if (maxSizeProp != null) {
            try {
                int value = Integer.parseInt(maxSizeProp);
                return Math.max(0, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 50000;
    }

    private static int getMaxArrayLength() {
        if (!Traverser.isSecurityEnabled()) {
            return 0;
        }
        String maxLengthProp = System.getProperty("traverser.max.array.length");
        if (maxLengthProp != null) {
            try {
                int value = Integer.parseInt(maxLengthProp);
                return Math.max(0, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 50000;
    }

    private static void validateStackDepth(int currentDepth) {
        int maxDepth = Traverser.getMaxStackDepth();
        if (maxDepth > 0 && currentDepth > maxDepth) {
            throw new SecurityException("Stack depth exceeded limit (max " + maxDepth + "): " + currentDepth);
        }
    }

    private static void validateObjectsVisited(int objectsVisited) {
        int maxObjects = Traverser.getMaxObjectsVisited();
        if (maxObjects > 0 && objectsVisited > maxObjects) {
            throw new SecurityException("Objects visited exceeded limit (max " + maxObjects + "): " + objectsVisited);
        }
    }

    private static void validateCollectionSize(int size) {
        int maxSize = Traverser.getMaxCollectionSize();
        if (maxSize > 0 && size > maxSize) {
            throw new SecurityException("Collection size exceeded limit (max " + maxSize + "): " + size);
        }
    }

    private static void validateArrayLength(int length) {
        int maxLength = Traverser.getMaxArrayLength();
        if (maxLength > 0 && length > maxLength) {
            throw new SecurityException("Array length exceeded limit (max " + maxLength + "): " + length);
        }
    }

    private Traverser(Consumer<NodeVisit> nodeVisitor, boolean collectFields) {
        this.nodeVisitor = nodeVisitor;
        this.collectFields = collectFields;
    }

    public static void traverse(Object root, Consumer<NodeVisit> visitor, Set<Class<?>> classesToSkip) {
        Traverser.traverse(root, visitor, classesToSkip, true);
    }

    public static void traverse(Object root, Consumer<NodeVisit> visitor, Set<Class<?>> classesToSkip, boolean collectFields) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        Traverser traverser = new Traverser(visitor, collectFields);
        traverser.walk(root, classesToSkip);
    }

    private static void traverse(Object root, Set<Class<?>> classesToSkip, Consumer<Object> objectProcessor) {
        if (objectProcessor == null) {
            throw new IllegalArgumentException("objectProcessor cannot be null");
        }
        Traverser.traverse(root, visit -> objectProcessor.accept(visit.getNode()), classesToSkip, true);
    }

    @Deprecated
    public static void traverse(Object root, Visitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        Traverser.traverse(root, visit -> visitor.process(visit.getNode()), null, true);
    }

    @Deprecated
    public static void traverse(Object root, Class<?>[] skip, Visitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        HashSet classesToSkip = skip == null ? null : new HashSet(Arrays.asList(skip));
        Traverser.traverse(root, visit -> visitor.process(visit.getNode()), classesToSkip, true);
    }

    private void walk(Object root, Set<Class<?>> classesToSkip) {
        if (root == null) {
            return;
        }
        ArrayDeque<TraversalNode> stack = new ArrayDeque<TraversalNode>();
        stack.add(new TraversalNode(root, 1));
        this.objectsVisited = 0;
        int maxStackDepth = Traverser.getMaxStackDepth();
        int maxObjectsVisited = Traverser.getMaxObjectsVisited();
        while (!stack.isEmpty()) {
            Class<?> clazz;
            TraversalNode node = (TraversalNode)stack.pollFirst();
            Object current = node.object;
            int currentDepth = node.depth;
            if (maxStackDepth > 0 && currentDepth > maxStackDepth) {
                throw new SecurityException("Stack depth exceeded limit (max " + maxStackDepth + "): " + currentDepth);
            }
            if (current == null || this.objVisited.contains(current) || this.shouldSkipClass(clazz = current.getClass(), classesToSkip)) continue;
            this.objVisited.add(current);
            ++this.objectsVisited;
            if (maxObjectsVisited > 0 && this.objectsVisited > maxObjectsVisited) {
                throw new SecurityException("Objects visited exceeded limit (max " + maxObjectsVisited + "): " + this.objectsVisited);
            }
            if (this.collectFields) {
                this.nodeVisitor.accept(new NodeVisit(current, this.collectFields(current)));
            } else {
                this.nodeVisitor.accept(new NodeVisit(current, () -> this.collectFields(current)));
            }
            if (clazz.isArray()) {
                this.processArray(stack, current, classesToSkip, currentDepth);
                continue;
            }
            if (current instanceof Collection) {
                this.processCollection(stack, (Collection)current, classesToSkip, currentDepth);
                continue;
            }
            if (current instanceof Map) {
                this.processMap(stack, (Map)current, classesToSkip, currentDepth);
                continue;
            }
            this.processFields(stack, current, classesToSkip, currentDepth);
        }
    }

    private Map<Field, Object> collectFields(Object obj) {
        HashMap<Field, Object> fields = new HashMap<Field, Object>();
        List<Field> allFields = ReflectionUtils.getAllDeclaredFields(obj.getClass(), field -> ReflectionUtils.DEFAULT_FIELD_FILTER.test((Field)field) && !field.isSynthetic());
        for (Field field2 : allFields) {
            try {
                if (!field2.isAccessible()) {
                    field2.setAccessible(true);
                }
                fields.put(field2, field2.get(obj));
            }
            catch (Exception e) {
                fields.put(field2, "<inaccessible>");
            }
        }
        return fields;
    }

    private boolean shouldSkipClass(Class<?> clazz, Set<Class<?>> classesToSkip) {
        if (classesToSkip == null) {
            return false;
        }
        for (Class<?> skipClass : classesToSkip) {
            if (skipClass == null || !skipClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private void processCollection(Deque<TraversalNode> stack, Collection<?> collection, Set<Class<?>> classesToSkip, int depth) {
        Traverser.validateCollectionSize(collection.size());
        for (Object element : collection) {
            if (element == null || this.shouldSkipClass(element.getClass(), classesToSkip)) continue;
            stack.addFirst(new TraversalNode(element, depth + 1));
        }
    }

    private void processMap(Deque<TraversalNode> stack, Map<?, ?> map, Set<Class<?>> classesToSkip, int depth) {
        Traverser.validateCollectionSize(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null && !this.shouldSkipClass(key.getClass(), classesToSkip)) {
                stack.addFirst(new TraversalNode(key, depth + 1));
            }
            if (value == null || this.shouldSkipClass(value.getClass(), classesToSkip)) continue;
            stack.addFirst(new TraversalNode(value, depth + 1));
        }
    }

    private void processFields(Deque<TraversalNode> stack, Object object, Set<Class<?>> classesToSkip, int depth) {
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(object.getClass(), field -> ReflectionUtils.DEFAULT_FIELD_FILTER.test((Field)field) && !field.isSynthetic());
        for (Field field2 : fields) {
            if (field2.getType().isPrimitive()) continue;
            try {
                Object value;
                if (!field2.isAccessible()) {
                    field2.setAccessible(true);
                }
                if ((value = field2.get(object)) == null || this.shouldSkipClass(value.getClass(), classesToSkip)) continue;
                stack.addFirst(new TraversalNode(value, depth + 1));
            }
            catch (Exception exception) {}
        }
    }

    private void processArray(Deque<TraversalNode> stack, Object array, Set<Class<?>> classesToSkip, int depth) {
        int length = ArrayUtilities.getLength(array);
        Class<?> componentType = array.getClass().getComponentType();
        if (!componentType.isPrimitive()) {
            Traverser.validateArrayLength(length);
            for (int i = 0; i < length; ++i) {
                Object element = ArrayUtilities.getElement(array, i);
                if (element == null || this.shouldSkipClass(element.getClass(), classesToSkip)) continue;
                stack.addFirst(new TraversalNode(element, depth + 1));
            }
        }
    }

    static {
        LoggingConfig.init();
        Traverser.initializeSystemPropertyDefaults();
    }

    @Deprecated
    @FunctionalInterface
    public static interface Visitor {
        public void process(Object var1);
    }

    private static class TraversalNode {
        final Object object;
        final int depth;

        TraversalNode(Object object, int depth) {
            this.object = object;
            this.depth = depth;
        }
    }

    public static class NodeVisit {
        private final Object node;
        private final Supplier<Map<Field, Object>> fieldsSupplier;
        private Map<Field, Object> fields;

        public NodeVisit(Object node, Map<Field, Object> fields) {
            this(node, () -> fields == null ? Collections.emptyMap() : fields);
            this.fields = Collections.unmodifiableMap(new HashMap<Field, Object>(fields));
        }

        public NodeVisit(Object node, Supplier<Map<Field, Object>> supplier) {
            this.node = node;
            this.fieldsSupplier = supplier;
        }

        public Object getNode() {
            return this.node;
        }

        public Map<Field, Object> getFields() {
            if (this.fields == null) {
                Map f;
                Map<Object, Object> map = f = this.fieldsSupplier == null ? Collections.emptyMap() : this.fieldsSupplier.get();
                if (f == null) {
                    f = Collections.emptyMap();
                }
                this.fields = Collections.unmodifiableMap(new HashMap(f));
            }
            return this.fields;
        }

        public Class<?> getNodeClass() {
            return this.node.getClass();
        }
    }
}

