/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.MonthDay;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class MonthDayConversions {
    private MonthDayConversions() {
    }

    static Map toMap(Object from, Converter converter) {
        MonthDay monthDay = (MonthDay)from;
        LinkedHashMap<String, String> target = new LinkedHashMap<String, String>();
        target.put("monthDay", monthDay.toString());
        return target;
    }

    static int toInt(Object from, Converter converter) {
        MonthDay monthDay = (MonthDay)from;
        return monthDay.getMonthValue() * 100 + monthDay.getDayOfMonth();
    }

    static Integer toInteger(Object from, Converter converter) {
        return MonthDayConversions.toInt(from, converter);
    }

    static short toShort(Object from, Converter converter) {
        return (short)MonthDayConversions.toInt(from, converter);
    }

    static Long toLong(Object from, Converter converter) {
        return MonthDayConversions.toInt(from, converter);
    }

    static Double toDouble(Object from, Converter converter) {
        return MonthDayConversions.toInt(from, converter);
    }

    static Float toFloat(Object from, Converter converter) {
        return Float.valueOf(MonthDayConversions.toInt(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return BigInteger.valueOf(MonthDayConversions.toInt(from, converter));
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        return BigDecimal.valueOf(MonthDayConversions.toInt(from, converter));
    }

    static boolean toBoolean(Object from, Converter converter) {
        return MonthDayConversions.toInt(from, converter) != 0;
    }

    static Byte toByte(Object from, Converter converter) {
        return (byte)MonthDayConversions.toInt(from, converter);
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return new AtomicInteger(MonthDayConversions.toInt(from, converter));
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(MonthDayConversions.toInt(from, converter));
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(MonthDayConversions.toBoolean(from, converter));
    }
}

