/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import java.io.IOException;
import java.io.Reader;

public final class FastReader
extends Reader {
    private Reader in;
    private final char[] buf;
    private final int bufferSize;
    private final int pushbackBufferSize;
    private int position;
    private int limit;
    private final char[] pushbackBuffer;
    private int pushbackPosition;
    private int line = 1;
    private int col = 0;

    public FastReader(Reader in) {
        this(in, 16384, 16);
    }

    public FastReader(Reader in, int bufferSize, int pushbackBufferSize) {
        super((Object)in);
        if (bufferSize <= 0 || pushbackBufferSize < 0) {
            throw new IllegalArgumentException("Buffer sizes must be positive");
        }
        this.in = in;
        this.bufferSize = bufferSize;
        this.pushbackBufferSize = pushbackBufferSize;
        this.buf = new char[bufferSize];
        this.pushbackBuffer = new char[pushbackBufferSize];
        this.position = 0;
        this.limit = 0;
        this.pushbackPosition = pushbackBufferSize;
    }

    private void fill() {
        if (this.limit == -1) {
            return;
        }
        if (this.position >= this.limit) {
            try {
                this.limit = this.in.read(this.buf, 0, this.bufferSize);
            }
            catch (IOException e) {
                ExceptionUtilities.uncheckedThrow(e);
            }
            if (this.limit > 0) {
                this.position = 0;
            }
        }
    }

    public void pushback(char ch) {
        if (this.pushbackPosition == 0) {
            ExceptionUtilities.uncheckedThrow(new IOException("Pushback buffer is full"));
        }
        this.pushbackBuffer[--this.pushbackPosition] = ch;
        if (ch == '\n') {
            --this.line;
        } else {
            --this.col;
        }
    }

    @Override
    public int read() {
        char ch;
        if (this.in == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("in is null"));
        }
        if (this.pushbackPosition < this.pushbackBufferSize) {
            char ch2;
            if ((ch2 = this.pushbackBuffer[this.pushbackPosition++]) == '\n') {
                ++this.line;
                this.col = 0;
            } else {
                ++this.col;
            }
            return ch2;
        }
        this.fill();
        if (this.limit == -1) {
            return -1;
        }
        if ((ch = this.buf[this.position++]) == '\n') {
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.in == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("inputReader is null"));
        }
        if (len == 0) {
            return 0;
        }
        int charsRead = 0;
        while (len > 0) {
            int availableFromPushback = this.pushbackBufferSize - this.pushbackPosition;
            if (availableFromPushback > 0) {
                int toRead = Math.min(availableFromPushback, len);
                int p = this.pushbackPosition;
                int o = off;
                for (int i = 0; i < toRead; ++i) {
                    char ch = this.pushbackBuffer[p++];
                    cbuf[o++] = ch;
                    if (ch == '\n') {
                        ++this.line;
                        this.col = 0;
                        continue;
                    }
                    ++this.col;
                }
                this.pushbackPosition = p;
                off = o;
                len -= toRead;
                charsRead += toRead;
                continue;
            }
            this.fill();
            if (this.limit == -1) {
                return charsRead > 0 ? charsRead : -1;
            }
            int availableFromMain = this.limit - this.position;
            if (availableFromMain <= 0) {
                return charsRead > 0 ? charsRead : -1;
            }
            int toRead = Math.min(availableFromMain, len);
            int p = this.position;
            int o = off;
            for (int i = 0; i < toRead; ++i) {
                char ch = this.buf[p++];
                cbuf[o++] = ch;
                if (ch == '\n') {
                    ++this.line;
                    this.col = 0;
                    continue;
                }
                ++this.col;
            }
            this.position = p;
            off = o;
            len -= toRead;
            charsRead += toRead;
        }
        return charsRead;
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                ExceptionUtilities.uncheckedThrow(e);
            }
            this.in = null;
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public String getLastSnippet() {
        StringBuilder s = new StringBuilder(this.position);
        for (int i = 0; i < this.position; ++i) {
            s.append(this.buf[i]);
        }
        return s.toString();
    }
}

