/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

final class DurationConversions {
    public static final String DURATION_LONG_PRECISION = "duration.long.precision";

    private DurationConversions() {
    }

    static Map toMap(Object from, Converter converter) {
        Duration duration = (Duration)from;
        LinkedHashMap<String, String> target = new LinkedHashMap<String, String>();
        target.put("duration", duration.toString());
        return target;
    }

    static long toLong(Object from, Converter converter) {
        Duration duration = (Duration)from;
        String systemPrecision = System.getProperty("cedarsoftware.converter.duration.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption(DURATION_LONG_PRECISION);
        }
        if ("nanos".equals(precision)) {
            return duration.toNanos();
        }
        return duration.toMillis();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(DurationConversions.toLong(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Duration duration = (Duration)from;
        BigInteger epochSeconds = BigInteger.valueOf(duration.getSeconds());
        BigInteger nanos = BigInteger.valueOf(duration.getNano());
        return epochSeconds.multiply(BigIntegerConversions.BILLION).add(nanos);
    }

    static double toDouble(Object from, Converter converter) {
        Duration duration = (Duration)from;
        return BigDecimalConversions.secondsAndNanosToDouble(duration.getSeconds(), duration.getNano()).doubleValue();
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Duration duration = (Duration)from;
        return BigDecimalConversions.secondsAndNanosToDouble(duration.getSeconds(), duration.getNano());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        return Timestamp.from(timeAfterDuration);
    }

    static Date toSqlDate(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        LocalDate localDate = timeAfterDuration.atOffset(ZoneOffset.UTC).toLocalDate();
        return Date.valueOf(localDate);
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        Duration duration = (Duration)from;
        TimeZone timeZone = converter.getOptions().getTimeZone();
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timeZone.getOffset(System.currentTimeMillis()) / 1000);
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        return timeAfterDuration.atOffset(zoneOffset);
    }

    static boolean toBoolean(Object from, Converter converter) {
        Duration duration = (Duration)from;
        return !duration.isZero();
    }

    static Boolean toBooleanWrapper(Object from, Converter converter) {
        return DurationConversions.toBoolean(from, converter);
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(DurationConversions.toBoolean(from, converter));
    }

    static Calendar toCalendar(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        Calendar calendar = Calendar.getInstance(converter.getOptions().getTimeZone());
        calendar.setTimeInMillis(timeAfterDuration.toEpochMilli());
        return calendar;
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        return timeAfterDuration.atZone(converter.getOptions().getZoneId()).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        Duration duration = (Duration)from;
        long totalSeconds = duration.getSeconds();
        int nanos = duration.getNano();
        long secondsInDay = 86400L;
        long adjustedSeconds = (totalSeconds % secondsInDay + secondsInDay) % secondsInDay;
        return LocalTime.ofSecondOfDay(adjustedSeconds).withNano(nanos);
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        return timeAfterDuration.atZone(converter.getOptions().getZoneId()).toLocalDateTime();
    }

    static java.util.Date toDate(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        return java.util.Date.from(timeAfterDuration);
    }

    static Instant toInstant(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        return epoch.plus(duration);
    }

    static Number toNumber(Object from, Converter converter) {
        Duration duration = (Duration)from;
        return duration.toMillis();
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        return timeAfterDuration.atZone(converter.getOptions().getZoneId());
    }
}

