/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.EncryptionUtilities;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentSet<T>
implements Set<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<Object> set;

    public ConcurrentSet() {
        this.set = ConcurrentHashMap.newKeySet();
    }

    public ConcurrentSet(Collection<? extends T> col) {
        this.set = ConcurrentHashMap.newKeySet(col.size());
        this.addAll((Collection<? extends T>)col);
    }

    public ConcurrentSet(Set<? extends T> set) {
        this.set = ConcurrentHashMap.newKeySet(set.size());
        this.addAll((Collection<? extends T>)set);
    }

    private Object wrap(Object item) {
        return item == null ? NullSentinel.NULL_ITEM : item;
    }

    private T unwrap(Object item) {
        return (T)(item == NullSentinel.NULL_ITEM ? null : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set other = (Set)o;
        if (other.size() != this.size()) {
            return false;
        }
        try {
            for (T item : this) {
                if (other.contains(item)) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (T item : this) {
            h += item == null ? 0 : item.hashCode();
        }
        return EncryptionUtilities.finalizeHash(h);
    }

    public String toString() {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            T e;
            sb.append((Object)((e = it.next()) == this ? "(this Set)" : e));
            if (!it.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(this.wrap(o));
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Object> iterator = this.set.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object item = iterator.next();
                return ConcurrentSet.this.unwrap(item);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.set.toArray();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != NullSentinel.NULL_ITEM) continue;
            array[i] = null;
        }
        return array;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        Object[] internalArray = this.set.toArray();
        int size = internalArray.length;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        for (int i = 0; i < size; ++i) {
            a[i] = internalArray[i] == NullSentinel.NULL_ITEM ? null : internalArray[i];
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        for (Object o : col) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(T e) {
        return this.set.add(this.wrap(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(this.wrap(o));
    }

    @Override
    public boolean addAll(Collection<? extends T> col) {
        boolean modified = false;
        for (T item : col) {
            if (!this.add(item)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        boolean modified = false;
        for (Object o : col) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        ConcurrentHashMap.KeySetView wrappedCol = ConcurrentHashMap.newKeySet();
        for (Object o : col) {
            wrappedCol.add(this.wrap(o));
        }
        return this.set.retainAll(wrappedCol);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    private static enum NullSentinel {
        NULL_ITEM;

    }
}

