/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.EncryptionUtilities;
import com.cedarsoftware.util.LoggingConfig;
import java.lang.ref.Reference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MultiKeyMap<V>
implements ConcurrentMap<Object, V> {
    private static final Logger LOG = Logger.getLogger(MultiKeyMap.class.getName());
    private static final Object OPEN;
    private static final Object CLOSE;
    private static final Object NULL_SENTINEL;
    private static final String THIS_MAP = "(this Map \u267b\ufe0f)";
    private static final String EMOJI_OPEN = "[";
    private static final String EMOJI_CLOSE = "]";
    private static final String EMOJI_CYCLE = "\u267b\ufe0f";
    private static final String EMOJI_EMPTY = "\u2205";
    private static final String EMOJI_KEY = "\ud83c\udd94 ";
    private static final String EMOJI_VALUE = "\ud83d\udfe3 ";
    private static final AtomicBoolean STRIPE_CONFIG_LOGGED;
    private final AtomicInteger totalLockAcquisitions = new AtomicInteger(0);
    private final AtomicInteger contentionCount = new AtomicInteger(0);
    private final AtomicInteger[] stripeLockContention = new AtomicInteger[STRIPE_COUNT];
    private final AtomicInteger[] stripeLockAcquisitions = new AtomicInteger[STRIPE_COUNT];
    private final AtomicInteger globalLockAcquisitions = new AtomicInteger(0);
    private final AtomicInteger globalLockContentions = new AtomicInteger(0);
    private final AtomicBoolean resizeInProgress = new AtomicBoolean(false);
    private volatile Object[] buckets;
    private final AtomicInteger atomicSize = new AtomicInteger(0);
    private final AtomicInteger maxChainLength = new AtomicInteger(0);
    private final float loadFactor;
    private final CollectionKeyMode collectionKeyMode;
    private final boolean flattenDimensions;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int STRIPE_COUNT;
    private static final int STRIPE_MASK;
    private final ReentrantLock[] stripeLocks = new ReentrantLock[STRIPE_COUNT];

    public MultiKeyMap(int capacity, float loadFactor, CollectionKeyMode collectionKeyMode, boolean flattenDimensions) {
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be positive: " + loadFactor);
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative: " + capacity);
        }
        this.buckets = new Object[capacity];
        this.loadFactor = loadFactor;
        this.collectionKeyMode = collectionKeyMode != null ? collectionKeyMode : CollectionKeyMode.COLLECTIONS_EXPANDED;
        this.flattenDimensions = flattenDimensions;
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            this.stripeLocks[i] = new ReentrantLock();
            this.stripeLockContention[i] = new AtomicInteger(0);
            this.stripeLockAcquisitions[i] = new AtomicInteger(0);
        }
        if (STRIPE_CONFIG_LOGGED.compareAndSet(false, true) && LOG.isLoggable(Level.INFO)) {
            LOG.info(String.format("MultiKeyMap stripe configuration: %d locks for %d cores", STRIPE_COUNT, Runtime.getRuntime().availableProcessors()));
        }
    }

    public MultiKeyMap(int capacity, float loadFactor) {
        this(capacity, loadFactor, CollectionKeyMode.COLLECTIONS_EXPANDED, false);
    }

    public MultiKeyMap(int capacity, float loadFactor, CollectionKeyMode collectionKeyMode) {
        this(capacity, loadFactor, collectionKeyMode, false);
    }

    public MultiKeyMap() {
        this(16);
    }

    public MultiKeyMap(int capacity) {
        this(capacity, 0.75f);
    }

    public MultiKeyMap(CollectionKeyMode collectionKeyMode, boolean flattenDimensions) {
        this(16, 0.75f, collectionKeyMode, flattenDimensions);
    }

    public MultiKeyMap(boolean flattenDimensions) {
        this(16, 0.75f, CollectionKeyMode.COLLECTIONS_EXPANDED, flattenDimensions);
    }

    public CollectionKeyMode getCollectionKeyMode() {
        return this.collectionKeyMode;
    }

    public boolean getFlattenDimensions() {
        return this.flattenDimensions;
    }

    private static int computeElementHash(Object key) {
        if (key == null) {
            return 0;
        }
        if (key instanceof Class || key instanceof AccessibleObject || key instanceof ClassLoader || key instanceof Reference || key instanceof Thread) {
            return System.identityHashCode(key);
        }
        return key.hashCode();
    }

    private ReentrantLock getStripeLock(int hash) {
        return this.stripeLocks[hash & STRIPE_MASK];
    }

    private void lockAllStripes() {
        int contended = 0;
        for (ReentrantLock lock : this.stripeLocks) {
            if (lock.hasQueuedThreads()) {
                ++contended;
            }
            lock.lock();
        }
        this.globalLockAcquisitions.incrementAndGet();
        if (contended > 0) {
            this.globalLockContentions.incrementAndGet();
        }
    }

    private void unlockAllStripes() {
        for (int i = this.stripeLocks.length - 1; i >= 0; --i) {
            this.stripeLocks[i].unlock();
        }
    }

    public V getMultiKey(Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.get(null);
        }
        if (keys.length == 1) {
            return this.get(keys[0]);
        }
        return this.get(keys);
    }

    @Override
    public V get(Object key) {
        MultiKey<V> entry = this.findEntry(key);
        return entry != null ? (V)entry.value : null;
    }

    public V putMultiKey(V value, Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.put((Object)null, value);
        }
        if (keys.length == 1) {
            return this.put(keys[0], value);
        }
        return this.put(keys, value);
    }

    @Override
    public V put(Object key, V value) {
        MultiKey<V> newKey = this.createMultiKey(key, value);
        return this.putInternal(newKey);
    }

    private MultiKey<V> createMultiKey(Object key, V value) {
        int[] hashPass = new int[1];
        Object normalizedKey = this.normalizeLookup(key, hashPass, true);
        return new MultiKey<V>(normalizedKey, hashPass[0], value);
    }

    private void computeKeyHash(Object key, int[] hashPass) {
        this.normalizeLookup(key, hashPass, false);
    }

    private void updateMaxChainLength(int newValue) {
        this.maxChainLength.getAndAccumulate(newValue, Math::max);
    }

    private Object normalizeLookup(Object key, int[] hashPass, boolean makeDefensiveCopy) {
        if (key == null) {
            hashPass[0] = 0;
            return NULL_SENTINEL;
        }
        Class<?> clazz = key.getClass();
        if (!clazz.isArray() && !(key instanceof Collection)) {
            hashPass[0] = MultiKeyMap.finalizeHash(MultiKeyMap.computeElementHash(key));
            return key;
        }
        if (this.collectionKeyMode == CollectionKeyMode.COLLECTIONS_NOT_EXPANDED && key instanceof Collection) {
            Collection coll = (Collection)key;
            hashPass[0] = MultiKeyMap.finalizeHash(coll.hashCode());
            return makeDefensiveCopy ? new ArrayList(coll) : coll;
        }
        if (clazz.isArray()) {
            if (clazz == Object[].class) {
                Object[] arr = (Object[])key;
                return this.process1DObjectArray(arr, hashPass);
            }
            return this.process1DTypedArray(key, hashPass);
        }
        Collection coll = (Collection)key;
        if (this.flattenDimensions) {
            return this.expandWithHash(coll, hashPass);
        }
        return this.process1DCollection(coll, hashPass, makeDefensiveCopy);
    }

    private Object process1DObjectArray(Object[] array, int[] hashPass) {
        if (array.length == 0) {
            hashPass[0] = 0;
            return array;
        }
        int h = 1;
        boolean is1D = true;
        for (Object e : array) {
            h = h * 31 + MultiKeyMap.computeElementHash(e);
            if (e == null || !e.getClass().isArray() && !(e instanceof Collection)) continue;
            is1D = false;
            break;
        }
        if (is1D) {
            if (array.length == 1) {
                Object element = array[0];
                if (element == null) {
                    hashPass[0] = 0;
                    return NULL_SENTINEL;
                }
                hashPass[0] = MultiKeyMap.finalizeHash(MultiKeyMap.computeElementHash(element));
                return element;
            }
            hashPass[0] = MultiKeyMap.finalizeHash(h);
            return array;
        }
        return this.expandWithHash(array, hashPass);
    }

    private Object process1DCollection(Collection<?> coll, int[] hashPass, boolean makeDefensiveCopy) {
        if (coll.isEmpty()) {
            hashPass[0] = 0;
            return coll;
        }
        int h = 1;
        boolean is1D = true;
        if (coll instanceof ArrayList) {
            ArrayList list = coll;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object e = list.get(i);
                h = h * 31 + MultiKeyMap.computeElementHash(e);
                if (e == null || !e.getClass().isArray() && !(e instanceof Collection)) continue;
                is1D = false;
                break;
            }
        } else {
            for (Object e : coll) {
                h = h * 31 + MultiKeyMap.computeElementHash(e);
                if (e == null || !e.getClass().isArray() && !(e instanceof Collection)) continue;
                is1D = false;
                break;
            }
        }
        if (is1D) {
            if (coll.size() == 1) {
                Object single = coll.iterator().next();
                if (single == null) {
                    hashPass[0] = 0;
                    return NULL_SENTINEL;
                }
                hashPass[0] = MultiKeyMap.finalizeHash(MultiKeyMap.computeElementHash(single));
                return single;
            }
            hashPass[0] = MultiKeyMap.finalizeHash(h);
            return makeDefensiveCopy ? new ArrayList(coll) : coll;
        }
        return this.expandWithHash(coll, hashPass);
    }

    private Object process1DTypedArray(Object arr, int[] hashPass) {
        Class<?> clazz = arr.getClass();
        if (clazz == String[].class) {
            return this.process1DStringArray((String[])arr, hashPass);
        }
        if (clazz == int[].class) {
            return this.process1DIntArray((int[])arr, hashPass);
        }
        if (clazz == long[].class) {
            return this.process1DLongArray((long[])arr, hashPass);
        }
        if (clazz == double[].class) {
            return this.process1DDoubleArray((double[])arr, hashPass);
        }
        if (clazz == boolean[].class) {
            return this.process1DBooleanArray((boolean[])arr, hashPass);
        }
        return this.process1DGenericArray(arr, hashPass);
    }

    private Object process1DStringArray(String[] array, int[] hashPass) {
        if (array.length == 0) {
            hashPass[0] = 0;
            return array;
        }
        int h = 1;
        for (String e : array) {
            h = h * 31 + MultiKeyMap.computeElementHash(e);
        }
        if (array.length == 1) {
            String element = array[0];
            if (element == null) {
                hashPass[0] = 0;
                return NULL_SENTINEL;
            }
            hashPass[0] = MultiKeyMap.finalizeHash(MultiKeyMap.computeElementHash(element));
            return element;
        }
        hashPass[0] = MultiKeyMap.finalizeHash(h);
        return array;
    }

    private Object process1DIntArray(int[] array, int[] hashPass) {
        if (array.length == 0) {
            hashPass[0] = 0;
            return array;
        }
        int h = 1;
        for (int e : array) {
            h = h * 31 + Integer.hashCode(e);
        }
        if (array.length == 1) {
            hashPass[0] = MultiKeyMap.finalizeHash(Integer.hashCode(array[0]));
            return array[0];
        }
        hashPass[0] = MultiKeyMap.finalizeHash(h);
        return array;
    }

    private Object process1DLongArray(long[] array, int[] hashPass) {
        if (array.length == 0) {
            hashPass[0] = 0;
            return array;
        }
        int h = 1;
        for (long e : array) {
            h = h * 31 + Long.hashCode(e);
        }
        if (array.length == 1) {
            hashPass[0] = MultiKeyMap.finalizeHash(Long.hashCode(array[0]));
            return array[0];
        }
        hashPass[0] = MultiKeyMap.finalizeHash(h);
        return array;
    }

    private Object process1DDoubleArray(double[] array, int[] hashPass) {
        if (array.length == 0) {
            hashPass[0] = 0;
            return array;
        }
        int h = 1;
        for (double e : array) {
            h = h * 31 + Double.hashCode(e);
        }
        if (array.length == 1) {
            hashPass[0] = MultiKeyMap.finalizeHash(Double.hashCode(array[0]));
            return array[0];
        }
        hashPass[0] = MultiKeyMap.finalizeHash(h);
        return array;
    }

    private Object process1DBooleanArray(boolean[] array, int[] hashPass) {
        if (array.length == 0) {
            hashPass[0] = 0;
            return array;
        }
        int h = 1;
        for (boolean e : array) {
            h = h * 31 + Boolean.hashCode(e);
        }
        if (array.length == 1) {
            hashPass[0] = MultiKeyMap.finalizeHash(Boolean.hashCode(array[0]));
            return array[0];
        }
        hashPass[0] = MultiKeyMap.finalizeHash(h);
        return array;
    }

    private Object process1DGenericArray(Object arr, int[] hashPass) {
        int len = Array.getLength(arr);
        if (len == 0) {
            hashPass[0] = 0;
            return arr;
        }
        int h = 1;
        boolean is1D = true;
        for (int i = 0; i < len; ++i) {
            Object e = Array.get(arr, i);
            h = h * 31 + MultiKeyMap.computeElementHash(e);
            if (e == null || !e.getClass().isArray() && !(e instanceof Collection)) continue;
            is1D = false;
            break;
        }
        if (is1D) {
            if (len == 1) {
                Object single = Array.get(arr, 0);
                if (single == null) {
                    hashPass[0] = 0;
                    return NULL_SENTINEL;
                }
                hashPass[0] = MultiKeyMap.finalizeHash(MultiKeyMap.computeElementHash(single));
                return single;
            }
            hashPass[0] = MultiKeyMap.finalizeHash(h);
            return arr;
        }
        return this.expandWithHash(arr, hashPass);
    }

    private Object expandWithHash(Object key, int[] hashPass) {
        ArrayList<Object> expanded = new ArrayList<Object>();
        IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
        int[] runningHash = new int[]{1};
        MultiKeyMap.expandAndHash(key, expanded, visited, runningHash, this.flattenDimensions);
        hashPass[0] = MultiKeyMap.finalizeHash(runningHash[0]);
        if (expanded.size() == 1) {
            Object result = expanded.get(0);
            if (result == NULL_SENTINEL) {
                hashPass[0] = 0;
                return NULL_SENTINEL;
            }
            hashPass[0] = MultiKeyMap.finalizeHash(MultiKeyMap.computeElementHash(result));
            return result;
        }
        return expanded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void expandAndHash(Object current, List<Object> result, IdentityHashMap<Object, Boolean> visited, int[] runningHash, boolean useFlatten) {
        if (current == null) {
            result.add(NULL_SENTINEL);
            runningHash[0] = runningHash[0] * 31 + NULL_SENTINEL.hashCode();
            return;
        }
        if (visited.containsKey(current)) {
            String cycle = EMOJI_CYCLE + System.identityHashCode(current);
            result.add(cycle);
            runningHash[0] = runningHash[0] * 31 + cycle.hashCode();
            return;
        }
        if (current.getClass().isArray()) {
            visited.put(current, true);
            try {
                if (!useFlatten) {
                    result.add(OPEN);
                    runningHash[0] = runningHash[0] * 31 + OPEN.hashCode();
                }
                int len = Array.getLength(current);
                for (int i = 0; i < len; ++i) {
                    MultiKeyMap.expandAndHash(Array.get(current, i), result, visited, runningHash, useFlatten);
                }
                if (useFlatten) return;
                result.add(CLOSE);
                runningHash[0] = runningHash[0] * 31 + CLOSE.hashCode();
                return;
            }
            finally {
                visited.remove(current);
            }
        } else if (current instanceof Collection) {
            Collection coll = (Collection)current;
            visited.put(current, true);
            try {
                if (!useFlatten) {
                    result.add(OPEN);
                    runningHash[0] = runningHash[0] * 31 + OPEN.hashCode();
                }
                for (Object e : coll) {
                    MultiKeyMap.expandAndHash(e, result, visited, runningHash, useFlatten);
                }
                if (useFlatten) return;
                result.add(CLOSE);
                runningHash[0] = runningHash[0] * 31 + CLOSE.hashCode();
                return;
            }
            finally {
                visited.remove(current);
            }
        } else {
            result.add(current);
            runningHash[0] = runningHash[0] * 31 + MultiKeyMap.computeElementHash(current);
        }
    }

    private MultiKey<V> findEntry(Object lookupKey) {
        int[] hashPass = new int[1];
        Object normalized = this.normalizeLookup(lookupKey, hashPass, false);
        Object[] currentBuckets = this.buckets;
        int hash = hashPass[0];
        int index = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[index];
        if (chain == null) {
            return null;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !MultiKeyMap.keysMatch(entry.keys, normalized)) continue;
            return entry;
        }
        return null;
    }

    private static boolean keysMatch(Object stored, Object lookup) {
        int lookupLen;
        boolean lookupSingle;
        if (stored == lookup) {
            return true;
        }
        if (stored == null || lookup == null) {
            return false;
        }
        Class<?> storedClazz = stored.getClass();
        Class<?> lookupClazz = lookup.getClass();
        boolean storedSingle = !storedClazz.isArray() && !(stored instanceof Collection);
        boolean bl = lookupSingle = !lookupClazz.isArray() && !(lookup instanceof Collection);
        if (storedSingle != lookupSingle) {
            return false;
        }
        if (storedSingle) {
            return Objects.equals(stored == NULL_SENTINEL ? null : stored, lookup == NULL_SENTINEL ? null : lookup);
        }
        int storedLen = stored instanceof Collection ? ((Collection)stored).size() : Array.getLength(stored);
        int n = lookupLen = lookup instanceof Collection ? ((Collection)lookup).size() : Array.getLength(lookup);
        if (storedLen != lookupLen) {
            return false;
        }
        Class<?> storedClass = stored.getClass();
        Class<?> lookupClass = lookup.getClass();
        if (storedClass == Object[].class && lookupClass == Object[].class) {
            Object[] s = (Object[])stored;
            Object[] l = (Object[])lookup;
            for (int i = 0; i < storedLen; ++i) {
                if (Objects.equals(s[i], l[i])) continue;
                return false;
            }
            return true;
        }
        if (storedClass == String[].class && lookupClass == String[].class) {
            String[] s = (String[])stored;
            String[] l = (String[])lookup;
            for (int i = 0; i < storedLen; ++i) {
                if (Objects.equals(s[i], l[i])) continue;
                return false;
            }
            return true;
        }
        if (storedClass == int[].class && lookupClass == int[].class) {
            int[] s = (int[])stored;
            int[] l = (int[])lookup;
            for (int i = 0; i < storedLen; ++i) {
                if (s[i] == l[i]) continue;
                return false;
            }
            return true;
        }
        if (storedClass == long[].class && lookupClass == long[].class) {
            long[] s = (long[])stored;
            long[] l = (long[])lookup;
            for (int i = 0; i < storedLen; ++i) {
                if (s[i] == l[i]) continue;
                return false;
            }
            return true;
        }
        if (storedClass == double[].class && lookupClass == double[].class) {
            double[] s = (double[])stored;
            double[] l = (double[])lookup;
            for (int i = 0; i < storedLen; ++i) {
                if (s[i] == l[i]) continue;
                return false;
            }
            return true;
        }
        if (storedClass == boolean[].class && lookupClass == boolean[].class) {
            boolean[] s = (boolean[])stored;
            boolean[] l = (boolean[])lookup;
            for (int i = 0; i < storedLen; ++i) {
                if (s[i] == l[i]) continue;
                return false;
            }
            return true;
        }
        if (storedClass == ArrayList.class && lookupClass == ArrayList.class) {
            ArrayList s = (ArrayList)stored;
            ArrayList l = (ArrayList)lookup;
            for (int i = 0; i < storedLen; ++i) {
                if (Objects.equals(s.get(i), l.get(i))) continue;
                return false;
            }
            return true;
        }
        Iterator<?> storedIter = MultiKeyMap.iteratorFor(stored);
        Iterator<?> lookupIter = MultiKeyMap.iteratorFor(lookup);
        while (storedIter.hasNext() && lookupIter.hasNext()) {
            if (Objects.equals(storedIter.next(), lookupIter.next())) continue;
            return false;
        }
        return true;
    }

    private static Iterator<?> iteratorFor(Object obj) {
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        return Collections.singletonList(obj).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putInternal(MultiKey<V> newKey) {
        boolean resize;
        V old;
        int hash = newKey.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        int stripe = hash & STRIPE_MASK;
        boolean contended = lock.hasQueuedThreads();
        lock.lock();
        try {
            this.totalLockAcquisitions.incrementAndGet();
            this.stripeLockAcquisitions[stripe].incrementAndGet();
            if (contended) {
                this.contentionCount.incrementAndGet();
                this.stripeLockContention[stripe].incrementAndGet();
            }
            old = this.putNoLock(newKey);
            resize = (float)this.atomicSize.get() > (float)this.buckets.length * this.loadFactor;
        }
        finally {
            lock.unlock();
        }
        if (resize && this.resizeInProgress.compareAndSet(false, true)) {
            try {
                this.resizeInternal();
            }
            finally {
                this.resizeInProgress.set(false);
            }
        }
        return old;
    }

    private V putNoLock(MultiKey<V> newKey) {
        int hash = newKey.hash;
        int index = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[index];
        if (chain == null) {
            this.buckets[index] = new MultiKey[]{newKey};
            this.atomicSize.incrementAndGet();
            this.updateMaxChainLength(1);
            return null;
        }
        for (int i = 0; i < chain.length; ++i) {
            MultiKey e = chain[i];
            if (e.hash != hash || !MultiKeyMap.keysMatch(e.keys, newKey.keys)) continue;
            Object old = e.value;
            chain[i] = newKey;
            return old;
        }
        MultiKey[] newChain = Arrays.copyOf(chain, chain.length + 1);
        newChain[chain.length] = newKey;
        this.buckets[index] = newChain;
        this.atomicSize.incrementAndGet();
        this.updateMaxChainLength(newChain.length);
        return null;
    }

    public boolean containsMultiKey(Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.containsKey(null);
        }
        if (keys.length == 1) {
            return this.containsKey(keys[0]);
        }
        return this.containsKey(keys);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findEntry(key) != null;
    }

    public V removeMultiKey(Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.remove(null);
        }
        if (keys.length == 1) {
            return this.remove(keys[0]);
        }
        return this.remove(keys);
    }

    @Override
    public V remove(Object key) {
        MultiKey<Object> removeKey = this.createMultiKey(key, null);
        return this.removeInternal(removeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeInternal(MultiKey<V> removeKey) {
        V old;
        int hash = removeKey.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        int stripe = hash & STRIPE_MASK;
        boolean contended = lock.hasQueuedThreads();
        lock.lock();
        try {
            this.totalLockAcquisitions.incrementAndGet();
            this.stripeLockAcquisitions[stripe].incrementAndGet();
            if (contended) {
                this.contentionCount.incrementAndGet();
                this.stripeLockContention[stripe].incrementAndGet();
            }
            old = this.removeNoLock(removeKey);
        }
        finally {
            lock.unlock();
        }
        return old;
    }

    private V removeNoLock(MultiKey<V> removeKey) {
        int hash = removeKey.hash;
        int index = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[index];
        if (chain == null) {
            return null;
        }
        for (int i = 0; i < chain.length; ++i) {
            MultiKey e = chain[i];
            if (e.hash != hash || !MultiKeyMap.keysMatch(e.keys, removeKey.keys)) continue;
            Object old = e.value;
            if (chain.length == 1) {
                this.buckets[index] = null;
            } else {
                System.arraycopy(chain, i + 1, chain, i, chain.length - i - 1);
                this.buckets[index] = Arrays.copyOf(chain, chain.length - 1);
            }
            this.atomicSize.decrementAndGet();
            return old;
        }
        return null;
    }

    private void resizeInternal() {
        this.withAllStripeLocks(() -> {
            double lf = (double)this.atomicSize.get() / (double)this.buckets.length;
            if (lf <= (double)this.loadFactor) {
                return;
            }
            Object[] old = this.buckets;
            Object[] newBuckets = new Object[old.length * 2];
            int newMax = 0;
            this.atomicSize.set(0);
            for (Object b : old) {
                MultiKey[] chain;
                if (b == null) continue;
                for (MultiKey e : chain = (MultiKey[])b) {
                    int len = this.rehashEntry(e, newBuckets);
                    this.atomicSize.incrementAndGet();
                    newMax = Math.max(newMax, len);
                }
            }
            this.maxChainLength.set(newMax);
            this.buckets = newBuckets;
        });
    }

    private int rehashEntry(MultiKey<V> entry, Object[] target) {
        int index = entry.hash & target.length - 1;
        MultiKey[] chain = (MultiKey[])target[index];
        if (chain == null) {
            target[index] = new MultiKey[]{entry};
            return 1;
        }
        MultiKey[] newChain = Arrays.copyOf(chain, chain.length + 1);
        newChain[chain.length] = entry;
        target[index] = newChain;
        return newChain.length;
    }

    @Override
    public int size() {
        return this.atomicSize.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        this.withAllStripeLocks(() -> {
            Arrays.fill(this.buckets, null);
            this.atomicSize.set(0);
            this.maxChainLength.set(0);
        });
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object b : this.buckets) {
            MultiKey[] chain;
            if (b == null) continue;
            for (MultiKey e : chain = (MultiKey[])b) {
                if (!Objects.equals(e.value, value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> set = new HashSet<Object>();
        for (MultiKeyEntry<V> e : this.entries()) {
            set.add(e.keys.length == 1 ? (e.keys[0] == NULL_SENTINEL ? null : e.keys[0]) : e.keys);
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        ArrayList vals = new ArrayList();
        for (MultiKeyEntry<V> e : this.entries()) {
            vals.add(e.value);
        }
        return vals;
    }

    @Override
    public Set<Map.Entry<Object, V>> entrySet() {
        HashSet<Map.Entry<Object, V>> set = new HashSet<Map.Entry<Object, V>>();
        for (MultiKeyEntry<V> e : this.entries()) {
            Object[] k = e.keys.length == 1 ? (e.keys[0] == NULL_SENTINEL ? null : e.keys[0]) : e.keys;
            set.add(new AbstractMap.SimpleEntry(k, e.value));
        }
        return set;
    }

    @Override
    public void putAll(Map<?, ? extends V> m) {
        for (Map.Entry<?, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(Object key, V value) {
        V existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        MultiKey<V> lookupKey = this.createMultiKey(key, value);
        int hash = lookupKey.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            existing = this.get(key);
            if (existing == null) {
                V v = this.put(key, value);
                return v;
            }
            V v = existing;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(Object key, Function<? super Object, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        V v = this.get(key);
        if (v != null) {
            return v;
        }
        int[] hashPass = new int[1];
        this.computeKeyHash(key, hashPass);
        int hash = hashPass[0];
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            v = this.get(key);
            if (v == null && (v = mappingFunction.apply(key)) != null) {
                this.put(key, v);
            }
            V v2 = v;
            return v2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(Object key, BiFunction<? super Object, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        V old = this.get(key);
        if (old == null) {
            return null;
        }
        int[] hashPass = new int[1];
        this.computeKeyHash(key, hashPass);
        int hash = hashPass[0];
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            old = this.get(key);
            if (old == null) {
                V v = null;
                return v;
            }
            V newV = remappingFunction.apply(key, old);
            if (newV != null) {
                this.put(key, newV);
                V v = newV;
                return v;
            }
            this.remove(key);
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(Object key, BiFunction<? super Object, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int[] hashPass = new int[1];
        this.computeKeyHash(key, hashPass);
        int hash = hashPass[0];
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V old = this.get(key);
            V newV = remappingFunction.apply(key, old);
            if (newV == null) {
                if (old != null || this.containsKey(key)) {
                    this.remove(key);
                }
                V v = null;
                return v;
            }
            this.put(key, newV);
            V v = newV;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(Object key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(remappingFunction);
        int[] hashPass = new int[1];
        this.computeKeyHash(key, hashPass);
        int hash = hashPass[0];
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V newV;
            V old = this.get(key);
            V v = newV = old == null ? value : remappingFunction.apply(old, value);
            if (newV == null) {
                this.remove(key);
            } else {
                this.put(key, newV);
            }
            V v2 = newV;
            return v2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        int[] hashPass = new int[1];
        this.computeKeyHash(key, hashPass);
        int hash = hashPass[0];
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V current = this.get(key);
            if (!Objects.equals(current, value)) {
                boolean bl = false;
                return bl;
            }
            this.remove(key);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(Object key, V value) {
        int[] hashPass = new int[1];
        this.computeKeyHash(key, hashPass);
        int hash = hashPass[0];
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            if (!this.containsKey(key)) {
                V v = null;
                return v;
            }
            V v = this.put(key, value);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object key, V oldValue, V newValue) {
        int[] hashPass = new int[1];
        this.computeKeyHash(key, hashPass);
        int hash = hashPass[0];
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V current = this.get(key);
            if (!Objects.equals(current, oldValue)) {
                boolean bl = false;
                return bl;
            }
            this.put(key, newValue);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (MultiKeyEntry<V> e : this.entries()) {
            Integer k = e.keys.length == 1 ? (e.keys[0] == NULL_SENTINEL ? null : e.keys[0]) : Integer.valueOf(Arrays.hashCode(e.keys));
            h += (k == null ? 0 : ((Object)k).hashCode()) ^ (e.value == null ? 0 : e.value.hashCode());
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        for (MultiKeyEntry<V> e : this.entries()) {
            Object[] k;
            Object object = e.keys.length == 1 ? (e.keys[0] == NULL_SENTINEL ? null : e.keys[0]) : (k = e.keys);
            if (!(e.value == null ? m.get(k) != null || !m.containsKey(k) : !e.value.equals(m.get(k)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{\n");
        boolean first = true;
        for (MultiKeyEntry<V> e : this.entries()) {
            if (!first) {
                sb.append(",\n");
            }
            first = false;
            sb.append("  ");
            String keyStr = MultiKeyMap.dumpExpandedKeyStatic(e.keys, true, this);
            if (keyStr.endsWith(", ")) {
                keyStr = keyStr.substring(0, keyStr.length() - 2);
            }
            sb.append(keyStr).append(" \u2192 ");
            sb.append(EMOJI_VALUE);
            sb.append(MultiKeyMap.formatValueForToString(e.value, this));
        }
        return sb.append("\n}").toString();
    }

    public Iterable<MultiKeyEntry<V>> entries() {
        return () -> new EntryIterator();
    }

    private static int calculateOptimalStripeCount() {
        int cores = Runtime.getRuntime().availableProcessors();
        int stripes = Math.max(8, cores / 2);
        stripes = Math.min(32, stripes);
        return Integer.highestOneBit(stripes - 1) << 1;
    }

    public void printContentionStatistics() {
        int totalAcquisitions = this.totalLockAcquisitions.get();
        int totalContentions = this.contentionCount.get();
        int globalAcquisitions = this.globalLockAcquisitions.get();
        int globalContentions = this.globalLockContentions.get();
        LOG.info("=== MultiKeyMap Contention Statistics ===");
        LOG.info("Total lock acquisitions: " + totalAcquisitions);
        LOG.info("Total contentions: " + totalContentions);
        if (totalAcquisitions > 0) {
            double contentionRate = (double)totalContentions / (double)totalAcquisitions * 100.0;
            LOG.info(String.format("Overall contention rate: %.2f%%", contentionRate));
        }
        LOG.info("Global lock acquisitions: " + globalAcquisitions);
        LOG.info("Global lock contentions: " + globalContentions);
        LOG.info("Stripe-level statistics:");
        LOG.info("Stripe | Acquisitions | Contentions | Rate");
        LOG.info("-------|-------------|-------------|------");
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            int acquisitions = this.stripeLockAcquisitions[i].get();
            int contentions = this.stripeLockContention[i].get();
            double rate = acquisitions > 0 ? (double)contentions / (double)acquisitions * 100.0 : 0.0;
            LOG.info(String.format("%6d | %11d | %11d | %5.2f%%", i, acquisitions, contentions, rate));
        }
        int maxContentionStripe = 0;
        int minContentionStripe = 0;
        int maxContentions = this.stripeLockContention[0].get();
        int minContentions = this.stripeLockContention[0].get();
        for (int i = 1; i < STRIPE_COUNT; ++i) {
            int contentions = this.stripeLockContention[i].get();
            if (contentions > maxContentions) {
                maxContentions = contentions;
                maxContentionStripe = i;
            }
            if (contentions >= minContentions) continue;
            minContentions = contentions;
            minContentionStripe = i;
        }
        LOG.info("Stripe distribution analysis:");
        LOG.info(String.format("Most contended stripe: %d (%d contentions)", maxContentionStripe, maxContentions));
        LOG.info(String.format("Least contended stripe: %d (%d contentions)", minContentionStripe, minContentions));
        int unusedStripes = 0;
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            if (this.stripeLockAcquisitions[i].get() != 0) continue;
            ++unusedStripes;
        }
        LOG.info(String.format("Unused stripes: %d out of %d", unusedStripes, STRIPE_COUNT));
        LOG.info("================================================");
    }

    private void withAllStripeLocks(Runnable action) {
        this.lockAllStripes();
        try {
            action.run();
        }
        finally {
            this.unlockAllStripes();
        }
    }

    private static int finalizeHash(int h) {
        return EncryptionUtilities.finalizeHash(h);
    }

    private static void processNestedStructure(StringBuilder sb, List<Object> list, int[] index, MultiKeyMap<?> selfMap) {
        if (index[0] >= list.size()) {
            return;
        }
        int n = index[0];
        index[0] = n + 1;
        Object element = list.get(n);
        if (element == OPEN) {
            sb.append(EMOJI_OPEN);
            boolean first = true;
            while (index[0] < list.size()) {
                Object next = list.get(index[0]);
                if (next == CLOSE) {
                    index[0] = index[0] + 1;
                    sb.append(EMOJI_CLOSE);
                    break;
                }
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                MultiKeyMap.processNestedStructure(sb, list, index, selfMap);
            }
        } else if (element == NULL_SENTINEL) {
            sb.append(EMOJI_EMPTY);
        } else if (selfMap != null && element == selfMap) {
            sb.append(THIS_MAP);
        } else if (element instanceof String && ((String)element).startsWith(EMOJI_CYCLE)) {
            sb.append(element);
        } else {
            sb.append(element);
        }
    }

    private static String dumpExpandedKeyStatic(Object key, boolean forToString, MultiKeyMap<?> selfMap) {
        Object element;
        if (key == null) {
            return forToString ? "\ud83c\udd94 \u2205" : EMOJI_EMPTY;
        }
        if (key == NULL_SENTINEL) {
            return forToString ? "\ud83c\udd94 \u2205" : EMOJI_EMPTY;
        }
        if (key.getClass().isArray() && Array.getLength(key) == 1 && (element = Array.get(key, 0)) instanceof Collection) {
            return MultiKeyMap.dumpExpandedKeyStatic(element, forToString, selfMap);
        }
        if (!key.getClass().isArray() && !(key instanceof Collection)) {
            if (selfMap != null && key == selfMap) {
                return "\ud83c\udd94 (this Map \u267b\ufe0f)";
            }
            return EMOJI_KEY + key;
        }
        if (forToString) {
            StringBuilder sb;
            Object first;
            Collection coll;
            if (key instanceof Collection) {
                coll = (Collection)key;
                boolean isAlreadyFlattened = false;
                if (!coll.isEmpty() && (first = coll.iterator().next()) == OPEN) {
                    isAlreadyFlattened = true;
                }
                if (isAlreadyFlattened) {
                    sb = new StringBuilder();
                    sb.append(EMOJI_KEY);
                    ArrayList<Object> collList = new ArrayList<Object>(coll);
                    int[] index = new int[]{0};
                    MultiKeyMap.processNestedStructure(sb, collList, index, selfMap);
                    return sb.toString();
                }
            }
            if (key.getClass().isArray()) {
                int len = Array.getLength(key);
                boolean isAlreadyFlattenedArray = false;
                if (len > 0 && (first = Array.get(key, 0)) == OPEN) {
                    isAlreadyFlattenedArray = true;
                }
                if (isAlreadyFlattenedArray) {
                    sb = new StringBuilder();
                    sb.append(EMOJI_KEY);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < len; ++i) {
                        arrayList.add(Array.get(key, i));
                    }
                    int[] index = new int[]{0};
                    MultiKeyMap.processNestedStructure(sb, arrayList, index, selfMap);
                    return sb.toString();
                }
                if (len == 1) {
                    Object element2 = Array.get(key, 0);
                    if (element2 == NULL_SENTINEL) {
                        return "\ud83c\udd94 \u2205";
                    }
                    if (selfMap != null && element2 == selfMap) {
                        return "\ud83c\udd94 (this Map \u267b\ufe0f)";
                    }
                    if (element2 == OPEN) {
                        return "\ud83c\udd94 [";
                    }
                    if (element2 == CLOSE) {
                        return "\ud83c\udd94 ]";
                    }
                    return EMOJI_KEY + (element2 != null ? element2.toString() : EMOJI_EMPTY);
                }
                sb = new StringBuilder();
                sb.append(EMOJI_KEY).append(EMOJI_OPEN);
                boolean needsComma = false;
                for (int i = 0; i < len; ++i) {
                    Object element3 = Array.get(key, i);
                    if (element3 == NULL_SENTINEL) {
                        if (needsComma) {
                            sb.append(", ");
                        }
                        sb.append(EMOJI_EMPTY);
                        needsComma = true;
                        continue;
                    }
                    if (element3 == OPEN) {
                        sb.append(EMOJI_OPEN);
                        needsComma = false;
                        continue;
                    }
                    if (element3 == CLOSE) {
                        sb.append(EMOJI_CLOSE);
                        needsComma = true;
                        continue;
                    }
                    if (selfMap != null && element3 == selfMap) {
                        if (needsComma) {
                            sb.append(", ");
                        }
                        sb.append(THIS_MAP);
                        needsComma = true;
                        continue;
                    }
                    if (element3 instanceof String && ((String)element3).startsWith(EMOJI_CYCLE)) {
                        if (needsComma) {
                            sb.append(", ");
                        }
                        sb.append(element3);
                        needsComma = true;
                        continue;
                    }
                    if (needsComma) {
                        sb.append(", ");
                    }
                    if (element3 == NULL_SENTINEL) {
                        sb.append(EMOJI_EMPTY);
                    } else if (element3 == OPEN) {
                        sb.append(EMOJI_OPEN);
                    } else if (element3 == CLOSE) {
                        sb.append(EMOJI_CLOSE);
                    } else {
                        sb.append(element3 != null ? element3.toString() : EMOJI_EMPTY);
                    }
                    needsComma = true;
                }
                sb.append(EMOJI_CLOSE);
                return sb.toString();
            }
            coll = (Collection)key;
            if (coll.size() == 1) {
                Object element4 = coll.iterator().next();
                if (element4 == NULL_SENTINEL) {
                    return "\ud83c\udd94 [\u2205]";
                }
                if (selfMap != null && element4 == selfMap) {
                    return "\ud83c\udd94 (this Map \u267b\ufe0f)";
                }
                if (element4 == OPEN) {
                    return "\ud83c\udd94 [";
                }
                if (element4 == CLOSE) {
                    return "\ud83c\udd94 ]";
                }
                return EMOJI_KEY + (element4 != null ? element4.toString() : EMOJI_EMPTY);
            }
            StringBuilder sb2 = new StringBuilder();
            sb2.append(EMOJI_KEY).append(EMOJI_OPEN);
            boolean needsComma = false;
            for (Object element5 : coll) {
                if (element5 == NULL_SENTINEL) {
                    if (needsComma) {
                        sb2.append(", ");
                    }
                    sb2.append(EMOJI_EMPTY);
                    needsComma = true;
                    continue;
                }
                if (element5 == OPEN) {
                    sb2.append(EMOJI_OPEN);
                    needsComma = false;
                    continue;
                }
                if (element5 == CLOSE) {
                    sb2.append(EMOJI_CLOSE);
                    needsComma = true;
                    continue;
                }
                if (selfMap != null && element5 == selfMap) {
                    if (needsComma) {
                        sb2.append(", ");
                    }
                    sb2.append(THIS_MAP);
                    needsComma = true;
                    continue;
                }
                if (element5 instanceof String && ((String)element5).startsWith(EMOJI_CYCLE)) {
                    if (needsComma) {
                        sb2.append(", ");
                    }
                    sb2.append(element5);
                    needsComma = true;
                    continue;
                }
                if (needsComma) {
                    sb2.append(", ");
                }
                if (element5 == NULL_SENTINEL) {
                    sb2.append(EMOJI_EMPTY);
                } else if (element5 == OPEN) {
                    sb2.append(EMOJI_OPEN);
                } else if (element5 == CLOSE) {
                    sb2.append(EMOJI_CLOSE);
                } else {
                    sb2.append(element5 != null ? element5.toString() : EMOJI_EMPTY);
                }
                needsComma = true;
            }
            sb2.append(EMOJI_CLOSE);
            return sb2.toString();
        }
        ArrayList<Object> expanded = new ArrayList<Object>();
        IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
        int[] dummyHash = new int[]{1};
        MultiKeyMap.expandAndHash(key, expanded, visited, dummyHash, false);
        StringBuilder sb = new StringBuilder();
        sb.append(EMOJI_KEY);
        int[] index = new int[]{0};
        MultiKeyMap.processNestedStructure(sb, expanded, index, selfMap);
        return sb.toString();
    }

    private static String formatValueForToString(Object value, MultiKeyMap<?> selfMap) {
        if (value == null) {
            return EMOJI_EMPTY;
        }
        if (selfMap != null && value == selfMap) {
            return THIS_MAP;
        }
        if (value instanceof Collection || value.getClass().isArray()) {
            return MultiKeyMap.formatComplexValueForToString(value, selfMap);
        }
        return value.toString();
    }

    private static String formatComplexValueForToString(Object value, MultiKeyMap<?> selfMap) {
        if (value == null) {
            return EMOJI_EMPTY;
        }
        if (selfMap != null && value == selfMap) {
            return THIS_MAP;
        }
        if (value.getClass().isArray()) {
            return MultiKeyMap.formatArrayValueForToString(value, selfMap);
        }
        if (value instanceof Collection) {
            return MultiKeyMap.formatCollectionValueForToString((Collection)value, selfMap);
        }
        return value.toString();
    }

    private static String formatArrayValueForToString(Object array, MultiKeyMap<?> selfMap) {
        int len = Array.getLength(array);
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(EMOJI_OPEN);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Object element = Array.get(array, i);
            sb.append(MultiKeyMap.formatValueForToString(element, selfMap));
        }
        sb.append(EMOJI_CLOSE);
        return sb.toString();
    }

    private static String formatCollectionValueForToString(Collection<?> collection, MultiKeyMap<?> selfMap) {
        if (collection.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(EMOJI_OPEN);
        boolean first = true;
        for (Object element : collection) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(MultiKeyMap.formatValueForToString(element, selfMap));
        }
        sb.append(EMOJI_CLOSE);
        return sb.toString();
    }

    static {
        LoggingConfig.init();
        OPEN = new Object(){

            public String toString() {
                return MultiKeyMap.EMOJI_OPEN;
            }

            public int hashCode() {
                return MultiKeyMap.EMOJI_OPEN.hashCode();
            }
        };
        CLOSE = new Object(){

            public String toString() {
                return MultiKeyMap.EMOJI_CLOSE;
            }

            public int hashCode() {
                return MultiKeyMap.EMOJI_CLOSE.hashCode();
            }
        };
        NULL_SENTINEL = new Object(){

            public String toString() {
                return MultiKeyMap.EMOJI_EMPTY;
            }

            public int hashCode() {
                return MultiKeyMap.EMOJI_EMPTY.hashCode();
            }
        };
        STRIPE_CONFIG_LOGGED = new AtomicBoolean(false);
        STRIPE_COUNT = MultiKeyMap.calculateOptimalStripeCount();
        STRIPE_MASK = STRIPE_COUNT - 1;
    }

    public static enum CollectionKeyMode {
        COLLECTIONS_EXPANDED,
        COLLECTIONS_NOT_EXPANDED;

    }

    private static final class MultiKey<V> {
        final Object keys;
        final int hash;
        final V value;

        MultiKey(Object normalizedKeys, int hash, V value) {
            this.keys = normalizedKeys;
            this.hash = hash;
            this.value = value;
        }

        public String toString() {
            return MultiKeyMap.dumpExpandedKeyStatic(this.keys, true, null);
        }
    }

    private static class ArrayIterator
    implements Iterator<Object> {
        private final Object array;
        private final int len;
        private int index = 0;

        ArrayIterator(Object array) {
            this.array = array;
            this.len = Array.getLength(array);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.len;
        }

        @Override
        public Object next() {
            return Array.get(this.array, this.index++);
        }
    }

    public static class MultiKeyEntry<V> {
        public final Object[] keys;
        public final V value;

        MultiKeyEntry(Object k, V v) {
            Object[] objectArray;
            if (k != null && k.getClass() == Object[].class) {
                objectArray = (Object[])k;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = k;
            }
            this.keys = objectArray;
            this.value = v;
        }
    }

    private class EntryIterator
    implements Iterator<MultiKeyEntry<V>> {
        private final Object[] snapshot;
        private int bucketIdx;
        private int chainIdx;
        private MultiKeyEntry<V> next;

        EntryIterator() {
            this.snapshot = MultiKeyMap.this.buckets;
            this.bucketIdx = 0;
            this.chainIdx = 0;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MultiKeyEntry<V> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            MultiKeyEntry current = this.next;
            this.advance();
            return current;
        }

        private void advance() {
            while (this.bucketIdx < this.snapshot.length) {
                MultiKey[] chain = (MultiKey[])this.snapshot[this.bucketIdx];
                if (chain != null && this.chainIdx < chain.length) {
                    MultiKey e = chain[this.chainIdx++];
                    this.next = new MultiKeyEntry(e.keys, e.value);
                    return;
                }
                ++this.bucketIdx;
                this.chainIdx = 0;
            }
            this.next = null;
        }
    }
}

