/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.MultiKeyMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TrackingMap<K, V>
implements Map<K, V> {
    private final Map<K, V> internalMap;
    private final Set<Object> readKeys;

    public TrackingMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot construct a TrackingMap() with null");
        }
        this.internalMap = map;
        this.readKeys = map instanceof ConcurrentMap ? ConcurrentHashMap.newKeySet() : new HashSet();
    }

    @Override
    public V get(Object key) {
        Object result = this.handleArrayCollectionKey(key, processedKey -> {
            MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
            return multiKeyMap.get(processedKey);
        });
        if (result != null || this.internalMap instanceof MultiKeyMap && (key != null && key.getClass().isArray() || key instanceof Collection)) {
            this.trackKeyAccess(key);
            return (V)result;
        }
        V value = this.internalMap.get(key);
        this.readKeys.add(key);
        return value;
    }

    @Override
    public V put(K key, V value) {
        if (this.internalMap instanceof MultiKeyMap) {
            MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
            if (key != null && key.getClass().isArray()) {
                if (key instanceof Object[]) {
                    Object[] objArray = (Object[])key;
                    return (V)multiKeyMap.put((Object)value, objArray);
                }
                if (key instanceof String[]) {
                    String[] strArray = (String[])key;
                    Object[] objArray = new Object[strArray.length];
                    System.arraycopy(strArray, 0, objArray, 0, strArray.length);
                    return (V)multiKeyMap.put((Object)value, objArray);
                }
                return multiKeyMap.put((Object)key, value);
            }
            if (key instanceof Collection) {
                Collection collection = (Collection)key;
                return this.putMultiKey(value, collection.toArray());
            }
        }
        return this.internalMap.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        Boolean result = this.handleArrayCollectionKey(key, processedKey -> {
            MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
            return multiKeyMap.containsKey(processedKey);
        });
        if (result != null) {
            this.trackKeyAccess(key);
            return result;
        }
        boolean containsKey = this.internalMap.containsKey(key);
        this.readKeys.add(key);
        return containsKey;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public V remove(Object key) {
        Object result = this.handleArrayCollectionKey(key, processedKey -> {
            MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
            return multiKeyMap.remove(processedKey);
        });
        if (result != null || this.internalMap instanceof MultiKeyMap && (key != null && key.getClass().isArray() || key instanceof Collection)) {
            this.trackKeyRemoval(key);
            return (V)result;
        }
        this.readKeys.remove(key);
        return this.internalMap.remove(key);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Map && this.internalMap.equals(other);
    }

    @Override
    public int hashCode() {
        return this.internalMap.hashCode();
    }

    public String toString() {
        return this.internalMap.toString();
    }

    @Override
    public void clear() {
        this.readKeys.clear();
        this.internalMap.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<K> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.internalMap.entrySet();
    }

    public void expungeUnused() {
        if (this.internalMap instanceof MultiKeyMap) {
            MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
            ArrayList<Object> keysToRemove = new ArrayList<Object>();
            for (Object mapKey : multiKeyMap.keySet()) {
                if (mapKey instanceof Object[]) {
                    Object[] keyArray = (Object[])mapKey;
                    boolean shouldRemove = false;
                    for (Object component : keyArray) {
                        if (component == null || this.readKeys.contains(component)) continue;
                        shouldRemove = true;
                        break;
                    }
                    if (!shouldRemove) continue;
                    keysToRemove.add(mapKey);
                    continue;
                }
                if (this.readKeys.contains(mapKey)) continue;
                keysToRemove.add(mapKey);
            }
            for (Object keyToRemove : keysToRemove) {
                multiKeyMap.remove(keyToRemove);
            }
            HashSet<Object> stillUsedComponents = new HashSet<Object>();
            for (Object mapKey : multiKeyMap.keySet()) {
                if (mapKey instanceof Object[]) {
                    Object[] keyArray;
                    for (Object component : keyArray = (Object[])mapKey) {
                        if (component == null) continue;
                        stillUsedComponents.add(component);
                    }
                    continue;
                }
                stillUsedComponents.add(mapKey);
            }
            this.readKeys.retainAll(stillUsedComponents);
        } else {
            this.internalMap.keySet().retainAll(this.readKeys);
            this.readKeys.retainAll(this.internalMap.keySet());
        }
    }

    public void informAdditionalUsage(Collection<K> additional) {
        this.readKeys.addAll(additional);
    }

    public void informAdditionalUsage(TrackingMap<K, V> additional) {
        this.readKeys.addAll(additional.readKeys);
    }

    public Set<Object> keysUsed() {
        return Collections.unmodifiableSet(this.readKeys);
    }

    public Map<K, V> getWrappedMap() {
        return this.internalMap;
    }

    public void replaceContents(Map<K, V> map) {
        Convention.throwIfNull(map, "Cannot replace contents with null");
        this.clear();
        this.putAll(map);
    }

    @Deprecated
    public void setWrappedMap(Map<K, V> map) {
        this.replaceContents(map);
    }

    public V putMultiKey(V value, Object ... keys) {
        if (!(this.internalMap instanceof MultiKeyMap)) {
            throw new IllegalStateException("Multi-key operations require the backing map to be a MultiKeyMap instance");
        }
        MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
        return (V)multiKeyMap.put((Object)value, keys);
    }

    public V getMultiKey(Object ... keys) {
        if (!(this.internalMap instanceof MultiKeyMap)) {
            throw new IllegalStateException("Multi-key operations require the backing map to be a MultiKeyMap instance");
        }
        MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
        Object result = multiKeyMap.get(keys);
        if (result != null) {
            for (Object key : keys) {
                if (key == null) continue;
                this.readKeys.add(key);
            }
        }
        return result;
    }

    public V removeMultiKey(Object ... keys) {
        if (!(this.internalMap instanceof MultiKeyMap)) {
            throw new IllegalStateException("Multi-key operations require the backing map to be a MultiKeyMap instance");
        }
        MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
        Object result = multiKeyMap.remove(keys);
        if (result != null) {
            for (Object component : keys) {
                if (component == null) continue;
                boolean componentStillUsed = false;
                for (Object mapKey : multiKeyMap.keySet()) {
                    if (mapKey instanceof Object[]) {
                        Object[] keyArray;
                        for (Object keyComponent : keyArray = (Object[])mapKey) {
                            if (!Objects.equals(component, keyComponent)) continue;
                            componentStillUsed = true;
                            break;
                        }
                    }
                    if (!componentStillUsed) continue;
                    break;
                }
                if (componentStillUsed) continue;
                this.readKeys.remove(component);
            }
            this.readKeys.removeIf(trackedKey -> {
                if (trackedKey instanceof Object[]) {
                    Object[] trackedArray = (Object[])trackedKey;
                    return Arrays.equals(trackedArray, keys);
                }
                return false;
            });
        }
        return result;
    }

    public boolean containsMultiKey(Object ... keys) {
        if (!(this.internalMap instanceof MultiKeyMap)) {
            throw new IllegalStateException("Multi-key operations require the backing map to be a MultiKeyMap instance");
        }
        MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
        boolean exists = multiKeyMap.containsKey(keys);
        if (exists) {
            for (Object key : keys) {
                if (key == null) continue;
                this.readKeys.add(key);
            }
        }
        return exists;
    }

    private <T> T handleArrayCollectionKey(Object key, Function<Object, T> operation) {
        if (!(this.internalMap instanceof MultiKeyMap)) {
            return null;
        }
        MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
        if (key != null && key.getClass().isArray()) {
            if (key instanceof Object[]) {
                return operation.apply(key);
            }
            if (key instanceof String[]) {
                String[] strArray = (String[])key;
                Object[] objArray = new Object[strArray.length];
                System.arraycopy(strArray, 0, objArray, 0, strArray.length);
                return operation.apply(objArray);
            }
            return operation.apply(key);
        }
        if (key instanceof Collection) {
            Collection collection = (Collection)key;
            return this.handleArrayCollectionKey(collection.toArray(), operation);
        }
        return null;
    }

    private void trackKeyAccess(Object key) {
        if (this.internalMap instanceof MultiKeyMap) {
            MultiKeyMap multiKeyMap = (MultiKeyMap)this.internalMap;
            if (key != null && key.getClass().isArray()) {
                if (key instanceof Object[]) {
                    Object[] objArray = (Object[])key;
                    if (multiKeyMap.containsKey(objArray)) {
                        for (Object component : objArray) {
                            if (component == null) continue;
                            this.readKeys.add(component);
                        }
                    }
                } else if (key instanceof String[]) {
                    String[] strArray = (String[])key;
                    Object[] objArray = new Object[strArray.length];
                    System.arraycopy(strArray, 0, objArray, 0, strArray.length);
                    if (multiKeyMap.containsKey(objArray)) {
                        for (String component : strArray) {
                            if (component == null) continue;
                            this.readKeys.add(component);
                        }
                    }
                } else if (multiKeyMap.containsKey(key)) {
                    this.readKeys.add(key);
                }
            } else if (key instanceof Collection) {
                Collection collection = (Collection)key;
                Object[] objArray = collection.toArray();
                if (multiKeyMap.containsKey(objArray)) {
                    for (Object component : collection) {
                        if (component == null) continue;
                        this.readKeys.add(component);
                    }
                }
            } else if (multiKeyMap.containsKey(key)) {
                this.readKeys.add(key);
            }
        } else {
            this.readKeys.add(key);
        }
    }

    private void trackKeyRemoval(Object key) {
        if (this.internalMap instanceof MultiKeyMap) {
            if (key != null && key.getClass().isArray()) {
                if (key instanceof Object[]) {
                    Object[] objArray;
                    for (Object component : objArray = (Object[])key) {
                        if (component == null) continue;
                        this.readKeys.remove(component);
                    }
                } else if (key instanceof String[]) {
                    String[] strArray;
                    for (String component : strArray = (String[])key) {
                        if (component == null) continue;
                        this.readKeys.remove(component);
                    }
                } else {
                    this.readKeys.remove(key);
                }
            } else if (key instanceof Collection) {
                Collection collection = (Collection)key;
                for (Object component : collection) {
                    if (component == null) continue;
                    this.readKeys.remove(component);
                }
            } else {
                this.readKeys.remove(key);
            }
        } else {
            this.readKeys.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (this.internalMap instanceof ConcurrentMap) {
            return this.internalMap.putIfAbsent(key, value);
        }
        TrackingMap trackingMap = this;
        synchronized (trackingMap) {
            V existing = this.internalMap.get(key);
            if (existing == null) {
                return this.internalMap.put(key, value);
            }
            return existing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        boolean removed;
        if (this.internalMap instanceof ConcurrentMap) {
            removed = this.internalMap.remove(key, value);
        } else {
            TrackingMap trackingMap = this;
            synchronized (trackingMap) {
                V curValue = this.internalMap.get(key);
                if (Objects.equals(curValue, value)) {
                    this.internalMap.remove(key);
                    removed = true;
                } else {
                    removed = false;
                }
            }
        }
        if (removed) {
            this.readKeys.remove(key);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.internalMap instanceof ConcurrentMap) {
            return this.internalMap.replace(key, oldValue, newValue);
        }
        TrackingMap trackingMap = this;
        synchronized (trackingMap) {
            V curValue = this.internalMap.get(key);
            if (Objects.equals(curValue, oldValue)) {
                this.internalMap.put(key, newValue);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        if (this.internalMap instanceof ConcurrentMap) {
            return this.internalMap.replace(key, value);
        }
        TrackingMap trackingMap = this;
        synchronized (trackingMap) {
            if (this.internalMap.containsKey(key)) {
                return this.internalMap.put(key, value);
            }
            return null;
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V result = this.internalMap.computeIfAbsent((K)key, mappingFunction);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result = this.internalMap.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result = this.internalMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V result = this.internalMap.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V result = this.internalMap.getOrDefault(key, defaultValue);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.internalMap.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.internalMap.replaceAll(function);
    }

    public Map.Entry<K, V> lowerEntry(K key) {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry entry = ((NavigableMap)this.internalMap).lowerEntry(key);
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public K lowerKey(K key) {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        K result = ((NavigableMap)this.internalMap).lowerKey(key);
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public Map.Entry<K, V> floorEntry(K key) {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry entry = ((NavigableMap)this.internalMap).floorEntry(key);
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public K floorKey(K key) {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        K result = ((NavigableMap)this.internalMap).floorKey(key);
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public Map.Entry<K, V> ceilingEntry(K key) {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry entry = ((NavigableMap)this.internalMap).ceilingEntry(key);
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public K ceilingKey(K key) {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        K result = ((NavigableMap)this.internalMap).ceilingKey(key);
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public Map.Entry<K, V> higherEntry(K key) {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry entry = ((NavigableMap)this.internalMap).higherEntry(key);
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public K higherKey(K key) {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        K result = ((NavigableMap)this.internalMap).higherKey(key);
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public Map.Entry<K, V> firstEntry() {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry entry = ((NavigableMap)this.internalMap).firstEntry();
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public Map.Entry<K, V> lastEntry() {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry entry = ((NavigableMap)this.internalMap).lastEntry();
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public Map.Entry<K, V> pollFirstEntry() {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry entry = ((NavigableMap)this.internalMap).pollFirstEntry();
        if (entry != null) {
            this.readKeys.remove(entry.getKey());
        }
        return entry;
    }

    public Map.Entry<K, V> pollLastEntry() {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry entry = ((NavigableMap)this.internalMap).pollLastEntry();
        if (entry != null) {
            this.readKeys.remove(entry.getKey());
        }
        return entry;
    }

    public NavigableSet<K> navigableKeySet() {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        return ((NavigableMap)this.internalMap).navigableKeySet();
    }

    public NavigableSet<K> descendingKeySet() {
        if (!(this.internalMap instanceof NavigableMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        return ((NavigableMap)this.internalMap).descendingKeySet();
    }

    public TrackingMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (this.internalMap instanceof ConcurrentNavigableMap) {
            NavigableMap subMap = ((ConcurrentNavigableMap)this.internalMap).subMap((Object)fromKey, fromInclusive, (Object)toKey, toInclusive);
            return new TrackingMap<K, V>(subMap);
        }
        if (this.internalMap instanceof NavigableMap) {
            NavigableMap subMap = ((NavigableMap)this.internalMap).subMap(fromKey, fromInclusive, toKey, toInclusive);
            return new TrackingMap(subMap);
        }
        throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
    }

    public TrackingMap<K, V> headMap(K toKey, boolean inclusive) {
        if (this.internalMap instanceof ConcurrentNavigableMap) {
            NavigableMap headMap = ((ConcurrentNavigableMap)this.internalMap).headMap((Object)toKey, inclusive);
            return new TrackingMap<K, V>(headMap);
        }
        if (this.internalMap instanceof NavigableMap) {
            NavigableMap headMap = ((NavigableMap)this.internalMap).headMap(toKey, inclusive);
            return new TrackingMap(headMap);
        }
        throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
    }

    public TrackingMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (this.internalMap instanceof ConcurrentNavigableMap) {
            NavigableMap tailMap = ((ConcurrentNavigableMap)this.internalMap).tailMap((Object)fromKey, inclusive);
            return new TrackingMap<K, V>(tailMap);
        }
        if (this.internalMap instanceof NavigableMap) {
            NavigableMap tailMap = ((NavigableMap)this.internalMap).tailMap(fromKey, inclusive);
            return new TrackingMap(tailMap);
        }
        throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
    }

    public Comparator<? super K> comparator() {
        if (!(this.internalMap instanceof SortedMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support SortedMap operations");
        }
        return ((SortedMap)this.internalMap).comparator();
    }

    public TrackingMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public TrackingMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    public TrackingMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    public K firstKey() {
        if (!(this.internalMap instanceof SortedMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support SortedMap operations");
        }
        Object result = ((SortedMap)this.internalMap).firstKey();
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public K lastKey() {
        if (!(this.internalMap instanceof SortedMap)) {
            throw new UnsupportedOperationException("Wrapped map does not support SortedMap operations");
        }
        Object result = ((SortedMap)this.internalMap).lastKey();
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }
}

