/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ByteUtilities;
import com.cedarsoftware.util.ExceptionUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtilities {
    private EncryptionUtilities() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastMD5(File file) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getMD5Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getMD5Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String calculateStreamHash(InputStream in, MessageDigest digest) {
        int BUFFER_SIZE = 65536;
        byte[] buffer = new byte[65536];
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        return ByteUtilities.encode(digest.digest());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA1(File file) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA1Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA1Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA256(File file) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA256Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA256Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA384(File file) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA384Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA384Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA512(File file) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA512Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA512Digest());
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA3_256(File file) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA3_256Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA3_256Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA3_512(File file) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA3_512Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA3_512Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String calculateFileHash(FileChannel channel, MessageDigest digest) {
        int BUFFER_SIZE = 65536;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        try {
            while (channel.read(buffer) != -1) {
                buffer.flip();
                digest.update(buffer);
                buffer.clear();
            }
            return ByteUtilities.encode(digest.digest());
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    public static String calculateMD5Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getMD5Digest(), bytes);
    }

    public static MessageDigest getDigest(String digest) {
        try {
            return MessageDigest.getInstance(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("The requested MessageDigest (%s) does not exist", digest), e);
        }
    }

    public static MessageDigest getMD5Digest() {
        return EncryptionUtilities.getDigest("MD5");
    }

    public static String calculateSHA1Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA1Digest(), bytes);
    }

    public static MessageDigest getSHA1Digest() {
        return EncryptionUtilities.getDigest("SHA-1");
    }

    public static String calculateSHA256Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA256Digest(), bytes);
    }

    public static MessageDigest getSHA256Digest() {
        return EncryptionUtilities.getDigest("SHA-256");
    }

    public static String calculateSHA384Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA384Digest(), bytes);
    }

    public static MessageDigest getSHA384Digest() {
        return EncryptionUtilities.getDigest("SHA-384");
    }

    public static String calculateSHA512Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA512Digest(), bytes);
    }

    public static MessageDigest getSHA512Digest() {
        return EncryptionUtilities.getDigest("SHA-512");
    }

    public static String calculateSHA3_256Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA3_256Digest(), bytes);
    }

    public static MessageDigest getSHA3_256Digest() {
        return EncryptionUtilities.getDigest("SHA3-256");
    }

    public static String calculateSHA3_512Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA3_512Digest(), bytes);
    }

    public static MessageDigest getSHA3_512Digest() {
        return EncryptionUtilities.getDigest("SHA3-512");
    }

    public static byte[] deriveKey(String password, byte[] salt, int bitsNeeded) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 65536, bitsNeeded);
            return factory.generateSecret(spec).getEncoded();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to derive key", e);
        }
    }

    public static byte[] createCipherBytes(String key, int bitsNeeded) {
        String word = EncryptionUtilities.calculateMD5Hash(key.getBytes(StandardCharsets.UTF_8));
        return word.substring(0, bitsNeeded / 8).getBytes(StandardCharsets.UTF_8);
    }

    @Deprecated
    public static Cipher createAesEncryptionCipher(String key) {
        return EncryptionUtilities.createAesCipher(key, 1);
    }

    @Deprecated
    public static Cipher createAesDecryptionCipher(String key) {
        return EncryptionUtilities.createAesCipher(key, 2);
    }

    @Deprecated
    public static Cipher createAesCipher(String key, int mode) {
        SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.createCipherBytes(key, 128), "AES");
        return EncryptionUtilities.createAesCipher(sKey, mode);
    }

    @Deprecated
    public static Cipher createAesCipher(Key key, int mode) {
        MessageDigest d = EncryptionUtilities.getMD5Digest();
        d.update(key.getEncoded());
        byte[] iv = d.digest();
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        try {
            cipher.init(mode, key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        return cipher;
    }

    public static String encrypt(String key, String content) {
        if (key == null || content == null) {
            throw new IllegalArgumentException("key and content cannot be null");
        }
        try {
            SecureRandom random = new SecureRandom();
            byte[] salt = new byte[16];
            random.nextBytes(salt);
            byte[] iv = new byte[12];
            random.nextBytes(iv);
            SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.deriveKey(key, salt, 128), "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)sKey, new GCMParameterSpec(128, iv));
            byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            byte[] out = new byte[1 + salt.length + iv.length + encrypted.length];
            out[0] = 1;
            System.arraycopy(salt, 0, out, 1, salt.length);
            System.arraycopy(iv, 0, out, 1 + salt.length, iv.length);
            System.arraycopy(encrypted, 0, out, 1 + salt.length + iv.length, encrypted.length);
            return ByteUtilities.encode(out);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred encrypting data", e);
        }
    }

    public static String encryptBytes(String key, byte[] content) {
        if (key == null || content == null) {
            throw new IllegalArgumentException("key and content cannot be null");
        }
        try {
            SecureRandom random = new SecureRandom();
            byte[] salt = new byte[16];
            random.nextBytes(salt);
            byte[] iv = new byte[12];
            random.nextBytes(iv);
            SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.deriveKey(key, salt, 128), "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)sKey, new GCMParameterSpec(128, iv));
            byte[] encrypted = cipher.doFinal(content);
            byte[] out = new byte[1 + salt.length + iv.length + encrypted.length];
            out[0] = 1;
            System.arraycopy(salt, 0, out, 1, salt.length);
            System.arraycopy(iv, 0, out, 1 + salt.length, iv.length);
            System.arraycopy(encrypted, 0, out, 1 + salt.length + iv.length, encrypted.length);
            return ByteUtilities.encode(out);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred encrypting data", e);
        }
    }

    public static String decrypt(String key, String hexStr) {
        if (key == null || hexStr == null) {
            throw new IllegalArgumentException("key and hexStr cannot be null");
        }
        byte[] data = ByteUtilities.decode(hexStr);
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Invalid hexadecimal input");
        }
        try {
            if (data[0] == 1 && data.length > 29) {
                byte[] salt = Arrays.copyOfRange(data, 1, 17);
                byte[] iv = Arrays.copyOfRange(data, 17, 29);
                byte[] cipherText = Arrays.copyOfRange(data, 29, data.length);
                SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.deriveKey(key, salt, 128), "AES");
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(2, (Key)sKey, new GCMParameterSpec(128, iv));
                return new String(cipher.doFinal(cipherText), StandardCharsets.UTF_8);
            }
            return new String(EncryptionUtilities.createAesDecryptionCipher(key).doFinal(data), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred decrypting data", e);
        }
    }

    public static byte[] decryptBytes(String key, String hexStr) {
        if (key == null || hexStr == null) {
            throw new IllegalArgumentException("key and hexStr cannot be null");
        }
        byte[] data = ByteUtilities.decode(hexStr);
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Invalid hexadecimal input");
        }
        try {
            if (data[0] == 1 && data.length > 29) {
                byte[] salt = Arrays.copyOfRange(data, 1, 17);
                byte[] iv = Arrays.copyOfRange(data, 17, 29);
                byte[] cipherText = Arrays.copyOfRange(data, 29, data.length);
                SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.deriveKey(key, salt, 128), "AES");
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(2, (Key)sKey, new GCMParameterSpec(128, iv));
                return cipher.doFinal(cipherText);
            }
            return EncryptionUtilities.createAesDecryptionCipher(key).doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred decrypting data", e);
        }
    }

    public static String calculateHash(MessageDigest d, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        d.update(bytes);
        return ByteUtilities.encode(d.digest());
    }
}

