/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LRUCache<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private static final long DELAY = 10L;
    private final int capacity;
    private final ConcurrentHashMap<K, Node<K, V>> cache;
    private volatile boolean cleanupScheduled = false;

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.cache = new ConcurrentHashMap(capacity);
    }

    private void cleanup() {
        int size = this.cache.size();
        if (size > this.capacity) {
            ArrayList<Node<K, V>> nodes = new ArrayList<Node<K, V>>(this.cache.values());
            nodes.sort(Comparator.comparingLong(node -> node.timestamp));
            int nodesToRemove = size - this.capacity;
            for (int i = 0; i < nodesToRemove; ++i) {
                Node node2 = (Node)nodes.get(i);
                this.cache.remove(node2.key, node2);
            }
        }
        this.cleanupScheduled = false;
        if (this.cache.size() > this.capacity) {
            this.scheduleCleanup();
        }
    }

    @Override
    public V get(Object key) {
        Node<K, V> node = this.cache.get(key);
        if (node != null) {
            node.updateTimestamp();
            return node.value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Node<K, V> newNode = new Node<K, V>(key, value);
        Node<K, V> oldNode = this.cache.put(key, newNode);
        if (oldNode != null) {
            newNode.updateTimestamp();
            return oldNode.value;
        }
        this.scheduleCleanup();
        return null;
    }

    @Override
    public V remove(Object key) {
        Node<K, V> node = this.cache.remove(key);
        if (node != null) {
            this.scheduleCleanup();
            return node.value;
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node<K, V> node : this.cache.values()) {
            if (!node.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> entrySet = Collections.newSetFromMap(new ConcurrentHashMap());
        for (Node<K, V> node : this.cache.values()) {
            entrySet.add(new AbstractMap.SimpleEntry(node.key, node.value));
        }
        return entrySet;
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (Node<K, V> node : this.cache.values()) {
            values.add(node.value);
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.entrySet().equals(other.entrySet());
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Node<K, V> node : this.cache.values()) {
            hashCode = 31 * hashCode + (node.key == null ? 0 : node.key.hashCode());
            hashCode = 31 * hashCode + (node.value == null ? 0 : node.value.hashCode());
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Node<K, V> node : this.cache.values()) {
            sb.append(node.key).append("=").append(node.value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }

    private synchronized void scheduleCleanup() {
        if (this.cache.size() > this.capacity && !this.cleanupScheduled) {
            this.cleanupScheduled = true;
            executorService.schedule(this::cleanup, 10L, TimeUnit.MILLISECONDS);
        }
    }

    private static class Node<K, V> {
        final K key;
        volatile V value;
        volatile long timestamp;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
            this.timestamp = System.nanoTime();
        }

        void updateTimestamp() {
            this.timestamp = System.nanoTime();
        }
    }
}

