/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.MathUtilities;
import java.util.Random;

public final class StringUtilities {
    private static final char[] _hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String FOLDER_SEPARATOR = "/";

    private StringUtilities() {
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return str1 == str2;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean equalsWithTrim(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.trim().equals(s2.trim());
    }

    public static boolean equalsIgnoreCaseWithTrim(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.trim().equalsIgnoreCase(s2.trim());
    }

    public static boolean isEmpty(String s) {
        return StringUtilities.trimLength(s) == 0;
    }

    public static boolean hasContent(String s) {
        return StringUtilities.trimLength(s) != 0;
    }

    public static int length(String s) {
        return s == null ? 0 : s.length();
    }

    public static int trimLength(String s) {
        return s == null ? 0 : s.trim().length();
    }

    public static int lastIndexOf(String path, char ch) {
        if (path == null) {
            return -1;
        }
        return path.lastIndexOf(ch);
    }

    public static byte[] decode(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[len / 2];
        int pos = 0;
        for (int i = 0; i < len; i += 2) {
            byte hi = (byte)Character.digit(s.charAt(i), 16);
            byte lo = (byte)Character.digit(s.charAt(i + 1), 16);
            bytes[pos++] = (byte)(hi * 16 + lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length << 1);
        int len = bytes.length;
        for (byte aByte : bytes) {
            sb.append(StringUtilities.convertDigit(aByte >> 4));
            sb.append(StringUtilities.convertDigit(aByte & 0xF));
        }
        return sb.toString();
    }

    private static char convertDigit(int value) {
        return _hex[value & 0xF];
    }

    public static int count(String s, char c) {
        if (StringUtilities.isEmpty(s)) {
            return 0;
        }
        int count = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static int levenshteinDistance(CharSequence s, CharSequence t) {
        if (s == null || "".equals(s)) {
            return t == null || "".equals(t) ? 0 : t.length();
        }
        if (t == null || "".equals(t)) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (int i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        int sLen = s.length();
        int tLen = t.length();
        for (int i = 0; i < sLen; ++i) {
            v1[0] = i + 1;
            for (int j = 0; j < tLen; ++j) {
                int cost = s.charAt(i) == t.charAt(j) ? 0 : 1;
                v1[j + 1] = (int)MathUtilities.minimum(new long[]{v1[j] + 1, v0[j + 1] + 1, v0[j] + cost});
            }
            System.arraycopy(v1, 0, v0, 0, v0.length);
        }
        return v1[t.length()];
    }

    public static int damerauLevenshteinDistance(CharSequence source, CharSequence target) {
        if (source == null || "".equals(source)) {
            return target == null || "".equals(target) ? 0 : target.length();
        }
        if (target == null || "".equals(target)) {
            return source.length();
        }
        int srcLen = source.length();
        int targetLen = target.length();
        int[][] distanceMatrix = new int[srcLen + 1][targetLen + 1];
        for (int srcIndex = 0; srcIndex <= srcLen; ++srcIndex) {
            distanceMatrix[srcIndex][0] = srcIndex;
        }
        for (int targetIndex = 0; targetIndex <= targetLen; ++targetIndex) {
            distanceMatrix[0][targetIndex] = targetIndex;
        }
        int cost = 0;
        for (int srcIndex = 1; srcIndex <= srcLen; ++srcIndex) {
            for (int targetIndex = 1; targetIndex <= targetLen; ++targetIndex) {
                cost = source.charAt(srcIndex - 1) == target.charAt(targetIndex - 1) ? 0 : 1;
                distanceMatrix[srcIndex][targetIndex] = (int)MathUtilities.minimum(new long[]{distanceMatrix[srcIndex - 1][targetIndex] + 1, distanceMatrix[srcIndex][targetIndex - 1] + 1, distanceMatrix[srcIndex - 1][targetIndex - 1] + cost});
                if (srcIndex == 1 || targetIndex == 1 || source.charAt(srcIndex - 1) != target.charAt(targetIndex - 2) || source.charAt(srcIndex - 2) != target.charAt(targetIndex - 1)) continue;
                distanceMatrix[srcIndex][targetIndex] = (int)MathUtilities.minimum(new long[]{distanceMatrix[srcIndex][targetIndex], distanceMatrix[srcIndex - 2][targetIndex - 2] + cost});
            }
        }
        return distanceMatrix[srcLen][targetLen];
    }

    public static String getRandomString(Random random, int minLen, int maxLen) {
        StringBuilder s = new StringBuilder();
        int length = minLen + random.nextInt(maxLen - minLen + 1);
        for (int i = 0; i < length; ++i) {
            s.append(StringUtilities.getRandomChar(random, i == 0));
        }
        return s.toString();
    }

    public static String getRandomChar(Random random, boolean upper) {
        int r = random.nextInt(26);
        return upper ? "" + (char)(65 + r) : "" + (char)(97 + r);
    }
}

